/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.chain;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.chain.ChainMapper;
import org.apache.hadoop.mapreduce.lib.chain.ChainReducer;

public class TestChainErrors
extends HadoopTestCase {
    private static String localPathRoot = System.getProperty("test.build.data", "/tmp");
    private Path inDir = new Path(localPathRoot, "testing/chain/input");
    private Path outDir = new Path(localPathRoot, "testing/chain/output");
    private String input = "a\nb\nc\nd\n";

    public TestChainErrors() throws IOException {
        super(1, 4, 1, 1);
    }

    public void testChainSubmission() throws Exception {
        JobConf conf = this.createJobConf();
        Job job = MapReduceTestUtil.createJob(conf, this.inDir, this.outDir, 0, 0, this.input);
        job.setJobName("chain");
        IllegalArgumentException th = null;
        try {
            ChainMapper.addMapper(job, Mapper.class, LongWritable.class, Text.class, IntWritable.class, Text.class, null);
            ChainMapper.addMapper(job, Mapper.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        }
        catch (IllegalArgumentException iae) {
            th = iae;
        }
        TestChainErrors.assertTrue((th != null ? 1 : 0) != 0);
        th = null;
        try {
            ChainReducer.setReducer(job, Reducer.class, LongWritable.class, Text.class, IntWritable.class, Text.class, null);
            ChainMapper.addMapper(job, Mapper.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        }
        catch (IllegalArgumentException iae) {
            th = iae;
        }
        TestChainErrors.assertTrue((th != null ? 1 : 0) != 0);
    }

    public void testChainFail() throws Exception {
        JobConf conf = this.createJobConf();
        Job job = MapReduceTestUtil.createJob(conf, this.inDir, this.outDir, 1, 0, this.input);
        job.setJobName("chain");
        ChainMapper.addMapper(job, Mapper.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        ChainMapper.addMapper(job, FailMap.class, LongWritable.class, Text.class, IntWritable.class, Text.class, null);
        ChainMapper.addMapper(job, Mapper.class, IntWritable.class, Text.class, LongWritable.class, Text.class, null);
        job.waitForCompletion(true);
        TestChainErrors.assertTrue((String)"Job Not failed", (!job.isSuccessful() ? 1 : 0) != 0);
    }

    public void testReducerFail() throws Exception {
        JobConf conf = this.createJobConf();
        Job job = MapReduceTestUtil.createJob(conf, this.inDir, this.outDir, 1, 1, this.input);
        job.setJobName("chain");
        ChainMapper.addMapper(job, Mapper.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        ChainReducer.setReducer(job, FailReduce.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        ChainReducer.addMapper(job, Mapper.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        job.waitForCompletion(true);
        TestChainErrors.assertTrue((String)"Job Not failed", (!job.isSuccessful() ? 1 : 0) != 0);
    }

    public void testChainMapNoOuptut() throws Exception {
        JobConf conf = this.createJobConf();
        String expectedOutput = "";
        Job job = MapReduceTestUtil.createJob(conf, this.inDir, this.outDir, 1, 0, this.input);
        job.setJobName("chain");
        ChainMapper.addMapper(job, ConsumeMap.class, IntWritable.class, Text.class, LongWritable.class, Text.class, null);
        ChainMapper.addMapper(job, Mapper.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        job.waitForCompletion(true);
        TestChainErrors.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
        TestChainErrors.assertEquals((String)"Outputs doesn't match", (String)expectedOutput, (String)MapReduceTestUtil.readOutput(this.outDir, conf));
    }

    public void testChainReduceNoOuptut() throws Exception {
        JobConf conf = this.createJobConf();
        String expectedOutput = "";
        Job job = MapReduceTestUtil.createJob(conf, this.inDir, this.outDir, 1, 1, this.input);
        job.setJobName("chain");
        ChainMapper.addMapper(job, Mapper.class, IntWritable.class, Text.class, LongWritable.class, Text.class, null);
        ChainReducer.setReducer(job, ConsumeReduce.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        ChainReducer.addMapper(job, Mapper.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        job.waitForCompletion(true);
        TestChainErrors.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
        TestChainErrors.assertEquals((String)"Outputs doesn't match", (String)expectedOutput, (String)MapReduceTestUtil.readOutput(this.outDir, conf));
    }

    public static class FailReduce
    extends Reducer<LongWritable, Text, LongWritable, Text> {
        @Override
        public void reduce(LongWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            throw new IOException();
        }
    }

    public static class FailMap
    extends Mapper<LongWritable, Text, IntWritable, Text> {
        @Override
        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            if (value.toString().equals("b")) {
                throw new IOException();
            }
        }
    }

    public static class ConsumeReduce
    extends Reducer<LongWritable, Text, LongWritable, Text> {
        @Override
        public void reduce(LongWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        }
    }

    public static class ConsumeMap
    extends Mapper<LongWritable, Text, LongWritable, Text> {
        @Override
        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        }
    }
}

