/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.Assert;
import org.junit.Test;

public class TestLineRecordReaderJobs {
    private static Path workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestTextInputFormat");
    private static Path inputDir = new Path(workDir, "input");
    private static Path outputDir = new Path(workDir, "output");

    public void createInputFile(Configuration conf) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal(conf);
        Path file = new Path(inputDir, "test.txt");
        OutputStreamWriter writer = new OutputStreamWriter(localFs.create(file));
        writer.write("abc\ndef\t\nghi\njkl");
        ((Writer)writer).close();
    }

    public String readOutputFile(Configuration conf) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal(conf);
        Path file = new Path(outputDir, "part-r-00000");
        return UtilsForTests.slurpHadoop(file, localFs);
    }

    public void createAndRunJob(Configuration conf) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = Job.getInstance(conf);
        job.setJarByClass(TestLineRecordReaderJobs.class);
        job.setMapperClass(Mapper.class);
        job.setReducerClass(Reducer.class);
        FileInputFormat.addInputPath(job, inputDir);
        FileOutputFormat.setOutputPath(job, outputDir);
        job.waitForCompletion(true);
    }

    @Test
    public void testCustomRecordDelimiters() throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration();
        conf.set("textinputformat.record.delimiter", "\t\n");
        LocalFileSystem localFs = FileSystem.getLocal(conf);
        ((FileSystem)localFs).delete(workDir, true);
        this.createInputFile(conf);
        this.createAndRunJob(conf);
        String expected = "0\tabc\ndef\n9\tghi\njkl\n";
        Assert.assertEquals((Object)expected, (Object)this.readOutputFile(conf));
    }

    @Test
    public void testDefaultRecordDelimiters() throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration();
        LocalFileSystem localFs = FileSystem.getLocal(conf);
        ((FileSystem)localFs).delete(workDir, true);
        this.createInputFile(conf);
        this.createAndRunJob(conf);
        String expected = "0\tabc\n4\tdef\t\n9\tghi\n13\tjkl\n";
        Assert.assertEquals((Object)expected, (Object)this.readOutputFile(conf));
    }
}

