/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.jobcontrol;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.jobcontrol.ControlledJob;
import org.apache.hadoop.mapreduce.lib.jobcontrol.JobControl;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMapReduceJobControlWithMocks {
    @Test
    public void testSuccessfulJobs() throws Exception {
        JobControl jobControl = new JobControl("Test");
        ControlledJob job1 = this.createSuccessfulControlledJob(jobControl, new ControlledJob[0]);
        ControlledJob job2 = this.createSuccessfulControlledJob(jobControl, new ControlledJob[0]);
        ControlledJob job3 = this.createSuccessfulControlledJob(jobControl, job1, job2);
        ControlledJob job4 = this.createSuccessfulControlledJob(jobControl, job3);
        this.runJobControl(jobControl);
        junit.framework.Assert.assertEquals((String)"Success list", (int)4, (int)jobControl.getSuccessfulJobList().size());
        junit.framework.Assert.assertEquals((String)"Failed list", (int)0, (int)jobControl.getFailedJobList().size());
        Assert.assertTrue((job1.getJobState() == ControlledJob.State.SUCCESS ? 1 : 0) != 0);
        Assert.assertTrue((job2.getJobState() == ControlledJob.State.SUCCESS ? 1 : 0) != 0);
        Assert.assertTrue((job3.getJobState() == ControlledJob.State.SUCCESS ? 1 : 0) != 0);
        Assert.assertTrue((job4.getJobState() == ControlledJob.State.SUCCESS ? 1 : 0) != 0);
        jobControl.stop();
    }

    @Test
    public void testFailedJob() throws Exception {
        JobControl jobControl = new JobControl("Test");
        ControlledJob job1 = this.createFailedControlledJob(jobControl, new ControlledJob[0]);
        ControlledJob job2 = this.createSuccessfulControlledJob(jobControl, new ControlledJob[0]);
        ControlledJob job3 = this.createSuccessfulControlledJob(jobControl, job1, job2);
        ControlledJob job4 = this.createSuccessfulControlledJob(jobControl, job3);
        this.runJobControl(jobControl);
        junit.framework.Assert.assertEquals((String)"Success list", (int)1, (int)jobControl.getSuccessfulJobList().size());
        junit.framework.Assert.assertEquals((String)"Failed list", (int)3, (int)jobControl.getFailedJobList().size());
        Assert.assertTrue((job1.getJobState() == ControlledJob.State.FAILED ? 1 : 0) != 0);
        Assert.assertTrue((job2.getJobState() == ControlledJob.State.SUCCESS ? 1 : 0) != 0);
        Assert.assertTrue((job3.getJobState() == ControlledJob.State.DEPENDENT_FAILED ? 1 : 0) != 0);
        Assert.assertTrue((job4.getJobState() == ControlledJob.State.DEPENDENT_FAILED ? 1 : 0) != 0);
        jobControl.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorWhileSubmitting() throws Exception {
        JobControl jobControl = new JobControl("Test");
        Job mockJob = (Job)Mockito.mock(Job.class);
        ControlledJob job1 = new ControlledJob(mockJob, null);
        Mockito.when((Object)mockJob.getConfiguration()).thenReturn((Object)new Configuration());
        ((Job)Mockito.doThrow((Throwable)new IncompatibleClassChangeError("This is a test")).when((Object)mockJob)).submit();
        jobControl.addJob(job1);
        this.runJobControl(jobControl);
        try {
            junit.framework.Assert.assertEquals((String)"Success list", (int)0, (int)jobControl.getSuccessfulJobList().size());
            junit.framework.Assert.assertEquals((String)"Failed list", (int)1, (int)jobControl.getFailedJobList().size());
            Assert.assertTrue((job1.getJobState() == ControlledJob.State.FAILED ? 1 : 0) != 0);
        }
        finally {
            jobControl.stop();
        }
    }

    @Test
    public void testKillJob() throws Exception {
        JobControl jobControl = new JobControl("Test");
        ControlledJob job = this.createFailedControlledJob(jobControl, new ControlledJob[0]);
        job.killJob();
        ((Job)Mockito.verify((Object)job.getJob())).killJob();
    }

    private Job createJob(boolean complete, boolean successful) throws IOException, InterruptedException {
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getConfiguration()).thenReturn((Object)new Configuration());
        Mockito.when((Object)mockJob.isComplete()).thenReturn((Object)complete);
        Mockito.when((Object)mockJob.isSuccessful()).thenReturn((Object)successful);
        return mockJob;
    }

    private ControlledJob createControlledJob(JobControl jobControl, boolean successful, ControlledJob ... dependingJobs) throws IOException, InterruptedException {
        List<ControlledJob> dependingJobsList = dependingJobs == null ? null : Arrays.asList(dependingJobs);
        ControlledJob job = new ControlledJob(this.createJob(true, successful), dependingJobsList);
        jobControl.addJob(job);
        return job;
    }

    private ControlledJob createSuccessfulControlledJob(JobControl jobControl, ControlledJob ... dependingJobs) throws IOException, InterruptedException {
        return this.createControlledJob(jobControl, true, dependingJobs);
    }

    private ControlledJob createFailedControlledJob(JobControl jobControl, ControlledJob ... dependingJobs) throws IOException, InterruptedException {
        return this.createControlledJob(jobControl, false, dependingJobs);
    }

    private void runJobControl(JobControl jobControl) {
        Thread controller = new Thread(jobControl);
        controller.start();
        this.waitTillAllFinished(jobControl);
    }

    private void waitTillAllFinished(JobControl jobControl) {
        while (!jobControl.allFinished()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

