/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;

public class TestTotalOrderPartitioner
extends TestCase {
    private static final Text[] splitStrings = new Text[]{new Text("aabbb"), new Text("babbb"), new Text("daddd"), new Text("dddee"), new Text("ddhee"), new Text("dingo"), new Text("hijjj"), new Text("n"), new Text("yak")};
    private static final ArrayList<Check<Text>> testStrings = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends WritableComparable<?>> Path writePartitionFile(String testname, Configuration conf, T[] splits) throws IOException {
        LocalFileSystem fs = FileSystem.getLocal(conf);
        Path testdir = new Path(System.getProperty("test.build.data", "/tmp")).makeQualified(fs);
        Path p = new Path(testdir, testname + "/_partition.lst");
        TotalOrderPartitioner.setPartitionFile(conf, p);
        conf.setInt("mapreduce.job.reduces", splits.length + 1);
        SequenceFile.Writer w = null;
        try {
            w = SequenceFile.createWriter(fs, conf, p, splits[0].getClass(), NullWritable.class, SequenceFile.CompressionType.NONE);
            for (int i = 0; i < splits.length; ++i) {
                w.append((Writable)splits[i], NullWritable.get());
            }
        }
        finally {
            if (null != w) {
                w.close();
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTotalOrderMemCmp() throws Exception {
        TotalOrderPartitioner<WritableComparable, NullWritable> partitioner = new TotalOrderPartitioner<WritableComparable, NullWritable>();
        Configuration conf = new Configuration();
        Path p = TestTotalOrderPartitioner.writePartitionFile((String)"totalordermemcmp", (Configuration)conf, (WritableComparable[])splitStrings);
        conf.setClass("mapreduce.map.output.key.class", Text.class, Object.class);
        try {
            partitioner.setConf(conf);
            NullWritable nw = NullWritable.get();
            for (Check<Text> chk : testStrings) {
                TestTotalOrderPartitioner.assertEquals((String)((Text)chk.data).toString(), (int)chk.part, (int)partitioner.getPartition((WritableComparable)chk.data, nw, splitStrings.length + 1));
            }
        }
        finally {
            p.getFileSystem(conf).delete(p, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTotalOrderBinarySearch() throws Exception {
        TotalOrderPartitioner<WritableComparable, NullWritable> partitioner = new TotalOrderPartitioner<WritableComparable, NullWritable>();
        Configuration conf = new Configuration();
        Path p = TestTotalOrderPartitioner.writePartitionFile((String)"totalorderbinarysearch", (Configuration)conf, (WritableComparable[])splitStrings);
        conf.setBoolean("mapreduce.totalorderpartitioner.naturalorder", false);
        conf.setClass("mapreduce.map.output.key.class", Text.class, Object.class);
        try {
            partitioner.setConf(conf);
            NullWritable nw = NullWritable.get();
            for (Check<Text> chk : testStrings) {
                TestTotalOrderPartitioner.assertEquals((String)((Text)chk.data).toString(), (int)chk.part, (int)partitioner.getPartition((WritableComparable)chk.data, nw, splitStrings.length + 1));
            }
        }
        finally {
            p.getFileSystem(conf).delete(p, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTotalOrderCustomComparator() throws Exception {
        TotalOrderPartitioner<WritableComparable, NullWritable> partitioner = new TotalOrderPartitioner<WritableComparable, NullWritable>();
        Configuration conf = new Configuration();
        WritableComparable[] revSplitStrings = Arrays.copyOf(splitStrings, splitStrings.length);
        Arrays.sort(revSplitStrings, new ReverseStringComparator());
        Path p = TestTotalOrderPartitioner.writePartitionFile((String)"totalordercustomcomparator", (Configuration)conf, (WritableComparable[])revSplitStrings);
        conf.setBoolean("mapreduce.totalorderpartitioner.naturalorder", false);
        conf.setClass("mapreduce.map.output.key.class", Text.class, Object.class);
        conf.setClass("mapreduce.job.output.key.comparator.class", ReverseStringComparator.class, RawComparator.class);
        ArrayList<Check<Text>> revCheck = new ArrayList<Check<Text>>();
        revCheck.add(new Check<Text>(new Text("aaaaa"), 9));
        revCheck.add(new Check<Text>(new Text("aaabb"), 9));
        revCheck.add(new Check<Text>(new Text("aabbb"), 9));
        revCheck.add(new Check<Text>(new Text("aaaaa"), 9));
        revCheck.add(new Check<Text>(new Text("babbb"), 8));
        revCheck.add(new Check<Text>(new Text("baabb"), 8));
        revCheck.add(new Check<Text>(new Text("yai"), 1));
        revCheck.add(new Check<Text>(new Text("yak"), 1));
        revCheck.add(new Check<Text>(new Text("z"), 0));
        revCheck.add(new Check<Text>(new Text("ddngo"), 4));
        revCheck.add(new Check<Text>(new Text("hi"), 3));
        try {
            partitioner.setConf(conf);
            NullWritable nw = NullWritable.get();
            for (Check check : revCheck) {
                TestTotalOrderPartitioner.assertEquals((String)((Text)check.data).toString(), (int)check.part, (int)partitioner.getPartition((WritableComparable)check.data, nw, splitStrings.length + 1));
            }
        }
        finally {
            p.getFileSystem(conf).delete(p, true);
        }
    }

    static {
        testStrings.add(new Check<Text>(new Text("aaaaa"), 0));
        testStrings.add(new Check<Text>(new Text("aaabb"), 0));
        testStrings.add(new Check<Text>(new Text("aabbb"), 1));
        testStrings.add(new Check<Text>(new Text("aaaaa"), 0));
        testStrings.add(new Check<Text>(new Text("babbb"), 2));
        testStrings.add(new Check<Text>(new Text("baabb"), 1));
        testStrings.add(new Check<Text>(new Text("yai"), 8));
        testStrings.add(new Check<Text>(new Text("yak"), 9));
        testStrings.add(new Check<Text>(new Text("z"), 9));
        testStrings.add(new Check<Text>(new Text("ddngo"), 5));
        testStrings.add(new Check<Text>(new Text("hi"), 6));
    }

    public static class ReverseStringComparator
    implements RawComparator<Text> {
        @Override
        public int compare(Text a, Text b) {
            return -a.compareTo(b);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int n1 = WritableUtils.decodeVIntSize(b1[s1]);
            int n2 = WritableUtils.decodeVIntSize(b2[s2]);
            return -1 * WritableComparator.compareBytes(b1, s1 + n1, l1 - n1, b2, s2 + n2, l2 - n2);
        }
    }

    static class Check<T> {
        T data;
        int part;

        Check(T data, int part) {
            this.data = data;
            this.part = part;
        }
    }
}

