/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.JsonNode;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.map.ObjectMapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMNMInfo;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMNMInfo {
    private static final Log LOG = LogFactory.getLog(TestRMNMInfo.class);
    private static final int NUMNODEMANAGERS = 4;
    protected static MiniMRYarnCluster mrCluster;
    private static Configuration initialConf;
    private static FileSystem localFs;
    private static Path TEST_ROOT_DIR;
    static Path APP_JAR;

    @BeforeClass
    public static void setup() throws IOException {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        if (mrCluster == null) {
            mrCluster = new MiniMRYarnCluster(TestRMNMInfo.class.getName(), 4);
            Configuration conf = new Configuration();
            mrCluster.init(conf);
            mrCluster.start();
        }
        localFs.copyFromLocalFile(new Path(MiniMRYarnCluster.APPJAR), APP_JAR);
        localFs.setPermission(APP_JAR, new FsPermission("700"));
    }

    @AfterClass
    public static void tearDown() {
        if (mrCluster != null) {
            mrCluster.stop();
            mrCluster = null;
        }
    }

    @Test
    public void testRMNMInfo() throws Exception {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        RMContext rmc = mrCluster.getResourceManager().getRMContext();
        ResourceScheduler rms = mrCluster.getResourceManager().getResourceScheduler();
        RMNMInfo rmInfo = new RMNMInfo(rmc, rms);
        String liveNMs = rmInfo.getLiveNodeManagers();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jn = mapper.readTree(liveNMs);
        Assert.assertEquals((String)"Unexpected number of live nodes:", (long)4L, (long)jn.size());
        for (JsonNode n : jn) {
            Assert.assertNotNull((Object)n.get("HostName"));
            Assert.assertNotNull((Object)n.get("Rack"));
            Assert.assertTrue((String)("Node " + n.get("NodeId") + " should be RUNNING"), (boolean)n.get("State").getValueAsText().contains("RUNNING"));
            Assert.assertNotNull((Object)n.get("NodeHTTPAddress"));
            Assert.assertNotNull((Object)n.get("LastHealthUpdate"));
            Assert.assertNotNull((Object)n.get("HealthReport"));
            Assert.assertNotNull((Object)n.get("NodeManagerVersion"));
            Assert.assertNotNull((Object)n.get("NumContainers"));
            Assert.assertEquals((String)(n.get("NodeId") + ": Unexpected number of used containers"), (long)0L, (long)n.get("NumContainers").getValueAsInt());
            Assert.assertEquals((String)(n.get("NodeId") + ": Unexpected amount of used memory"), (long)0L, (long)n.get("UsedMemoryMB").getValueAsInt());
            Assert.assertNotNull((Object)n.get("AvailableMemoryMB"));
        }
    }

    @Test
    public void testRMNMInfoMissmatch() throws Exception {
        RMContext rmc = (RMContext)Mockito.mock(RMContext.class);
        ResourceScheduler rms = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        ConcurrentHashMap<NodeId, RMNode> map = new ConcurrentHashMap<NodeId, RMNode>();
        RMNode node = MockNodes.newNodeInfo((int)1, (Resource)MockNodes.newResource((int)4096));
        map.put(node.getNodeID(), node);
        Mockito.when(rmc.getRMNodes()).thenReturn(map);
        RMNMInfo rmInfo = new RMNMInfo(rmc, rms);
        String liveNMs = rmInfo.getLiveNodeManagers();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jn = mapper.readTree(liveNMs);
        Assert.assertEquals((String)"Unexpected number of live nodes:", (long)1L, (long)jn.size());
        for (JsonNode n : jn) {
            Assert.assertNotNull((Object)n.get("HostName"));
            Assert.assertNotNull((Object)n.get("Rack"));
            Assert.assertTrue((String)("Node " + n.get("NodeId") + " should be RUNNING"), (boolean)n.get("State").getValueAsText().contains("RUNNING"));
            Assert.assertNotNull((Object)n.get("NodeHTTPAddress"));
            Assert.assertNotNull((Object)n.get("LastHealthUpdate"));
            Assert.assertNotNull((Object)n.get("HealthReport"));
            Assert.assertNotNull((Object)n.get("NodeManagerVersion"));
            Assert.assertNull((Object)n.get("NumContainers"));
            Assert.assertNull((Object)n.get("UsedMemoryMB"));
            Assert.assertNull((Object)n.get("AvailableMemoryMB"));
        }
    }

    static {
        initialConf = new Configuration();
        try {
            localFs = FileSystem.getLocal(initialConf);
        }
        catch (IOException io) {
            throw new RuntimeException("problem getting local fs", io);
        }
        TEST_ROOT_DIR = new Path("target", TestRMNMInfo.class.getName() + "-tmpDir").makeQualified(localFs.getUri(), localFs.getWorkingDirectory());
        APP_JAR = new Path(TEST_ROOT_DIR, "MRAppJar.jar");
    }
}

