/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.mapreduce.v2.hs.protocol.HSAdminRefreshProtocol;
import org.apache.hadoop.mapreduce.v2.hs.protocolPB.HSAdminRefreshProtocolClientSideTranslatorPB;
import org.apache.hadoop.mapreduce.v2.hs.protocolPB.HSAdminRefreshProtocolPB;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolClientSideTranslatorPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolPB;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolClientSideTranslatorPB;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolPB;

@InterfaceAudience.Private
public class HSProxies {
    private static final Log LOG = LogFactory.getLog(HSProxies.class);

    public static <T> T createProxy(Configuration conf, InetSocketAddress hsaddr, Class<T> xface, UserGroupInformation ugi) throws IOException {
        Object proxy;
        if (xface == RefreshUserMappingsProtocol.class) {
            proxy = HSProxies.createHSProxyWithRefreshUserMappingsProtocol(hsaddr, conf, ugi);
        } else if (xface == GetUserMappingsProtocol.class) {
            proxy = HSProxies.createHSProxyWithGetUserMappingsProtocol(hsaddr, conf, ugi);
        } else if (xface == HSAdminRefreshProtocol.class) {
            proxy = HSProxies.createHSProxyWithHSAdminRefreshProtocol(hsaddr, conf, ugi);
        } else {
            String message = "Unsupported protocol found when creating the proxy connection to History server: " + (xface != null ? xface.getClass().getName() : "null");
            LOG.error((Object)message);
            throw new IllegalStateException(message);
        }
        return (T)proxy;
    }

    private static RefreshUserMappingsProtocol createHSProxyWithRefreshUserMappingsProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi) throws IOException {
        RefreshUserMappingsProtocolPB proxy = (RefreshUserMappingsProtocolPB)HSProxies.createHSProxy(address, conf, ugi, RefreshUserMappingsProtocolPB.class, 0);
        return new RefreshUserMappingsProtocolClientSideTranslatorPB(proxy);
    }

    private static GetUserMappingsProtocol createHSProxyWithGetUserMappingsProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi) throws IOException {
        GetUserMappingsProtocolPB proxy = (GetUserMappingsProtocolPB)HSProxies.createHSProxy(address, conf, ugi, GetUserMappingsProtocolPB.class, 0);
        return new GetUserMappingsProtocolClientSideTranslatorPB(proxy);
    }

    private static HSAdminRefreshProtocol createHSProxyWithHSAdminRefreshProtocol(InetSocketAddress hsaddr, Configuration conf, UserGroupInformation ugi) throws IOException {
        HSAdminRefreshProtocolPB proxy = (HSAdminRefreshProtocolPB)HSProxies.createHSProxy(hsaddr, conf, ugi, HSAdminRefreshProtocolPB.class, 0);
        return new HSAdminRefreshProtocolClientSideTranslatorPB(proxy);
    }

    private static Object createHSProxy(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, Class<?> xface, int rpcTimeout) throws IOException {
        RPC.setProtocolEngine(conf, xface, ProtobufRpcEngine.class);
        Object proxy = RPC.getProxy(xface, RPC.getProtocolVersion(xface), address, ugi, conf, NetUtils.getDefaultSocketFactory(conf), rpcTimeout);
        return proxy;
    }
}

