/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.v2.api.MRDelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerStateStoreService;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JHSDelegationTokenSecretManager
extends AbstractDelegationTokenSecretManager<MRDelegationTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(JHSDelegationTokenSecretManager.class);
    private HistoryServerStateStoreService store;

    public JHSDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, HistoryServerStateStoreService store) {
        super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        this.store = store;
    }

    @Override
    public MRDelegationTokenIdentifier createIdentifier() {
        return new MRDelegationTokenIdentifier();
    }

    @Override
    protected void storeNewMasterKey(DelegationKey key) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing master key " + key.getKeyId()));
        }
        try {
            this.store.storeTokenMasterKey(key);
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to store master key " + key.getKeyId()), (Throwable)e);
        }
    }

    @Override
    protected void removeStoredMasterKey(DelegationKey key) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing master key " + key.getKeyId()));
        }
        try {
            this.store.removeTokenMasterKey(key);
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to remove master key " + key.getKeyId()), (Throwable)e);
        }
    }

    @Override
    protected void storeNewToken(MRDelegationTokenIdentifier tokenId, long renewDate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing token " + tokenId.getSequenceNumber()));
        }
        try {
            this.store.storeToken(tokenId, renewDate);
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to store token " + tokenId.getSequenceNumber()), (Throwable)e);
        }
    }

    @Override
    protected void removeStoredToken(MRDelegationTokenIdentifier tokenId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing token " + tokenId.getSequenceNumber()));
        }
        try {
            this.store.removeToken(tokenId);
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to remove token " + tokenId.getSequenceNumber()), (Throwable)e);
        }
    }

    @Override
    protected void updateStoredToken(MRDelegationTokenIdentifier tokenId, long renewDate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating token " + tokenId.getSequenceNumber()));
        }
        try {
            this.store.updateToken(tokenId, renewDate);
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to update token " + tokenId.getSequenceNumber()), (Throwable)e);
        }
    }

    public void recover(HistoryServerStateStoreService.HistoryServerState state) throws IOException {
        LOG.info((Object)("Recovering " + this.getClass().getSimpleName()));
        for (DelegationKey delegationKey : state.tokenMasterKeyState) {
            this.addKey(delegationKey);
        }
        for (Map.Entry entry : state.tokenState.entrySet()) {
            this.addPersistedDelegationToken((AbstractDelegationTokenIdentifier)entry.getKey(), (Long)entry.getValue());
        }
    }
}

