/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.jobhistory;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobIndexInfo;

public class FileNameIndexUtils {
    static final int JOB_NAME_TRIM_LENGTH = 50;
    static final String DELIMITER = "-";
    static final String DELIMITER_ESCAPE = "%2D";
    private static final Log LOG = LogFactory.getLog(FileNameIndexUtils.class);
    private static final int JOB_ID_INDEX = 0;
    private static final int SUBMIT_TIME_INDEX = 1;
    private static final int USER_INDEX = 2;
    private static final int JOB_NAME_INDEX = 3;
    private static final int FINISH_TIME_INDEX = 4;
    private static final int NUM_MAPS_INDEX = 5;
    private static final int NUM_REDUCES_INDEX = 6;
    private static final int JOB_STATUS_INDEX = 7;
    private static final int QUEUE_NAME_INDEX = 8;
    private static final int JOB_START_TIME_INDEX = 9;

    public static String getDoneFileName(JobIndexInfo indexInfo) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(FileNameIndexUtils.escapeDelimiters(TypeConverter.fromYarn(indexInfo.getJobId()).toString()));
        sb.append(DELIMITER);
        sb.append(indexInfo.getSubmitTime());
        sb.append(DELIMITER);
        sb.append(FileNameIndexUtils.escapeDelimiters(FileNameIndexUtils.getUserName(indexInfo)));
        sb.append(DELIMITER);
        sb.append(FileNameIndexUtils.escapeDelimiters(FileNameIndexUtils.trimJobName(FileNameIndexUtils.getJobName(indexInfo))));
        sb.append(DELIMITER);
        sb.append(indexInfo.getFinishTime());
        sb.append(DELIMITER);
        sb.append(indexInfo.getNumMaps());
        sb.append(DELIMITER);
        sb.append(indexInfo.getNumReduces());
        sb.append(DELIMITER);
        sb.append(indexInfo.getJobStatus());
        sb.append(DELIMITER);
        sb.append(FileNameIndexUtils.escapeDelimiters(FileNameIndexUtils.getQueueName(indexInfo)));
        sb.append(DELIMITER);
        sb.append(indexInfo.getJobStartTime());
        sb.append(".jhist");
        return FileNameIndexUtils.encodeJobHistoryFileName(sb.toString());
    }

    public static JobIndexInfo getIndexInfo(String jhFileName) throws IOException {
        String fileName = jhFileName.substring(0, jhFileName.indexOf(".jhist"));
        JobIndexInfo indexInfo = new JobIndexInfo();
        String[] jobDetails = fileName.split(DELIMITER);
        JobID oldJobId = JobID.forName(FileNameIndexUtils.decodeJobHistoryFileName(jobDetails[0]));
        JobId jobId = TypeConverter.toYarn(oldJobId);
        indexInfo.setJobId(jobId);
        try {
            try {
                indexInfo.setSubmitTime(Long.parseLong(FileNameIndexUtils.decodeJobHistoryFileName(jobDetails[1])));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Unable to parse submit time from job history file " + jhFileName + " : " + e));
            }
            indexInfo.setUser(FileNameIndexUtils.decodeJobHistoryFileName(jobDetails[2]));
            indexInfo.setJobName(FileNameIndexUtils.decodeJobHistoryFileName(jobDetails[3]));
            try {
                indexInfo.setFinishTime(Long.parseLong(FileNameIndexUtils.decodeJobHistoryFileName(jobDetails[4])));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Unable to parse finish time from job history file " + jhFileName + " : " + e));
            }
            try {
                indexInfo.setNumMaps(Integer.parseInt(FileNameIndexUtils.decodeJobHistoryFileName(jobDetails[5])));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Unable to parse num maps from job history file " + jhFileName + " : " + e));
            }
            try {
                indexInfo.setNumReduces(Integer.parseInt(FileNameIndexUtils.decodeJobHistoryFileName(jobDetails[6])));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Unable to parse num reduces from job history file " + jhFileName + " : " + e));
            }
            indexInfo.setJobStatus(FileNameIndexUtils.decodeJobHistoryFileName(jobDetails[7]));
            indexInfo.setQueueName(FileNameIndexUtils.decodeJobHistoryFileName(jobDetails[8]));
            try {
                indexInfo.setJobStartTime(Long.parseLong(FileNameIndexUtils.decodeJobHistoryFileName(jobDetails[9])));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Unable to parse launch time from job history file " + jhFileName + " : " + e));
            }
        }
        catch (IndexOutOfBoundsException e) {
            LOG.warn((Object)("Parsing job history file with partial data encoded into name: " + jhFileName));
        }
        return indexInfo;
    }

    public static String encodeJobHistoryFileName(String logFileName) throws IOException {
        String replacementDelimiterEscape = null;
        if (logFileName.contains(DELIMITER_ESCAPE)) {
            replacementDelimiterEscape = FileNameIndexUtils.nonOccursString(logFileName);
            logFileName = logFileName.replaceAll(DELIMITER_ESCAPE, replacementDelimiterEscape);
        }
        String encodedFileName = null;
        try {
            encodedFileName = URLEncoder.encode(logFileName, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            IOException ioe = new IOException();
            ioe.initCause(uee);
            ioe.setStackTrace(uee.getStackTrace());
            throw ioe;
        }
        if (replacementDelimiterEscape != null) {
            encodedFileName = encodedFileName.replaceAll(replacementDelimiterEscape, DELIMITER_ESCAPE);
        }
        return encodedFileName;
    }

    public static String decodeJobHistoryFileName(String logFileName) throws IOException {
        String decodedFileName = null;
        try {
            decodedFileName = URLDecoder.decode(logFileName, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            IOException ioe = new IOException();
            ioe.initCause(uee);
            ioe.setStackTrace(uee.getStackTrace());
            throw ioe;
        }
        return decodedFileName;
    }

    static String nonOccursString(String logFileName) {
        int adHocIndex = 0;
        String unfoundString = "q" + adHocIndex;
        while (logFileName.contains(unfoundString)) {
            unfoundString = "q" + ++adHocIndex;
        }
        return unfoundString + "q";
    }

    private static String getUserName(JobIndexInfo indexInfo) {
        return FileNameIndexUtils.getNonEmptyString(indexInfo.getUser());
    }

    private static String getJobName(JobIndexInfo indexInfo) {
        return FileNameIndexUtils.getNonEmptyString(indexInfo.getJobName());
    }

    private static String getQueueName(JobIndexInfo indexInfo) {
        return FileNameIndexUtils.getNonEmptyString(indexInfo.getQueueName());
    }

    private static String getNonEmptyString(String in) {
        if (in == null || in.length() == 0) {
            in = "NA";
        }
        return in;
    }

    private static String escapeDelimiters(String escapee) {
        return escapee.replaceAll(DELIMITER, DELIMITER_ESCAPE);
    }

    private static String trimJobName(String jobName) {
        if (jobName.length() > 50) {
            jobName = jobName.substring(0, 50);
        }
        return jobName;
    }
}

