/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.metrics2.util.Quantile;
import org.apache.hadoop.metrics2.util.SampleQuantiles;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSampleQuantiles {
    static final Quantile[] quantiles = new Quantile[]{new Quantile(0.5, 0.05), new Quantile(0.75, 0.025), new Quantile(0.9, 0.01), new Quantile(0.95, 0.005), new Quantile(0.99, 0.001)};
    SampleQuantiles estimator;

    @Before
    public void init() {
        this.estimator = new SampleQuantiles(quantiles);
    }

    @Test
    public void testCount() throws IOException {
        Assert.assertEquals((long)this.estimator.getCount(), (long)0L);
        Assert.assertEquals((long)this.estimator.getSampleCount(), (long)0L);
        Assert.assertNull(this.estimator.snapshot());
        this.estimator.insert(1337L);
        Assert.assertEquals((long)this.estimator.getCount(), (long)1L);
        this.estimator.snapshot();
        Assert.assertEquals((long)this.estimator.getSampleCount(), (long)1L);
        Assert.assertEquals((Object)"50.00 %ile +/- 5.00%: 1337\n75.00 %ile +/- 2.50%: 1337\n90.00 %ile +/- 1.00%: 1337\n95.00 %ile +/- 0.50%: 1337\n99.00 %ile +/- 0.10%: 1337", (Object)this.estimator.toString());
    }

    @Test
    public void testClear() throws IOException {
        for (int i = 0; i < 1000; ++i) {
            this.estimator.insert(i);
        }
        this.estimator.clear();
        Assert.assertEquals((long)this.estimator.getCount(), (long)0L);
        Assert.assertEquals((long)this.estimator.getSampleCount(), (long)0L);
        Assert.assertNull(this.estimator.snapshot());
    }

    @Test
    public void testQuantileError() throws IOException {
        int i;
        int count = 100000;
        Random r = new Random(-559030611L);
        Long[] values = new Long[100000];
        for (i = 0; i < 100000; ++i) {
            values[i] = i + 1;
        }
        for (i = 0; i < 10; ++i) {
            System.out.println("Starting run " + i);
            Collections.shuffle(Arrays.asList(values), r);
            this.estimator.clear();
            for (int j = 0; j < 100000; ++j) {
                this.estimator.insert(values[j]);
            }
            Map<Quantile, Long> snapshot = this.estimator.snapshot();
            for (Quantile q : quantiles) {
                long actual = (long)(q.quantile * 100000.0);
                long error = (long)(q.error * 100000.0);
                long estimate = snapshot.get(q);
                System.out.println(String.format("Expected %d with error %d, estimated %d", actual, error, estimate));
                Assert.assertTrue((estimate <= actual + error ? 1 : 0) != 0);
                Assert.assertTrue((estimate >= actual - error ? 1 : 0) != 0);
            }
        }
    }
}

