/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.naming.NameNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;

public class TestDNS {
    private static final Log LOG = LogFactory.getLog(TestDNS.class);
    private static final String DEFAULT = "default";

    @Test
    public void testGetLocalHost() throws Exception {
        String hostname = DNS.getDefaultHost(DEFAULT);
        Assert.assertNotNull((Object)hostname);
    }

    @Test
    public void testGetLocalHostIsFast() throws Exception {
        String hostname1 = DNS.getDefaultHost(DEFAULT);
        Assert.assertNotNull((Object)hostname1);
        String hostname2 = DNS.getDefaultHost(DEFAULT);
        long t1 = Time.now();
        String hostname3 = DNS.getDefaultHost(DEFAULT);
        long t2 = Time.now();
        Assert.assertEquals((Object)hostname3, (Object)hostname2);
        Assert.assertEquals((Object)hostname2, (Object)hostname1);
        long interval = t2 - t1;
        Assert.assertTrue((String)"Took too long to determine local host - caching is not working", (interval < 20000L ? 1 : 0) != 0);
    }

    @Test
    public void testLocalHostHasAnAddress() throws Exception {
        Assert.assertNotNull((Object)this.getLocalIPAddr());
    }

    private InetAddress getLocalIPAddr() throws UnknownHostException {
        String hostname = DNS.getDefaultHost(DEFAULT);
        InetAddress localhost = InetAddress.getByName(hostname);
        return localhost;
    }

    @Test
    public void testNullInterface() throws Exception {
        try {
            String host = DNS.getDefaultHost(null);
            Assert.fail((String)("Expected a NullPointerException, got " + host));
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            String ip = DNS.getDefaultIP(null);
            Assert.fail((String)("Expected a NullPointerException, got " + ip));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testIPsOfUnknownInterface() throws Exception {
        try {
            DNS.getIPs("name-of-an-unknown-interface");
            Assert.fail((String)"Got an IP for a bogus interface");
        }
        catch (UnknownHostException e) {
            Assert.assertEquals((Object)"No such interface name-of-an-unknown-interface", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetIPWithDefault() throws Exception {
        String[] ips = DNS.getIPs(DEFAULT);
        Assert.assertEquals((String)"Should only return 1 default IP", (long)1L, (long)ips.length);
        Assert.assertEquals((Object)this.getLocalIPAddr().getHostAddress(), (Object)ips[0].toString());
        String ip = DNS.getDefaultIP(DEFAULT);
        Assert.assertEquals((Object)ip, (Object)ips[0].toString());
    }

    @Test
    public void testRDNS() throws Exception {
        block2: {
            InetAddress localhost = this.getLocalIPAddr();
            try {
                String s = DNS.reverseDns(localhost, null);
                LOG.info((Object)("Local revers DNS hostname is " + s));
            }
            catch (NameNotFoundException e) {
                if (localhost.isLinkLocalAddress() && !localhost.isLoopbackAddress()) break block2;
                LOG.info((Object)"Reverse DNS failing as due to incomplete networking", (Throwable)e);
                LOG.info((Object)("Address is " + localhost + " Loopback=" + localhost.isLoopbackAddress() + " Linklocal=" + localhost.isLinkLocalAddress()));
            }
        }
    }

    @Test
    public void testLocalhostResolves() throws Exception {
        InetAddress localhost = InetAddress.getByName("localhost");
        Assert.assertNotNull((String)"localhost is null", (Object)localhost);
        LOG.info((Object)("Localhost IPAddr is " + localhost.toString()));
    }
}

