/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestSaslRPC;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenInfo;
import org.junit.Before;
import org.junit.Test;

public class TestDoAsEffectiveUser {
    private static final String REAL_USER_NAME = "realUser1@HADOOP.APACHE.ORG";
    private static final String REAL_USER_SHORT_NAME = "realUser1";
    private static final String PROXY_USER_NAME = "proxyUser";
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String[] GROUP_NAMES = new String[]{"group1", "group2"};
    private static final String ADDRESS = "0.0.0.0";
    private TestProtocol proxy;
    private static final Configuration masterConf = new Configuration();
    public static final Log LOG = LogFactory.getLog(TestDoAsEffectiveUser.class);

    @Before
    public void setMasterConf() {
        UserGroupInformation.setConfiguration(masterConf);
    }

    private void configureSuperUserIPAddresses(Configuration conf, String superUserShortName) throws IOException {
        ArrayList<String> ipList = new ArrayList<String>();
        Enumeration<NetworkInterface> netInterfaceList = NetworkInterface.getNetworkInterfaces();
        while (netInterfaceList.hasMoreElements()) {
            NetworkInterface inf = netInterfaceList.nextElement();
            Enumeration<InetAddress> addrList = inf.getInetAddresses();
            while (addrList.hasMoreElements()) {
                InetAddress addr = addrList.nextElement();
                ipList.add(addr.getHostAddress());
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String ip : ipList) {
            builder.append(ip);
            builder.append(',');
        }
        builder.append("127.0.1.1,");
        builder.append(InetAddress.getLocalHost().getCanonicalHostName());
        LOG.info((Object)("Local Ip addresses: " + builder.toString()));
        conf.setStrings(ProxyUsers.getProxySuperuserIpConfKey(superUserShortName), builder.toString());
    }

    @Test
    public void testCreateProxyUser() throws Exception {
        UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser(REAL_USER_NAME);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUser(PROXY_USER_NAME, realUserUgi);
        UserGroupInformation curUGI = proxyUserUgi.doAs(new PrivilegedExceptionAction<UserGroupInformation>(){

            @Override
            public UserGroupInformation run() throws IOException {
                return UserGroupInformation.getCurrentUser();
            }
        });
        Assert.assertEquals((String)"proxyUser (auth:PROXY) via realUser1@HADOOP.APACHE.ORG (auth:SIMPLE)", (String)curUGI.toString());
    }

    private void checkRemoteUgi(final Server server, final UserGroupInformation ugi, final Configuration conf) throws Exception {
        ugi.doAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                TestDoAsEffectiveUser.this.proxy = RPC.getProxy(TestProtocol.class, 1L, NetUtils.getConnectAddress(server), conf);
                Assert.assertEquals((String)ugi.toString(), (String)TestDoAsEffectiveUser.this.proxy.aMethod());
                Assert.assertEquals((String)ugi.toString(), (String)TestDoAsEffectiveUser.this.proxy.getServerRemoteUser());
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testRealUserSetup() throws IOException {
        Configuration conf = new Configuration();
        conf.setStrings(ProxyUsers.getProxySuperuserGroupConfKey(REAL_USER_SHORT_NAME), GROUP1_NAME);
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestProtocol.class).setInstance(new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).build();
        this.refreshConf(conf);
        try {
            server.start();
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser(REAL_USER_NAME);
            this.checkRemoteUgi(server, realUserUgi, conf);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting(PROXY_USER_NAME, realUserUgi, GROUP_NAMES);
            this.checkRemoteUgi(server, proxyUserUgi, conf);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy(this.proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testRealUserAuthorizationSuccess() throws IOException {
        Configuration conf = new Configuration();
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        conf.setStrings(ProxyUsers.getProxySuperuserGroupConfKey(REAL_USER_SHORT_NAME), GROUP1_NAME);
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestProtocol.class).setInstance(new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        this.refreshConf(conf);
        try {
            server.start();
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser(REAL_USER_NAME);
            this.checkRemoteUgi(server, realUserUgi, conf);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting(PROXY_USER_NAME, realUserUgi, GROUP_NAMES);
            this.checkRemoteUgi(server, proxyUserUgi, conf);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy(this.proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserIPAuthorizationFailure() throws IOException {
        final Configuration conf = new Configuration();
        conf.setStrings(ProxyUsers.getProxySuperuserIpConfKey(REAL_USER_SHORT_NAME), "20.20.20.20");
        conf.setStrings(ProxyUsers.getProxySuperuserGroupConfKey(REAL_USER_SHORT_NAME), GROUP1_NAME);
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestProtocol.class).setInstance(new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        this.refreshConf(conf);
        try {
            server.start();
            final InetSocketAddress addr = NetUtils.getConnectAddress(server);
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser(REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting(PROXY_USER_NAME, realUserUgi, GROUP_NAMES);
            String retVal = proxyUserUgi.doAs(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    TestDoAsEffectiveUser.this.proxy = RPC.getProxy(TestProtocol.class, 1L, addr, conf);
                    String ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return ret;
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy(this.proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserIPNotSpecified() throws IOException {
        final Configuration conf = new Configuration();
        conf.setStrings(ProxyUsers.getProxySuperuserGroupConfKey(REAL_USER_SHORT_NAME), GROUP1_NAME);
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestProtocol.class).setInstance(new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        try {
            server.start();
            final InetSocketAddress addr = NetUtils.getConnectAddress(server);
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser(REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting(PROXY_USER_NAME, realUserUgi, GROUP_NAMES);
            String retVal = proxyUserUgi.doAs(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    TestDoAsEffectiveUser.this.proxy = RPC.getProxy(TestProtocol.class, 1L, addr, conf);
                    String ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return ret;
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy(this.proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserGroupNotSpecified() throws IOException {
        final Configuration conf = new Configuration();
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestProtocol.class).setInstance(new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        try {
            server.start();
            final InetSocketAddress addr = NetUtils.getConnectAddress(server);
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser(REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting(PROXY_USER_NAME, realUserUgi, GROUP_NAMES);
            String retVal = proxyUserUgi.doAs(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    TestDoAsEffectiveUser.this.proxy = RPC.getProxy(TestProtocol.class, 1L, addr, conf);
                    String ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return ret;
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy(this.proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRealUserGroupAuthorizationFailure() throws IOException {
        final Configuration conf = new Configuration();
        this.configureSuperUserIPAddresses(conf, REAL_USER_SHORT_NAME);
        conf.setStrings(ProxyUsers.getProxySuperuserGroupConfKey(REAL_USER_SHORT_NAME), "group3");
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestProtocol.class).setInstance(new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        try {
            server.start();
            final InetSocketAddress addr = NetUtils.getConnectAddress(server);
            UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser(REAL_USER_NAME);
            UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting(PROXY_USER_NAME, realUserUgi, GROUP_NAMES);
            String retVal = proxyUserUgi.doAs(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    TestDoAsEffectiveUser.this.proxy = RPC.getProxy(TestProtocol.class, 1L, addr, conf);
                    String ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return ret;
                }
            });
            Assert.fail((String)("The RPC must have failed " + retVal));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            server.stop();
            if (this.proxy != null) {
                RPC.stopProxy(this.proxy);
            }
        }
    }

    @Test
    public void testProxyWithToken() throws Exception {
        final Configuration conf = new Configuration(masterConf);
        TestSaslRPC.TestTokenSecretManager sm = new TestSaslRPC.TestTokenSecretManager();
        SecurityUtil.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS, conf);
        UserGroupInformation.setConfiguration(conf);
        final RPC.Server server = new RPC.Builder(conf).setProtocol(TestProtocol.class).setInstance(new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).setSecretManager(sm).build();
        server.start();
        UserGroupInformation current = UserGroupInformation.createRemoteUser(REAL_USER_NAME);
        final InetSocketAddress addr = NetUtils.getConnectAddress(server);
        TestSaslRPC.TestTokenIdentifier tokenId = new TestSaslRPC.TestTokenIdentifier(new Text(current.getUserName()), new Text("SomeSuperUser"));
        Token<TestSaslRPC.TestTokenIdentifier> token = new Token<TestSaslRPC.TestTokenIdentifier>(tokenId, sm);
        SecurityUtil.setTokenService(token, addr);
        UserGroupInformation proxyUserUgi = UserGroupInformation.createProxyUserForTesting(PROXY_USER_NAME, current, GROUP_NAMES);
        proxyUserUgi.addToken(token);
        this.refreshConf(conf);
        String retVal = proxyUserUgi.doAs(new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                try {
                    String ret;
                    TestDoAsEffectiveUser.this.proxy = RPC.getProxy(TestProtocol.class, 1L, addr, conf);
                    String string = ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return string;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                finally {
                    server.stop();
                    if (TestDoAsEffectiveUser.this.proxy != null) {
                        RPC.stopProxy(TestDoAsEffectiveUser.this.proxy);
                    }
                }
            }
        });
        Assert.assertEquals((String)"realUser1@HADOOP.APACHE.ORG (auth:TOKEN) via SomeSuperUser (auth:SIMPLE)", (String)retVal);
    }

    @Test
    public void testTokenBySuperUser() throws Exception {
        TestSaslRPC.TestTokenSecretManager sm = new TestSaslRPC.TestTokenSecretManager();
        final Configuration newConf = new Configuration(masterConf);
        SecurityUtil.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS, newConf);
        UserGroupInformation.setConfiguration(newConf);
        final RPC.Server server = new RPC.Builder(newConf).setProtocol(TestProtocol.class).setInstance(new TestImpl()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).setSecretManager(sm).build();
        server.start();
        UserGroupInformation current = UserGroupInformation.createUserForTesting(REAL_USER_NAME, GROUP_NAMES);
        this.refreshConf(newConf);
        final InetSocketAddress addr = NetUtils.getConnectAddress(server);
        TestSaslRPC.TestTokenIdentifier tokenId = new TestSaslRPC.TestTokenIdentifier(new Text(current.getUserName()), new Text("SomeSuperUser"));
        Token<TestSaslRPC.TestTokenIdentifier> token = new Token<TestSaslRPC.TestTokenIdentifier>(tokenId, sm);
        SecurityUtil.setTokenService(token, addr);
        current.addToken(token);
        String retVal = current.doAs(new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                try {
                    String ret;
                    TestDoAsEffectiveUser.this.proxy = RPC.getProxy(TestProtocol.class, 1L, addr, newConf);
                    String string = ret = TestDoAsEffectiveUser.this.proxy.aMethod();
                    return string;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                finally {
                    server.stop();
                    if (TestDoAsEffectiveUser.this.proxy != null) {
                        RPC.stopProxy(TestDoAsEffectiveUser.this.proxy);
                    }
                }
            }
        });
        String expected = "realUser1@HADOOP.APACHE.ORG (auth:TOKEN) via SomeSuperUser (auth:SIMPLE)";
        Assert.assertEquals((String)(retVal + "!=" + expected), (String)expected, (String)retVal);
    }

    private void refreshConf(Configuration conf) throws IOException {
        ProxyUsers.refreshSuperUserGroupsConfiguration(conf);
    }

    static {
        masterConf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](.*@HADOOP.APACHE.ORG)s/@.*//RULE:[1:$1@$0](.*@HADOOP.APACHE.ORG)s/@.*//DEFAULT");
    }

    public class TestImpl
    implements TestProtocol {
        @Override
        public String aMethod() throws IOException {
            return UserGroupInformation.getCurrentUser().toString();
        }

        @Override
        public String getServerRemoteUser() throws IOException {
            return Server.getRemoteUser().toString();
        }

        @Override
        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 1L;
        }

        @Override
        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            return new ProtocolSignature(1L, null);
        }
    }

    @TokenInfo(value=TestSaslRPC.TestTokenSelector.class)
    public static interface TestProtocol
    extends VersionedProtocol {
        public static final long versionID = 1L;

        public String aMethod() throws IOException;

        public String getServerRemoteUser() throws IOException;
    }
}

