/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.JniBasedUnixGroupsMapping;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.NativeCodeLoader;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestJNIGroupsMapping {
    @Before
    public void isNativeCodeLoaded() {
        Assume.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded());
    }

    @Test
    public void testJNIGroupsMapping() throws Exception {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        this.testForUser(user);
        this.testForUser("fooBarBaz1234DoesNotExist");
    }

    private void testForUser(String user) throws Exception {
        GroupMappingServiceProvider g = new ShellBasedUnixGroupsMapping();
        List<String> shellBasedGroups = g.getGroups(user);
        g = new JniBasedUnixGroupsMapping();
        List<String> jniBasedGroups = g.getGroups(user);
        Object[] shellBasedGroupsArray = shellBasedGroups.toArray(new String[0]);
        Arrays.sort(shellBasedGroupsArray);
        Object[] jniBasedGroupsArray = jniBasedGroups.toArray(new String[0]);
        Arrays.sort(jniBasedGroupsArray);
        if (!Arrays.equals(shellBasedGroupsArray, jniBasedGroupsArray)) {
            Assert.fail((String)("Groups returned by " + ShellBasedUnixGroupsMapping.class.getCanonicalName() + " and " + JniBasedUnixGroupsMapping.class.getCanonicalName() + " didn't match for " + user));
        }
    }
}

