/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.TestSaslRPC;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestUserGroupInformation {
    private static final String USER_NAME = "user1@HADOOP.APACHE.ORG";
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String GROUP3_NAME = "group3";
    private static final String[] GROUP_NAMES = new String[]{"group1", "group2", "group3"};
    private static final int PERCENTILES_INTERVAL = 1;
    private static Configuration conf;

    @BeforeClass
    public static void setup() {
        javax.security.auth.login.Configuration.setConfiguration(new DummyLoginConfiguration());
        String home = System.getenv("HADOOP_HOME");
        System.setProperty("hadoop.home.dir", home != null ? home : ".");
        System.setProperty("java.security.krb5.kdc", "");
        System.setProperty("java.security.krb5.realm", "DEFAULT.REALM");
    }

    @Before
    public void setupUgi() {
        conf = new Configuration();
        UserGroupInformation.reset();
        UserGroupInformation.setConfiguration(conf);
    }

    @After
    public void resetUgi() {
        UserGroupInformation.setLoginUser(null);
    }

    @Test(timeout=30000L)
    public void testSimpleLogin() throws IOException {
        this.tryLoginAuthenticationMethod(UserGroupInformation.AuthenticationMethod.SIMPLE, true);
    }

    @Test(timeout=30000L)
    public void testTokenLogin() throws IOException {
        this.tryLoginAuthenticationMethod(UserGroupInformation.AuthenticationMethod.TOKEN, false);
    }

    @Test(timeout=30000L)
    public void testProxyLogin() throws IOException {
        this.tryLoginAuthenticationMethod(UserGroupInformation.AuthenticationMethod.PROXY, false);
    }

    private void tryLoginAuthenticationMethod(UserGroupInformation.AuthenticationMethod method, boolean expectSuccess) throws IOException {
        SecurityUtil.setAuthenticationMethod(method, conf);
        UserGroupInformation.setConfiguration(conf);
        UserGroupInformation ugi = null;
        Exception ex = null;
        try {
            ugi = UserGroupInformation.getLoginUser();
        }
        catch (Exception e) {
            ex = e;
        }
        if (expectSuccess) {
            Assert.assertNotNull((Object)ugi);
            Assert.assertEquals((Object)((Object)method), (Object)((Object)ugi.getAuthenticationMethod()));
        } else {
            Assert.assertNotNull((Object)ex);
            Assert.assertEquals(UnsupportedOperationException.class, ex.getClass());
            Assert.assertEquals((Object)((Object)((Object)method) + " login authentication is not supported"), (Object)ex.getMessage());
        }
    }

    @Test(timeout=30000L)
    public void testGetRealAuthenticationMethod() {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser("user1");
        ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.SIMPLE);
        Assert.assertEquals((Object)((Object)UserGroupInformation.AuthenticationMethod.SIMPLE), (Object)((Object)ugi.getAuthenticationMethod()));
        Assert.assertEquals((Object)((Object)UserGroupInformation.AuthenticationMethod.SIMPLE), (Object)((Object)ugi.getRealAuthenticationMethod()));
        ugi = UserGroupInformation.createProxyUser("user2", ugi);
        Assert.assertEquals((Object)((Object)UserGroupInformation.AuthenticationMethod.PROXY), (Object)((Object)ugi.getAuthenticationMethod()));
        Assert.assertEquals((Object)((Object)UserGroupInformation.AuthenticationMethod.SIMPLE), (Object)((Object)ugi.getRealAuthenticationMethod()));
    }

    @Test(timeout=30000L)
    public void testLogin() throws Exception {
        conf.set("hadoop.user.group.metrics.percentiles.intervals", String.valueOf(1));
        UserGroupInformation.setConfiguration(conf);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Assert.assertEquals((Object)UserGroupInformation.getCurrentUser(), (Object)UserGroupInformation.getLoginUser());
        Assert.assertTrue((ugi.getGroupNames().length >= 1 ? 1 : 0) != 0);
        TestUserGroupInformation.verifyGroupMetrics(1L);
        UserGroupInformation userGroupInfo = UserGroupInformation.createUserForTesting(USER_NAME, GROUP_NAMES);
        UserGroupInformation curUGI = userGroupInfo.doAs(new PrivilegedExceptionAction<UserGroupInformation>(){

            @Override
            public UserGroupInformation run() throws IOException {
                return UserGroupInformation.getCurrentUser();
            }
        });
        Assert.assertEquals((Object)curUGI, (Object)userGroupInfo);
        Assert.assertFalse((boolean)curUGI.equals(UserGroupInformation.getLoginUser()));
    }

    @Test(timeout=30000L)
    public void testGetServerSideGroups() throws IOException, InterruptedException {
        String[] tokens;
        Process pp = Runtime.getRuntime().exec("whoami");
        BufferedReader br = new BufferedReader(new InputStreamReader(pp.getInputStream()));
        String userName = br.readLine().trim();
        if (Shell.WINDOWS) {
            int sp = userName.lastIndexOf(92);
            if (sp != -1) {
                userName = userName.substring(sp + 1);
            }
            userName = userName.toLowerCase();
        }
        pp = Runtime.getRuntime().exec(Shell.WINDOWS ? Shell.WINUTILS + " groups -F" : "id -Gn");
        br = new BufferedReader(new InputStreamReader(pp.getInputStream()));
        String line = br.readLine();
        System.out.println(userName + ":" + line);
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        for (String s : tokens = line.split(Shell.TOKEN_SEPARATOR_REGEX)) {
            groups.add(s);
        }
        final UserGroupInformation login = UserGroupInformation.getCurrentUser();
        String loginUserName = login.getShortUserName();
        if (Shell.WINDOWS) {
            loginUserName = loginUserName.toLowerCase();
        }
        Assert.assertEquals((Object)userName, (Object)loginUserName);
        String[] gi = login.getGroupNames();
        Assert.assertEquals((long)groups.size(), (long)gi.length);
        for (int i = 0; i < gi.length; ++i) {
            Assert.assertTrue((boolean)groups.contains(gi[i]));
        }
        final UserGroupInformation fakeUser = UserGroupInformation.createRemoteUser("foo.bar");
        fakeUser.doAs(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                UserGroupInformation current = UserGroupInformation.getCurrentUser();
                Assert.assertFalse((boolean)current.equals(login));
                Assert.assertEquals((Object)current, (Object)fakeUser);
                Assert.assertEquals((long)0L, (long)current.getGroupNames().length);
                return null;
            }
        });
    }

    @Test(timeout=30000L)
    public void testConstructor() throws Exception {
        this.testConstructorSuccess("user1", "user1");
        this.testConstructorSuccess("user2@DEFAULT.REALM", "user2");
        this.testConstructorSuccess("user3/cron@DEFAULT.REALM", "user3");
        this.testConstructorSuccess("user4@OTHER.REALM", "user4");
        this.testConstructorSuccess("user5/cron@OTHER.REALM", "user5");
        this.testConstructorFailures(null);
        this.testConstructorFailures("");
    }

    @Test(timeout=30000L)
    public void testConstructorWithRules() throws Exception {
        conf.set("hadoop.security.auth_to_local", "RULE:[1:$1@$0](.*@OTHER.REALM)s/(.*)@.*/other-$1/");
        UserGroupInformation.setConfiguration(conf);
        this.testConstructorSuccess("user1", "user1");
        this.testConstructorSuccess("user4@OTHER.REALM", "other-user4");
        this.testConstructorFailures("user2@DEFAULT.REALM");
        this.testConstructorFailures("user3/cron@DEFAULT.REALM");
        this.testConstructorFailures("user5/cron@OTHER.REALM");
        this.testConstructorFailures(null);
        this.testConstructorFailures("");
    }

    @Test(timeout=30000L)
    public void testConstructorWithKerberos() throws Exception {
        SecurityUtil.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS, conf);
        UserGroupInformation.setConfiguration(conf);
        this.testConstructorSuccess("user1", "user1");
        this.testConstructorSuccess("user2@DEFAULT.REALM", "user2");
        this.testConstructorSuccess("user3/cron@DEFAULT.REALM", "user3");
        this.testConstructorFailures("user4@OTHER.REALM");
        this.testConstructorFailures("user5/cron@OTHER.REALM");
        this.testConstructorFailures(null);
        this.testConstructorFailures("");
    }

    @Test(timeout=30000L)
    public void testConstructorWithKerberosRules() throws Exception {
        SecurityUtil.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS, conf);
        conf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](.*@OTHER.REALM)s/(.*)@.*/other-$1/RULE:[1:$1@$0](.*@OTHER.REALM)s/(.*)@.*/other-$1/DEFAULT");
        UserGroupInformation.setConfiguration(conf);
        this.testConstructorSuccess("user1", "user1");
        this.testConstructorSuccess("user2@DEFAULT.REALM", "user2");
        this.testConstructorSuccess("user3/cron@DEFAULT.REALM", "user3");
        this.testConstructorSuccess("user4@OTHER.REALM", "other-user4");
        this.testConstructorSuccess("user5/cron@OTHER.REALM", "other-user5");
        this.testConstructorFailures(null);
        this.testConstructorFailures("");
    }

    private void testConstructorSuccess(String principal, String shortName) {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting(principal, GROUP_NAMES);
        Assert.assertEquals((Object)principal, (Object)ugi.getUserName());
        Assert.assertEquals((Object)shortName, (Object)ugi.getShortUserName());
    }

    private void testConstructorFailures(String userName) {
        try {
            UserGroupInformation.createRemoteUser(userName);
            Assert.fail((String)("user:" + userName + " wasn't invalid"));
        }
        catch (IllegalArgumentException e) {
            String expect = userName == null || userName.isEmpty() ? "Null user" : "Illegal principal name " + userName;
            Assert.assertEquals((Object)expect, (Object)e.getMessage());
        }
    }

    @Test(timeout=30000L)
    public void testSetConfigWithRules() {
        String[] rules = new String[]{"RULE:[1:TEST1]", "RULE:[1:TEST2]", "RULE:[1:TEST3]"};
        UserGroupInformation.reset();
        Assert.assertFalse((boolean)KerberosName.hasRulesBeenSet());
        KerberosName.setRules(rules[0]);
        Assert.assertTrue((boolean)KerberosName.hasRulesBeenSet());
        Assert.assertEquals((Object)rules[0], (Object)KerberosName.getRules());
        UserGroupInformation.createUserForTesting("someone", new String[0]);
        Assert.assertEquals((Object)rules[0], (Object)KerberosName.getRules());
        conf.set("hadoop.security.auth_to_local", rules[1]);
        UserGroupInformation.setConfiguration(conf);
        Assert.assertEquals((Object)rules[1], (Object)KerberosName.getRules());
        conf.set("hadoop.security.auth_to_local", rules[2]);
        UserGroupInformation.setConfiguration(conf);
        Assert.assertEquals((Object)rules[2], (Object)KerberosName.getRules());
        UserGroupInformation.createUserForTesting("someone", new String[0]);
        Assert.assertEquals((Object)rules[2], (Object)KerberosName.getRules());
    }

    @Test(timeout=30000L)
    public void testEnsureInitWithRules() throws IOException {
        String rules = "RULE:[1:RULE1]";
        UserGroupInformation.reset();
        Assert.assertFalse((boolean)KerberosName.hasRulesBeenSet());
        UserGroupInformation.createUserForTesting("someone", new String[0]);
        Assert.assertTrue((boolean)KerberosName.hasRulesBeenSet());
        UserGroupInformation.reset();
        KerberosName.setRules(rules);
        Assert.assertTrue((boolean)KerberosName.hasRulesBeenSet());
        Assert.assertEquals((Object)rules, (Object)KerberosName.getRules());
        UserGroupInformation.createUserForTesting("someone", new String[0]);
        Assert.assertEquals((Object)rules, (Object)KerberosName.getRules());
    }

    @Test(timeout=30000L)
    public void testEquals() throws Exception {
        UserGroupInformation uugi = UserGroupInformation.createUserForTesting(USER_NAME, GROUP_NAMES);
        Assert.assertEquals((Object)uugi, (Object)uugi);
        UserGroupInformation ugi2 = UserGroupInformation.createUserForTesting(USER_NAME, GROUP_NAMES);
        Assert.assertFalse((boolean)uugi.equals(ugi2));
        Assert.assertFalse((uugi.hashCode() == ugi2.hashCode() ? 1 : 0) != 0);
        UserGroupInformation ugi3 = new UserGroupInformation(uugi.getSubject());
        Assert.assertEquals((Object)uugi, (Object)ugi3);
        Assert.assertEquals((long)uugi.hashCode(), (long)ugi3.hashCode());
    }

    @Test(timeout=30000L)
    public void testEqualsWithRealUser() throws Exception {
        UserGroupInformation realUgi1 = UserGroupInformation.createUserForTesting("RealUser", GROUP_NAMES);
        UserGroupInformation proxyUgi1 = UserGroupInformation.createProxyUser(USER_NAME, realUgi1);
        UserGroupInformation proxyUgi2 = new UserGroupInformation(proxyUgi1.getSubject());
        UserGroupInformation remoteUgi = UserGroupInformation.createRemoteUser(USER_NAME);
        Assert.assertEquals((Object)proxyUgi1, (Object)proxyUgi2);
        Assert.assertFalse((boolean)remoteUgi.equals(proxyUgi1));
    }

    @Test(timeout=30000L)
    public void testGettingGroups() throws Exception {
        UserGroupInformation uugi = UserGroupInformation.createUserForTesting(USER_NAME, GROUP_NAMES);
        Assert.assertEquals((Object)USER_NAME, (Object)uugi.getUserName());
        Assert.assertArrayEquals((Object[])new String[]{GROUP1_NAME, GROUP2_NAME, GROUP3_NAME}, (Object[])uugi.getGroupNames());
    }

    @Test(timeout=30000L)
    public <T extends TokenIdentifier> void testAddToken() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser("someone");
        Token t1 = (Token)Mockito.mock(Token.class);
        Token t2 = (Token)Mockito.mock(Token.class);
        Token t3 = (Token)Mockito.mock(Token.class);
        ugi.addToken(t1);
        this.checkTokens(ugi, t1);
        ugi.addToken(t2);
        this.checkTokens(ugi, t2);
        Mockito.when((Object)t1.getService()).thenReturn((Object)new Text("t1"));
        ugi.addToken(t1);
        this.checkTokens(ugi, t1, t2);
        Mockito.when((Object)t3.getService()).thenReturn((Object)new Text("t1"));
        ugi.addToken(t3);
        this.checkTokens(ugi, t2, t3);
        Mockito.when((Object)t1.getService()).thenReturn((Object)new Text("t1.1"));
        ugi.addToken(t1);
        this.checkTokens(ugi, t1, t2, t3);
        ugi.addToken(t1);
        this.checkTokens(ugi, t1, t2, t3);
    }

    @Test(timeout=30000L)
    public <T extends TokenIdentifier> void testGetCreds() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser("someone");
        Text service = new Text("service");
        Token t1 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)t1.getService()).thenReturn((Object)service);
        Token t2 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)t2.getService()).thenReturn((Object)new Text("service2"));
        Token t3 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)t3.getService()).thenReturn((Object)service);
        ugi.addToken(t1);
        ugi.addToken(t2);
        this.checkTokens(ugi, t1, t2);
        Credentials creds = ugi.getCredentials();
        creds.addToken(t3.getService(), t3);
        Assert.assertSame((Object)t3, creds.getToken(service));
        this.checkTokens(ugi, t1, t2);
    }

    @Test(timeout=30000L)
    public <T extends TokenIdentifier> void testAddCreds() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser("someone");
        Text service = new Text("service");
        Token t1 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)t1.getService()).thenReturn((Object)service);
        Token t2 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)t2.getService()).thenReturn((Object)new Text("service2"));
        byte[] secret = new byte[]{};
        Text secretKey = new Text("sshhh");
        Credentials creds = new Credentials();
        creds.addToken(t1.getService(), t1);
        creds.addToken(t2.getService(), t2);
        creds.addSecretKey(secretKey, secret);
        ugi.addCredentials(creds);
        this.checkTokens(ugi, t1, t2);
        Assert.assertSame((Object)secret, (Object)ugi.getCredentials().getSecretKey(secretKey));
    }

    @Test(timeout=30000L)
    public <T extends TokenIdentifier> void testGetCredsNotSame() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser("someone");
        Credentials creds = ugi.getCredentials();
        Assert.assertNotSame((Object)creds, (Object)ugi.getCredentials());
    }

    private void checkTokens(UserGroupInformation ugi, Token<?> ... tokens) {
        Collection<Token<? extends TokenIdentifier>> ugiTokens = ugi.getTokens();
        for (Token<?> t : tokens) {
            Assert.assertTrue((boolean)ugiTokens.contains(t));
        }
        Assert.assertEquals((long)tokens.length, (long)ugiTokens.size());
        Credentials ugiCreds = ugi.getCredentials();
        for (Token<?> t : tokens) {
            Assert.assertSame(t, ugiCreds.getToken(t.getService()));
        }
        Assert.assertEquals((long)tokens.length, (long)ugiCreds.numberOfTokens());
    }

    @Test(timeout=30000L)
    public <T extends TokenIdentifier> void testAddNamedToken() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser("someone");
        Token t1 = (Token)Mockito.mock(Token.class);
        Text service1 = new Text("t1");
        Text service2 = new Text("t2");
        Mockito.when((Object)t1.getService()).thenReturn((Object)service1);
        ugi.addToken(service1, t1);
        Assert.assertSame((Object)t1, ugi.getCredentials().getToken(service1));
        ugi.addToken(service2, t1);
        Assert.assertSame((Object)t1, ugi.getCredentials().getToken(service1));
        Assert.assertSame((Object)t1, ugi.getCredentials().getToken(service2));
    }

    @Test(timeout=30000L)
    public <T extends TokenIdentifier> void testUGITokens() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting("TheDoctor", new String[]{"TheTARDIS"});
        Token t1 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)t1.getService()).thenReturn((Object)new Text("t1"));
        Token t2 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)t2.getService()).thenReturn((Object)new Text("t2"));
        Credentials creds = new Credentials();
        byte[] secretKey = new byte[]{};
        Text secretName = new Text("shhh");
        creds.addSecretKey(secretName, secretKey);
        ugi.addToken(t1);
        ugi.addToken(t2);
        ugi.addCredentials(creds);
        Collection<Token<? extends TokenIdentifier>> z = ugi.getTokens();
        Assert.assertTrue((boolean)z.contains(t1));
        Assert.assertTrue((boolean)z.contains(t2));
        Assert.assertEquals((long)2L, (long)z.size());
        Credentials ugiCreds = ugi.getCredentials();
        Assert.assertSame((Object)secretKey, (Object)ugiCreds.getSecretKey(secretName));
        Assert.assertEquals((long)1L, (long)ugiCreds.numberOfSecretKeys());
        try {
            z.remove(t1);
            Assert.fail((String)"Shouldn't be able to modify token collection from UGI");
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        Collection otherSet = (Collection)ugi.doAs(new PrivilegedExceptionAction<Collection<Token<?>>>(){

            @Override
            public Collection<Token<?>> run() throws IOException {
                return UserGroupInformation.getCurrentUser().getTokens();
            }
        });
        Assert.assertTrue((boolean)otherSet.contains(t1));
        Assert.assertTrue((boolean)otherSet.contains(t2));
    }

    @Test(timeout=30000L)
    public void testTokenIdentifiers() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting("TheDoctor", new String[]{"TheTARDIS"});
        TokenIdentifier t1 = (TokenIdentifier)Mockito.mock(TokenIdentifier.class);
        TokenIdentifier t2 = (TokenIdentifier)Mockito.mock(TokenIdentifier.class);
        ugi.addTokenIdentifier(t1);
        ugi.addTokenIdentifier(t2);
        Set<TokenIdentifier> z = ugi.getTokenIdentifiers();
        Assert.assertTrue((boolean)z.contains(t1));
        Assert.assertTrue((boolean)z.contains(t2));
        Assert.assertEquals((long)2L, (long)z.size());
        Collection<TokenIdentifier> otherSet = ugi.doAs(new PrivilegedExceptionAction<Collection<TokenIdentifier>>(){

            @Override
            public Collection<TokenIdentifier> run() throws IOException {
                return UserGroupInformation.getCurrentUser().getTokenIdentifiers();
            }
        });
        Assert.assertTrue((boolean)otherSet.contains(t1));
        Assert.assertTrue((boolean)otherSet.contains(t2));
        Assert.assertEquals((long)2L, (long)otherSet.size());
    }

    @Test(timeout=30000L)
    public void testTestAuthMethod() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        for (UserGroupInformation.AuthenticationMethod am : UserGroupInformation.AuthenticationMethod.values()) {
            if (am.getAuthMethod() == null) continue;
            ugi.setAuthenticationMethod(am.getAuthMethod());
            Assert.assertEquals((Object)((Object)am), (Object)((Object)ugi.getAuthenticationMethod()));
        }
    }

    @Test(timeout=30000L)
    public void testUGIAuthMethod() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        final UserGroupInformation.AuthenticationMethod am = UserGroupInformation.AuthenticationMethod.KERBEROS;
        ugi.setAuthenticationMethod(am);
        Assert.assertEquals((Object)((Object)am), (Object)((Object)ugi.getAuthenticationMethod()));
        ugi.doAs(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                Assert.assertEquals((Object)((Object)am), (Object)((Object)UserGroupInformation.getCurrentUser().getAuthenticationMethod()));
                return null;
            }
        });
    }

    @Test(timeout=30000L)
    public void testUGIAuthMethodInRealUser() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation proxyUgi = UserGroupInformation.createProxyUser("proxy", ugi);
        final UserGroupInformation.AuthenticationMethod am = UserGroupInformation.AuthenticationMethod.KERBEROS;
        ugi.setAuthenticationMethod(am);
        Assert.assertEquals((Object)((Object)am), (Object)((Object)ugi.getAuthenticationMethod()));
        Assert.assertEquals((Object)((Object)UserGroupInformation.AuthenticationMethod.PROXY), (Object)((Object)proxyUgi.getAuthenticationMethod()));
        Assert.assertEquals((Object)((Object)am), (Object)((Object)UserGroupInformation.getRealAuthenticationMethod(proxyUgi)));
        proxyUgi.doAs(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                Assert.assertEquals((Object)((Object)UserGroupInformation.AuthenticationMethod.PROXY), (Object)((Object)UserGroupInformation.getCurrentUser().getAuthenticationMethod()));
                Assert.assertEquals((Object)((Object)am), (Object)((Object)UserGroupInformation.getCurrentUser().getRealUser().getAuthenticationMethod()));
                return null;
            }
        });
        UserGroupInformation proxyUgi2 = new UserGroupInformation(proxyUgi.getSubject());
        proxyUgi2.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.PROXY);
        Assert.assertEquals((Object)proxyUgi, (Object)proxyUgi2);
        UserGroupInformation realugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation proxyUgi3 = UserGroupInformation.createProxyUser("proxyAnother", realugi);
        UserGroupInformation proxyUgi4 = new UserGroupInformation(proxyUgi3.getSubject());
        Assert.assertEquals((Object)proxyUgi3, (Object)proxyUgi4);
    }

    @Test(timeout=30000L)
    public void testLoginObjectInSubject() throws Exception {
        LoginContext login2;
        UserGroupInformation loginUgi = UserGroupInformation.getLoginUser();
        UserGroupInformation anotherUgi = new UserGroupInformation(loginUgi.getSubject());
        LoginContext login1 = loginUgi.getSubject().getPrincipals(User.class).iterator().next().getLogin();
        Assert.assertTrue((login1 == (login2 = anotherUgi.getSubject().getPrincipals(User.class).iterator().next().getLogin()) ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testLoginModuleCommit() throws Exception {
        UserGroupInformation loginUgi = UserGroupInformation.getLoginUser();
        User user1 = loginUgi.getSubject().getPrincipals(User.class).iterator().next();
        LoginContext login = user1.getLogin();
        login.logout();
        login.login();
        User user2 = loginUgi.getSubject().getPrincipals(User.class).iterator().next();
        Assert.assertTrue((user1 == user2 ? 1 : 0) != 0);
    }

    public static void verifyLoginMetrics(long success, int failure) throws IOException {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics("UgiMetrics");
        if (success > 0L) {
            MetricsAsserts.assertCounter("LoginSuccessNumOps", success, rb);
            MetricsAsserts.assertGaugeGt("LoginSuccessAvgTime", 0.0, rb);
        }
        if (failure > 0) {
            MetricsAsserts.assertCounter("LoginFailureNumPos", failure, rb);
            MetricsAsserts.assertGaugeGt("LoginFailureAvgTime", 0.0, rb);
        }
    }

    private static void verifyGroupMetrics(long groups) throws InterruptedException {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics("UgiMetrics");
        if (groups > 0L) {
            MetricsAsserts.assertCounterGt("GetGroupsNumOps", groups - 1L, rb);
            double avg = MetricsAsserts.getDoubleGauge("GetGroupsAvgTime", rb);
            Assert.assertTrue((avg >= 0.0 ? 1 : 0) != 0);
            Thread.sleep(2000L);
            MetricsAsserts.assertQuantileGauges("GetGroups1s", rb);
        }
    }

    @Test(timeout=30000L)
    public void testUGIUnderNonHadoopContext() throws Exception {
        Subject nonHadoopSubject = new Subject();
        Subject.doAs(nonHadoopSubject, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                Assert.assertNotNull((Object)ugi);
                return null;
            }
        });
    }

    @Test(timeout=1000L)
    public void testSetLoginUser() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser("test-user");
        UserGroupInformation.setLoginUser(ugi);
        Assert.assertEquals((Object)ugi, (Object)UserGroupInformation.getLoginUser());
    }

    @Test
    public void testPrivateTokenExclusion() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        TestSaslRPC.TestTokenIdentifier tokenId = new TestSaslRPC.TestTokenIdentifier();
        Token token = new Token(tokenId.getBytes(), "password".getBytes(), tokenId.getKind(), null);
        ugi.addToken(new Text("regular-token"), token);
        ugi.addToken(new Text("private-token"), new Token.PrivateToken(token));
        ugi.addToken(new Text("private-token1"), new Token.PrivateToken(token));
        Collection<Token<? extends TokenIdentifier>> tokens = ugi.getCredentials().getAllTokens();
        Assert.assertEquals((long)1L, (long)tokens.size());
    }

    private static class DummyLoginConfiguration
    extends javax.security.auth.login.Configuration {
        private DummyLoginConfiguration() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            throw new RuntimeException("UGI is not using its own security conf!");
        }
    }
}

