/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service;

import org.apache.hadoop.service.BreakableService;
import org.apache.hadoop.service.Service;
import org.junit.Assert;

public class ServiceAssert
extends Assert {
    public static void assertServiceStateCreated(Service service) {
        ServiceAssert.assertServiceInState(service, Service.STATE.NOTINITED);
    }

    public static void assertServiceStateInited(Service service) {
        ServiceAssert.assertServiceInState(service, Service.STATE.INITED);
    }

    public static void assertServiceStateStarted(Service service) {
        ServiceAssert.assertServiceInState(service, Service.STATE.STARTED);
    }

    public static void assertServiceStateStopped(Service service) {
        ServiceAssert.assertServiceInState(service, Service.STATE.STOPPED);
    }

    public static void assertServiceInState(Service service, Service.STATE state) {
        ServiceAssert.assertNotNull((String)"Null service", (Object)service);
        ServiceAssert.assertEquals((String)("Service in wrong state: " + service), (Object)((Object)state), (Object)((Object)service.getServiceState()));
    }

    public static void assertStateCount(BreakableService service, Service.STATE state, int expected) {
        ServiceAssert.assertNotNull((String)"Null service", (Object)service);
        int actual = service.getCount(state);
        if (expected != actual) {
            ServiceAssert.fail((String)("Expected entry count for state [" + (Object)((Object)state) + "] of " + service + " to be " + expected + " but was " + actual));
        }
    }

    public static void assertServiceConfigurationContains(Service service, String key) {
        ServiceAssert.assertNotNull((String)("No option " + key + " in service configuration"), (Object)service.getConfig().get(key));
    }
}

