/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.BreakableService;
import org.apache.hadoop.service.BreakableStateChangeListener;
import org.apache.hadoop.service.LoggingStateChangeListener;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceAssert;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.junit.After;
import org.junit.Test;

public class TestGlobalStateChangeListener
extends ServiceAssert {
    BreakableStateChangeListener listener = new BreakableStateChangeListener("listener");

    private void register() {
        this.register(this.listener);
    }

    private boolean unregister() {
        return this.unregister(this.listener);
    }

    private void register(ServiceStateChangeListener l) {
        AbstractService.registerGlobalListener(l);
    }

    private boolean unregister(ServiceStateChangeListener l) {
        return AbstractService.unregisterGlobalListener(l);
    }

    @After
    public void cleanup() {
        AbstractService.resetGlobalListeners();
    }

    public void assertListenerState(BreakableStateChangeListener breakable, Service.STATE state) {
        TestGlobalStateChangeListener.assertEquals((String)("Wrong state in " + breakable), (Object)((Object)state), (Object)((Object)breakable.getLastState()));
    }

    public void assertListenerEventCount(BreakableStateChangeListener breakable, int count) {
        TestGlobalStateChangeListener.assertEquals((String)("Wrong event count in " + breakable), (long)count, (long)breakable.getEventCount());
    }

    @Test
    public void testRegisterListener() {
        this.register();
        TestGlobalStateChangeListener.assertTrue((String)"listener not registered", (boolean)this.unregister());
    }

    @Test
    public void testRegisterListenerTwice() {
        this.register();
        this.register();
        TestGlobalStateChangeListener.assertTrue((String)"listener not registered", (boolean)this.unregister());
        TestGlobalStateChangeListener.assertFalse((String)"listener double registered", (boolean)this.unregister());
    }

    @Test
    public void testEventHistory() {
        this.register();
        BreakableService service = new BreakableService();
        this.assertListenerState(this.listener, Service.STATE.NOTINITED);
        TestGlobalStateChangeListener.assertEquals((long)0L, (long)this.listener.getEventCount());
        service.init(new Configuration());
        this.assertListenerState(this.listener, Service.STATE.INITED);
        TestGlobalStateChangeListener.assertSame((Object)service, (Object)this.listener.getLastService());
        this.assertListenerEventCount(this.listener, 1);
        service.start();
        this.assertListenerState(this.listener, Service.STATE.STARTED);
        this.assertListenerEventCount(this.listener, 2);
        service.stop();
        this.assertListenerState(this.listener, Service.STATE.STOPPED);
        this.assertListenerEventCount(this.listener, 3);
    }

    @Test
    public void testListenerFailure() {
        this.listener.setFailingState(Service.STATE.INITED);
        this.register();
        BreakableStateChangeListener l2 = new BreakableStateChangeListener();
        this.register(l2);
        BreakableService service = new BreakableService();
        service.init(new Configuration());
        this.assertListenerState(this.listener, Service.STATE.INITED);
        this.assertListenerEventCount(this.listener, 1);
        this.assertListenerEventCount(l2, 0);
        TestGlobalStateChangeListener.assertServiceStateInited(service);
        service.start();
        service.stop();
    }

    @Test
    public void testListenerChain() {
        LoggingStateChangeListener logListener = new LoggingStateChangeListener();
        this.register(logListener);
        BreakableStateChangeListener l0 = new BreakableStateChangeListener("l0");
        this.register(l0);
        this.listener.setFailingState(Service.STATE.STARTED);
        this.register();
        BreakableStateChangeListener l3 = new BreakableStateChangeListener("l3");
        this.register(l3);
        BreakableService service = new BreakableService();
        service.init(new Configuration());
        TestGlobalStateChangeListener.assertServiceStateInited(service);
        this.assertListenerState(l0, Service.STATE.INITED);
        this.assertListenerState(this.listener, Service.STATE.INITED);
        this.assertListenerState(l3, Service.STATE.INITED);
        service.start();
        TestGlobalStateChangeListener.assertServiceStateStarted(service);
        this.assertListenerState(l0, Service.STATE.STARTED);
        this.assertListenerEventCount(l0, 2);
        this.assertListenerState(this.listener, Service.STATE.STARTED);
        this.assertListenerEventCount(this.listener, 2);
        this.assertListenerState(l3, Service.STATE.INITED);
        this.assertListenerEventCount(l3, 1);
        service.stop();
        this.assertListenerEventCount(l0, 3);
        this.assertListenerEventCount(this.listener, 3);
        this.assertListenerEventCount(l3, 2);
        this.unregister(logListener);
        this.unregister(l0);
        this.unregister(l3);
        service = new BreakableService();
        service.init(new Configuration());
        this.assertListenerEventCount(l0, 3);
        this.assertListenerEventCount(l3, 2);
        this.assertListenerEventCount(this.listener, 4);
    }
}

