/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.hadoop.shaded.com.google.common.base.Preconditions;

public class CloseableReferenceCount {
    private static final int STATUS_CLOSED_MASK = 0x40000000;
    private final AtomicInteger status = new AtomicInteger(0);

    public void reference() throws ClosedChannelException {
        int curBits = this.status.incrementAndGet();
        if ((curBits & 0x40000000) != 0) {
            this.status.decrementAndGet();
            throw new ClosedChannelException();
        }
    }

    public boolean unreference() {
        int newVal = this.status.decrementAndGet();
        Preconditions.checkState(newVal != -1, "called unreference when the reference count was already at 0.");
        return newVal == 0x40000000;
    }

    public void unreferenceCheckClosed() throws ClosedChannelException {
        int newVal = this.status.decrementAndGet();
        if ((newVal & 0x40000000) != 0) {
            throw new AsynchronousCloseException();
        }
    }

    public boolean isOpen() {
        return (this.status.get() & 0x40000000) == 0;
    }

    public int setClosed() throws ClosedChannelException {
        int curBits;
        do {
            if (((curBits = this.status.get()) & 0x40000000) == 0) continue;
            throw new ClosedChannelException();
        } while (!this.status.compareAndSet(curBits, curBits | 0x40000000));
        return curBits & 0xBFFFFFFF;
    }

    public int getReferenceCount() {
        return this.status.get() & 0xBFFFFFFF;
    }
}

