/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.LinkedList;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.IdentityHashStore;
import org.junit.Test;

public class TestIdentityHashStore {
    private static final Log LOG = LogFactory.getLog((String)TestIdentityHashStore.class.getName());

    @Test(timeout=60000L)
    public void testStartingWithZeroCapacity() {
        IdentityHashStore<Key, Integer> store = new IdentityHashStore<Key, Integer>(0);
        store.visitAll(new IdentityHashStore.Visitor<Key, Integer>(){

            @Override
            public void accept(Key k, Integer v) {
                Assert.fail((String)("found key " + k + " in empty IdentityHashStore."));
            }
        });
        Assert.assertTrue((boolean)store.isEmpty());
        final Key key1 = new Key("key1");
        Integer value1 = new Integer(100);
        store.put(key1, value1);
        Assert.assertTrue((!store.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)value1, store.get(key1));
        store.visitAll(new IdentityHashStore.Visitor<Key, Integer>(){

            @Override
            public void accept(Key k, Integer v) {
                Assert.assertEquals((Object)key1, (Object)k);
            }
        });
        Assert.assertEquals((Object)value1, store.remove(key1));
        Assert.assertTrue((boolean)store.isEmpty());
    }

    @Test(timeout=60000L)
    public void testDuplicateInserts() {
        IdentityHashStore<Key, Integer> store = new IdentityHashStore<Key, Integer>(4);
        store.visitAll(new IdentityHashStore.Visitor<Key, Integer>(){

            @Override
            public void accept(Key k, Integer v) {
                Assert.fail((String)("found key " + k + " in empty IdentityHashStore."));
            }
        });
        Assert.assertTrue((boolean)store.isEmpty());
        Key key1 = new Key("key1");
        Integer value1 = new Integer(100);
        Integer value2 = new Integer(200);
        Integer value3 = new Integer(300);
        store.put(key1, value1);
        Key equalToKey1 = new Key("key1");
        Assert.assertNull(store.get(equalToKey1));
        Assert.assertTrue((!store.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)value1, store.get(key1));
        store.put(key1, value2);
        store.put(key1, value3);
        final LinkedList allValues = new LinkedList();
        store.visitAll(new IdentityHashStore.Visitor<Key, Integer>(){

            @Override
            public void accept(Key k, Integer v) {
                allValues.add(v);
            }
        });
        Assert.assertEquals((int)3, (int)allValues.size());
        for (int i = 0; i < 3; ++i) {
            Integer value = (Integer)store.remove(key1);
            Assert.assertTrue((boolean)allValues.remove(value));
        }
        Assert.assertNull(store.remove(key1));
        Assert.assertTrue((boolean)store.isEmpty());
    }

    @Test(timeout=60000L)
    public void testAdditionsAndRemovals() {
        int i;
        IdentityHashStore<Object, Integer> store = new IdentityHashStore<Object, Integer>(0);
        int NUM_KEYS = 1000;
        LOG.debug((Object)"generating 1000 keys");
        final ArrayList<Key> keys = new ArrayList<Key>(1000);
        for (i = 0; i < 1000; ++i) {
            keys.add(new Key("key " + i));
        }
        for (i = 0; i < 1000; ++i) {
            store.put(keys.get(i), i);
        }
        store.visitAll(new IdentityHashStore.Visitor<Key, Integer>(){

            @Override
            public void accept(Key k, Integer v) {
                Assert.assertTrue((boolean)keys.contains(k));
            }
        });
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((Object)i, store.remove(keys.get(i)));
        }
        store.visitAll(new IdentityHashStore.Visitor<Key, Integer>(){

            @Override
            public void accept(Key k, Integer v) {
                Assert.fail((String)"expected all entries to be removed");
            }
        });
        Assert.assertTrue((String)("expected the store to be empty, but found " + store.numElements() + " elements."), (boolean)store.isEmpty());
        Assert.assertEquals((int)1024, (int)store.capacity());
    }

    private static class Key {
        private final String name;

        Key(String name) {
            this.name = name;
        }

        public int hashCode() {
            throw new RuntimeException("should not be used!");
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            return this.name.equals(other.name);
        }
    }
}

