/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.util.HeapSort;
import org.apache.hadoop.util.IndexedSortable;
import org.apache.hadoop.util.IndexedSorter;
import org.apache.hadoop.util.QuickSort;

public class TestIndexedSort
extends TestCase {
    public void sortAllEqual(IndexedSorter sorter) throws Exception {
        int SAMPLE = 500;
        int[] values = new int[500];
        Arrays.fill(values, 10);
        SampleSortable s = new SampleSortable(values);
        sorter.sort(s, 0, 500);
        int[] check = s.getSorted();
        TestIndexedSort.assertTrue((String)(Arrays.toString(values) + "\ndoesn't match\n" + Arrays.toString(check)), (boolean)Arrays.equals(values, check));
        Random r = new Random();
        int min = r.nextInt(500);
        int max = (min + 1 + r.nextInt(498)) % 500;
        values[min] = 9;
        values[max] = 11;
        System.out.println("testAllEqual setting min/max at " + min + "/" + max + "(" + sorter.getClass().getName() + ")");
        s = new SampleSortable(values);
        sorter.sort(s, 0, 500);
        check = s.getSorted();
        Arrays.sort(values);
        TestIndexedSort.assertTrue((check[0] == 9 ? 1 : 0) != 0);
        TestIndexedSort.assertTrue((check[499] == 11 ? 1 : 0) != 0);
        TestIndexedSort.assertTrue((String)(Arrays.toString(values) + "\ndoesn't match\n" + Arrays.toString(check)), (boolean)Arrays.equals(values, check));
    }

    public void sortSorted(IndexedSorter sorter) throws Exception {
        int SAMPLE = 500;
        int[] values = new int[500];
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        System.out.println("testSorted seed: " + seed + "(" + sorter.getClass().getName() + ")");
        for (int i = 0; i < 500; ++i) {
            values[i] = r.nextInt(100);
        }
        Arrays.sort(values);
        SampleSortable s = new SampleSortable(values);
        sorter.sort(s, 0, 500);
        int[] check = s.getSorted();
        TestIndexedSort.assertTrue((String)(Arrays.toString(values) + "\ndoesn't match\n" + Arrays.toString(check)), (boolean)Arrays.equals(values, check));
    }

    public void sortSequential(IndexedSorter sorter) throws Exception {
        int SAMPLE = 500;
        int[] values = new int[500];
        for (int i = 0; i < 500; ++i) {
            values[i] = i;
        }
        SampleSortable s = new SampleSortable(values);
        sorter.sort(s, 0, 500);
        int[] check = s.getSorted();
        TestIndexedSort.assertTrue((String)(Arrays.toString(values) + "\ndoesn't match\n" + Arrays.toString(check)), (boolean)Arrays.equals(values, check));
    }

    public void sortSingleRecord(IndexedSorter sorter) throws Exception {
        boolean SAMPLE = true;
        SampleSortable s = new SampleSortable(1);
        int[] values = s.getValues();
        sorter.sort(s, 0, 1);
        int[] check = s.getSorted();
        TestIndexedSort.assertTrue((String)(Arrays.toString(values) + "\ndoesn't match\n" + Arrays.toString(check)), (boolean)Arrays.equals(values, check));
    }

    public void sortRandom(IndexedSorter sorter) throws Exception {
        int SAMPLE = 262144;
        SampleSortable s = new SampleSortable(262144);
        long seed = s.getSeed();
        System.out.println("sortRandom seed: " + seed + "(" + sorter.getClass().getName() + ")");
        int[] values = s.getValues();
        Arrays.sort(values);
        sorter.sort(s, 0, 262144);
        int[] check = s.getSorted();
        TestIndexedSort.assertTrue((String)("seed: " + seed + "\ndoesn't match\n"), (boolean)Arrays.equals(values, check));
    }

    public void sortWritable(IndexedSorter sorter) throws Exception {
        int SAMPLE = 1000;
        WritableSortable s = new WritableSortable(1000);
        long seed = s.getSeed();
        System.out.println("sortWritable seed: " + seed + "(" + sorter.getClass().getName() + ")");
        Object[] values = s.getValues();
        Arrays.sort(values);
        sorter.sort(s, 0, 1000);
        Object[] check = s.getSorted();
        TestIndexedSort.assertTrue((String)("seed: " + seed + "\ndoesn't match"), (boolean)Arrays.equals(values, check));
    }

    public void testQuickSort() throws Exception {
        QuickSort sorter = new QuickSort();
        this.sortRandom(sorter);
        this.sortSingleRecord(sorter);
        this.sortSequential(sorter);
        this.sortSorted(sorter);
        this.sortAllEqual(sorter);
        this.sortWritable(sorter);
        int DSAMPLE = 500;
        int[] values = new int[500];
        for (int i = 0; i < 500; ++i) {
            values[i] = i;
        }
        values[0] = values[499] + 1;
        SampleSortable s = new SampleSortable(values);
        values = s.getValues();
        int DSS = 62500;
        MeasuredSortable m = new MeasuredSortable(s, 62500);
        sorter.sort(m, 0, 500);
        System.out.println("QuickSort degen cmp/swp: " + m.getCmp() + "/" + m.getSwp() + "(" + sorter.getClass().getName() + ")");
        Arrays.sort(values);
        int[] check = s.getSorted();
        TestIndexedSort.assertTrue((boolean)Arrays.equals(values, check));
    }

    public void testHeapSort() throws Exception {
        HeapSort sorter = new HeapSort();
        this.sortRandom(sorter);
        this.sortSingleRecord(sorter);
        this.sortSequential(sorter);
        this.sortSorted(sorter);
        this.sortAllEqual(sorter);
        this.sortWritable(sorter);
    }

    private static class WritableSortable
    implements IndexedSortable {
        private static Random r = new Random();
        private final int eob;
        private final int[] indices;
        private final int[] offsets;
        private final byte[] bytes;
        private final WritableComparator comparator;
        private final String[] check;
        private final long seed = r.nextLong();

        public WritableSortable() throws IOException {
            this(100);
        }

        public WritableSortable(int j) throws IOException {
            r.setSeed(this.seed);
            Text t = new Text();
            StringBuilder sb = new StringBuilder();
            this.indices = new int[j];
            this.offsets = new int[j];
            this.check = new String[j];
            DataOutputBuffer dob = new DataOutputBuffer();
            for (int i = 0; i < j; ++i) {
                this.indices[i] = i;
                this.offsets[i] = dob.getLength();
                WritableSortable.genRandom(t, r.nextInt(15) + 1, sb);
                t.write(dob);
                this.check[i] = t.toString();
            }
            this.eob = dob.getLength();
            this.bytes = dob.getData();
            this.comparator = WritableComparator.get(Text.class);
        }

        public long getSeed() {
            return this.seed;
        }

        private static void genRandom(Text t, int len, StringBuilder sb) {
            sb.setLength(0);
            for (int i = 0; i < len; ++i) {
                sb.append(Integer.toString(r.nextInt(26) + 10, 36));
            }
            t.set(sb.toString());
        }

        @Override
        public int compare(int i, int j) {
            int ii = this.indices[i];
            int ij = this.indices[j];
            return this.comparator.compare(this.bytes, this.offsets[ii], (ii + 1 == this.indices.length ? this.eob : this.offsets[ii + 1]) - this.offsets[ii], this.bytes, this.offsets[ij], (ij + 1 == this.indices.length ? this.eob : this.offsets[ij + 1]) - this.offsets[ij]);
        }

        @Override
        public void swap(int i, int j) {
            int tmp = this.indices[i];
            this.indices[i] = this.indices[j];
            this.indices[j] = tmp;
        }

        public String[] getValues() {
            return this.check;
        }

        public String[] getSorted() throws IOException {
            String[] ret = new String[this.indices.length];
            Text t = new Text();
            DataInputBuffer dib = new DataInputBuffer();
            for (int i = 0; i < ret.length; ++i) {
                int ii = this.indices[i];
                dib.reset(this.bytes, this.offsets[ii], (ii + 1 == this.indices.length ? this.eob : this.offsets[ii + 1]) - this.offsets[ii]);
                t.readFields(dib);
                ret[i] = t.toString();
            }
            return ret;
        }
    }

    public static class MeasuredSortable
    implements IndexedSortable {
        private int comparisions;
        private int swaps;
        private final int maxcmp;
        private final int maxswp;
        private IndexedSortable s;

        public MeasuredSortable(IndexedSortable s) {
            this(s, Integer.MAX_VALUE);
        }

        public MeasuredSortable(IndexedSortable s, int maxcmp) {
            this(s, maxcmp, Integer.MAX_VALUE);
        }

        public MeasuredSortable(IndexedSortable s, int maxcmp, int maxswp) {
            this.s = s;
            this.maxcmp = maxcmp;
            this.maxswp = maxswp;
        }

        public int getCmp() {
            return this.comparisions;
        }

        public int getSwp() {
            return this.swaps;
        }

        @Override
        public int compare(int i, int j) {
            Assert.assertTrue((String)("Expected fewer than " + this.maxcmp + " comparisons"), (++this.comparisions < this.maxcmp ? 1 : 0) != 0);
            return this.s.compare(i, j);
        }

        @Override
        public void swap(int i, int j) {
            Assert.assertTrue((String)("Expected fewer than " + this.maxswp + " swaps"), (++this.swaps < this.maxswp ? 1 : 0) != 0);
            this.s.swap(i, j);
        }
    }

    private static class SampleSortable
    implements IndexedSortable {
        private int[] valindex;
        private int[] valindirect;
        private int[] values;
        private final long seed;

        public SampleSortable() {
            this(50);
        }

        public SampleSortable(int j) {
            Random r = new Random();
            this.seed = r.nextLong();
            r.setSeed(this.seed);
            this.values = new int[j];
            this.valindex = new int[j];
            this.valindirect = new int[j];
            for (int i = 0; i < j; ++i) {
                this.valindex[i] = this.valindirect[i] = i;
                this.values[i] = r.nextInt(1000);
            }
        }

        public SampleSortable(int[] values) {
            this.values = values;
            this.valindex = new int[values.length];
            this.valindirect = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.valindex[i] = this.valindirect[i] = i;
            }
            this.seed = 0L;
        }

        public long getSeed() {
            return this.seed;
        }

        @Override
        public int compare(int i, int j) {
            return this.values[this.valindirect[this.valindex[i]]] - this.values[this.valindirect[this.valindex[j]]];
        }

        @Override
        public void swap(int i, int j) {
            int tmp = this.valindex[i];
            this.valindex[i] = this.valindex[j];
            this.valindex[j] = tmp;
        }

        public int[] getSorted() {
            int[] ret = new int[this.values.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.values[this.valindirect[this.valindex[i]]];
            }
            return ret;
        }

        public int[] getValues() {
            int[] ret = new int[this.values.length];
            System.arraycopy(this.values, 0, ret, 0, this.values.length);
            return ret;
        }
    }
}

