/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.hadoop.util.ShutdownThreadsHelper;
import org.junit.Assert;
import org.junit.Test;

public class TestShutdownThreadsHelper {
    private Runnable sampleRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                Thread.sleep(6000L);
            }
            catch (InterruptedException ie) {
                System.out.println("Thread interrupted");
            }
        }
    };

    @Test(timeout=3000L)
    public void testShutdownThread() {
        Thread thread = new Thread(this.sampleRunnable);
        thread.start();
        boolean ret = ShutdownThreadsHelper.shutdownThread(thread);
        boolean isTerminated = !thread.isAlive();
        Assert.assertEquals((String)"Incorrect return value", (Object)ret, (Object)isTerminated);
        Assert.assertTrue((String)"Thread is not shutdown", (boolean)isTerminated);
    }

    @Test
    public void testShutdownThreadPool() throws InterruptedException {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.execute(this.sampleRunnable);
        boolean ret = ShutdownThreadsHelper.shutdownExecutorService(executor);
        boolean isTerminated = executor.isTerminated();
        Assert.assertEquals((String)"Incorrect return value", (Object)ret, (Object)isTerminated);
        Assert.assertTrue((String)"ExecutorService is not shutdown", (boolean)isTerminated);
    }
}

