/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.util.StringInterner;
import org.junit.Assert;
import org.junit.Test;

public class TestStringInterner {
    @Test
    public void testNoIntern() {
        String literalABC = "ABC";
        String substringABC = "ABCDE".substring(0, 3);
        String heapABC = new String("ABC");
        Assert.assertNotSame((Object)literalABC, (Object)substringABC);
        Assert.assertNotSame((Object)literalABC, (Object)heapABC);
        Assert.assertNotSame((Object)substringABC, (Object)heapABC);
    }

    @Test
    public void testStrongIntern() {
        String strongInternLiteralABC = StringInterner.strongIntern("ABC");
        String strongInternSubstringABC = StringInterner.strongIntern("ABCDE".substring(0, 3));
        String strongInternHeapABC = StringInterner.strongIntern(new String("ABC"));
        Assert.assertSame((Object)strongInternLiteralABC, (Object)strongInternSubstringABC);
        Assert.assertSame((Object)strongInternLiteralABC, (Object)strongInternHeapABC);
        Assert.assertSame((Object)strongInternSubstringABC, (Object)strongInternHeapABC);
    }

    @Test
    public void testWeakIntern() {
        String weakInternLiteralABC = StringInterner.weakIntern("ABC");
        String weakInternSubstringABC = StringInterner.weakIntern("ABCDE".substring(0, 3));
        String weakInternHeapABC = StringInterner.weakIntern(new String("ABC"));
        Assert.assertSame((Object)weakInternLiteralABC, (Object)weakInternSubstringABC);
        Assert.assertSame((Object)weakInternLiteralABC, (Object)weakInternHeapABC);
        Assert.assertSame((Object)weakInternSubstringABC, (Object)weakInternHeapABC);
    }
}

