/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.timeline;

import java.io.IOException;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.map.ObjectMapper;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.map.ObjectReader;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.map.ObjectWriter;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GenericObjectMapper {
    private static final byte[] EMPTY_BYTES = new byte[0];
    public static final ObjectReader OBJECT_READER;
    public static final ObjectWriter OBJECT_WRITER;

    public static byte[] write(Object o) throws IOException {
        if (o == null) {
            return EMPTY_BYTES;
        }
        return OBJECT_WRITER.writeValueAsBytes(o);
    }

    public static Object read(byte[] b) throws IOException {
        return GenericObjectMapper.read(b, 0);
    }

    public static Object read(byte[] b, int offset) throws IOException {
        if (b == null || b.length == 0) {
            return null;
        }
        return OBJECT_READER.readValue(b, offset, b.length - offset);
    }

    public static byte[] writeReverseOrderedLong(long l) {
        byte[] b = new byte[8];
        return GenericObjectMapper.writeReverseOrderedLong(l, b, 0);
    }

    public static byte[] writeReverseOrderedLong(long l, byte[] b, int offset) {
        b[offset] = (byte)(0x7FL ^ l >> 56 & 0xFFL);
        for (int i = offset + 1; i < offset + 7; ++i) {
            b[i] = (byte)(0xFFL ^ l >> 8 * (7 - i) & 0xFFL);
        }
        b[offset + 7] = (byte)(0xFFL ^ l & 0xFFL);
        return b;
    }

    public static long readReverseOrderedLong(byte[] b, int offset) {
        long l = b[offset] & 0xFF;
        for (int i = 1; i < 8; ++i) {
            l <<= 8;
            l |= (long)(b[offset + i] & 0xFF);
        }
        return l ^ Long.MAX_VALUE;
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        OBJECT_READER = mapper.reader(Object.class);
        OBJECT_WRITER = mapper.writer();
    }
}

