/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.application;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRetentionPolicy;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationFinishEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerKillEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ApplicationLocalizationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerAppFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerAppStartedEvent;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

public class ApplicationImpl
implements Application {
    final Dispatcher dispatcher;
    final String user;
    final ApplicationId appId;
    final Credentials credentials;
    Map<ApplicationAccessType, String> applicationACLs;
    final ApplicationACLsManager aclsManager;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Context context;
    private static final Log LOG = LogFactory.getLog(Application.class);
    Map<ContainerId, Container> containers = new HashMap<ContainerId, Container>();
    private static final ContainerDoneTransition CONTAINER_DONE_TRANSITION = new ContainerDoneTransition();
    private static StateMachineFactory<ApplicationImpl, ApplicationState, ApplicationEventType, ApplicationEvent> stateMachineFactory = new StateMachineFactory<ApplicationImpl, ApplicationState, ApplicationEventType, ApplicationEvent>(ApplicationState.NEW).addTransition(ApplicationState.NEW, ApplicationState.INITING, ApplicationEventType.INIT_APPLICATION, new AppInitTransition()).addTransition(ApplicationState.NEW, ApplicationState.NEW, ApplicationEventType.INIT_CONTAINER, (SingleArcTransition<ApplicationImpl, ApplicationEvent>)new InitContainerTransition()).addTransition(ApplicationState.INITING, ApplicationState.INITING, ApplicationEventType.INIT_CONTAINER, (SingleArcTransition<ApplicationImpl, ApplicationEvent>)new InitContainerTransition()).addTransition(ApplicationState.INITING, EnumSet.of(ApplicationState.FINISHING_CONTAINERS_WAIT, ApplicationState.APPLICATION_RESOURCES_CLEANINGUP), ApplicationEventType.FINISH_APPLICATION, new AppFinishTriggeredTransition()).addTransition(ApplicationState.INITING, ApplicationState.INITING, ApplicationEventType.APPLICATION_CONTAINER_FINISHED, (SingleArcTransition<ApplicationImpl, ApplicationEvent>)CONTAINER_DONE_TRANSITION).addTransition(ApplicationState.INITING, ApplicationState.INITING, ApplicationEventType.APPLICATION_LOG_HANDLING_INITED, (SingleArcTransition<ApplicationImpl, ApplicationEvent>)new AppLogInitDoneTransition()).addTransition(ApplicationState.INITING, ApplicationState.INITING, ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED, (SingleArcTransition<ApplicationImpl, ApplicationEvent>)new AppLogInitFailTransition()).addTransition(ApplicationState.INITING, ApplicationState.RUNNING, ApplicationEventType.APPLICATION_INITED, (SingleArcTransition<ApplicationImpl, ApplicationEvent>)new AppInitDoneTransition()).addTransition(ApplicationState.RUNNING, ApplicationState.RUNNING, ApplicationEventType.INIT_CONTAINER, (SingleArcTransition<ApplicationImpl, ApplicationEvent>)new InitContainerTransition()).addTransition(ApplicationState.RUNNING, ApplicationState.RUNNING, ApplicationEventType.APPLICATION_CONTAINER_FINISHED, (SingleArcTransition<ApplicationImpl, ApplicationEvent>)CONTAINER_DONE_TRANSITION).addTransition(ApplicationState.RUNNING, EnumSet.of(ApplicationState.FINISHING_CONTAINERS_WAIT, ApplicationState.APPLICATION_RESOURCES_CLEANINGUP), ApplicationEventType.FINISH_APPLICATION, new AppFinishTriggeredTransition()).addTransition(ApplicationState.FINISHING_CONTAINERS_WAIT, EnumSet.of(ApplicationState.FINISHING_CONTAINERS_WAIT, ApplicationState.APPLICATION_RESOURCES_CLEANINGUP), ApplicationEventType.APPLICATION_CONTAINER_FINISHED, new AppFinishTransition()).addTransition(ApplicationState.FINISHING_CONTAINERS_WAIT, ApplicationState.FINISHING_CONTAINERS_WAIT, EnumSet.of(ApplicationEventType.APPLICATION_LOG_HANDLING_INITED, ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED, ApplicationEventType.APPLICATION_INITED, ApplicationEventType.FINISH_APPLICATION)).addTransition(ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, ApplicationEventType.APPLICATION_CONTAINER_FINISHED).addTransition(ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, ApplicationState.FINISHED, ApplicationEventType.APPLICATION_RESOURCES_CLEANEDUP, (SingleArcTransition<ApplicationImpl, ApplicationEvent>)new AppCompletelyDoneTransition()).addTransition(ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, ApplicationState.APPLICATION_RESOURCES_CLEANINGUP, EnumSet.of(ApplicationEventType.APPLICATION_LOG_HANDLING_INITED, ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED, ApplicationEventType.APPLICATION_LOG_HANDLING_FINISHED, ApplicationEventType.APPLICATION_INITED, ApplicationEventType.FINISH_APPLICATION)).addTransition(ApplicationState.FINISHED, ApplicationState.FINISHED, ApplicationEventType.APPLICATION_LOG_HANDLING_FINISHED, (SingleArcTransition<ApplicationImpl, ApplicationEvent>)new AppLogsAggregatedTransition()).addTransition(ApplicationState.FINISHED, ApplicationState.FINISHED, EnumSet.of(ApplicationEventType.APPLICATION_LOG_HANDLING_INITED, ApplicationEventType.APPLICATION_LOG_HANDLING_FAILED, ApplicationEventType.FINISH_APPLICATION)).installTopology();
    private final StateMachine<ApplicationState, ApplicationEventType, ApplicationEvent> stateMachine;

    public ApplicationImpl(Dispatcher dispatcher, String user, ApplicationId appId, Credentials credentials, Context context) {
        this.dispatcher = dispatcher;
        this.user = user;
        this.appId = appId;
        this.credentials = credentials;
        this.aclsManager = context.getApplicationACLsManager();
        this.context = context;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make(this);
    }

    @Override
    public String getUser() {
        return this.user.toString();
    }

    @Override
    public ApplicationId getAppId() {
        return this.appId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationState getApplicationState() {
        this.readLock.lock();
        try {
            ApplicationState applicationState = this.stateMachine.getCurrentState();
            return applicationState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ContainerId, Container> getContainers() {
        this.readLock.lock();
        try {
            Map<ContainerId, Container> map = this.containers;
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void handleAppFinishWithContainersCleanedup() {
        this.dispatcher.getEventHandler().handle(new ApplicationLocalizationEvent(LocalizationEventType.DESTROY_APPLICATION_RESOURCES, this));
        this.dispatcher.getEventHandler().handle(new AuxServicesEvent(AuxServicesEventType.APPLICATION_STOP, this.appId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(ApplicationEvent event) {
        this.writeLock.lock();
        try {
            ApplicationId applicationID = event.getApplicationID();
            LOG.debug((Object)("Processing " + applicationID + " of type " + event.getType()));
            ApplicationState oldState = this.stateMachine.getCurrentState();
            ApplicationState newState = null;
            try {
                newState = this.stateMachine.doTransition((ApplicationEventType)((Object)event.getType()), event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.warn((Object)"Can't handle this event at current state", (Throwable)e);
            }
            if (oldState != newState) {
                LOG.info((Object)("Application " + applicationID + " transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState)));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String toString() {
        return this.appId.toString();
    }

    static class AppLogsAggregatedTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppLogsAggregatedTransition() {
        }

        @Override
        public void transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationId appId = event.getApplicationID();
            app.context.getApplications().remove(appId);
            app.aclsManager.removeApplication(appId);
        }
    }

    static class AppCompletelyDoneTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppCompletelyDoneTransition() {
        }

        @Override
        public void transition(ApplicationImpl app, ApplicationEvent event) {
            app.dispatcher.getEventHandler().handle(new LogHandlerAppFinishedEvent(app.appId));
            app.context.getNMTokenSecretManager().appFinished(app.getAppId());
        }
    }

    static class AppFinishTransition
    implements MultipleArcTransition<ApplicationImpl, ApplicationEvent, ApplicationState> {
        AppFinishTransition() {
        }

        @Override
        public ApplicationState transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationContainerFinishedEvent containerFinishEvent = (ApplicationContainerFinishedEvent)event;
            LOG.info((Object)("Removing " + containerFinishEvent.getContainerID() + " from application " + app.toString()));
            app.containers.remove(containerFinishEvent.getContainerID());
            if (app.containers.isEmpty()) {
                app.handleAppFinishWithContainersCleanedup();
                return ApplicationState.APPLICATION_RESOURCES_CLEANINGUP;
            }
            return ApplicationState.FINISHING_CONTAINERS_WAIT;
        }
    }

    static class AppFinishTriggeredTransition
    implements MultipleArcTransition<ApplicationImpl, ApplicationEvent, ApplicationState> {
        AppFinishTriggeredTransition() {
        }

        @Override
        public ApplicationState transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationFinishEvent appEvent = (ApplicationFinishEvent)event;
            if (app.containers.isEmpty()) {
                app.handleAppFinishWithContainersCleanedup();
                return ApplicationState.APPLICATION_RESOURCES_CLEANINGUP;
            }
            for (ContainerId containerID : app.containers.keySet()) {
                app.dispatcher.getEventHandler().handle(new ContainerKillEvent(containerID, "Container killed on application-finish event: " + appEvent.getDiagnostic()));
            }
            return ApplicationState.FINISHING_CONTAINERS_WAIT;
        }
    }

    static final class ContainerDoneTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        ContainerDoneTransition() {
        }

        @Override
        public void transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationContainerFinishedEvent containerEvent = (ApplicationContainerFinishedEvent)event;
            if (null == app.containers.remove(containerEvent.getContainerID())) {
                LOG.warn((Object)("Removing unknown " + containerEvent.getContainerID() + " from application " + app.toString()));
            } else {
                LOG.info((Object)("Removing " + containerEvent.getContainerID() + " from application " + app.toString()));
            }
        }
    }

    static class AppInitDoneTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppInitDoneTransition() {
        }

        @Override
        public void transition(ApplicationImpl app, ApplicationEvent event) {
            for (Container container : app.containers.values()) {
                app.dispatcher.getEventHandler().handle(new ContainerInitEvent(container.getContainerId()));
            }
        }
    }

    static class InitContainerTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        InitContainerTransition() {
        }

        @Override
        public void transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationContainerInitEvent initEvent = (ApplicationContainerInitEvent)event;
            Container container = initEvent.getContainer();
            app.containers.put(container.getContainerId(), container);
            LOG.info((Object)("Adding " + container.getContainerId() + " to application " + app.toString()));
            switch (app.getApplicationState()) {
                case RUNNING: {
                    app.dispatcher.getEventHandler().handle(new ContainerInitEvent(container.getContainerId()));
                    break;
                }
                case INITING: 
                case NEW: {
                    break;
                }
                default: {
                    assert (false) : "Invalid state for InitContainerTransition: " + (Object)((Object)app.getApplicationState());
                    break;
                }
            }
        }
    }

    static class AppLogInitFailTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppLogInitFailTransition() {
        }

        @Override
        public void transition(ApplicationImpl app, ApplicationEvent event) {
            LOG.warn((Object)"Log Aggregation service failed to initialize, there will be no logs for this application");
            app.dispatcher.getEventHandler().handle(new ApplicationLocalizationEvent(LocalizationEventType.INIT_APPLICATION_RESOURCES, app));
        }
    }

    static class AppLogInitDoneTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppLogInitDoneTransition() {
        }

        @Override
        public void transition(ApplicationImpl app, ApplicationEvent event) {
            app.dispatcher.getEventHandler().handle(new ApplicationLocalizationEvent(LocalizationEventType.INIT_APPLICATION_RESOURCES, app));
        }
    }

    static class AppInitTransition
    implements SingleArcTransition<ApplicationImpl, ApplicationEvent> {
        AppInitTransition() {
        }

        @Override
        public void transition(ApplicationImpl app, ApplicationEvent event) {
            ApplicationInitEvent initEvent = (ApplicationInitEvent)event;
            app.applicationACLs = initEvent.getApplicationACLs();
            app.aclsManager.addApplication(app.getAppId(), app.applicationACLs);
            app.dispatcher.getEventHandler().handle(new LogHandlerAppStartedEvent(app.appId, app.user, app.credentials, ContainerLogsRetentionPolicy.ALL_CONTAINERS, app.applicationACLs));
        }
    }
}

