/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEventType;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEventType;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRemoveAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateUpdateAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateUpdateAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateVersionIncompatibleException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.StoreFencedException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMStateVersion;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppNewSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppUpdateSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptNewSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUpdateSavedEvent;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class RMStateStore
extends AbstractService {
    protected static final String RM_APP_ROOT = "RMAppRoot";
    protected static final String RM_DT_SECRET_MANAGER_ROOT = "RMDTSecretManagerRoot";
    protected static final String DELEGATION_KEY_PREFIX = "DelegationKey_";
    protected static final String DELEGATION_TOKEN_PREFIX = "RMDelegationToken_";
    protected static final String DELEGATION_TOKEN_SEQUENCE_NUMBER_PREFIX = "RMDTSequenceNumber_";
    protected static final String VERSION_NODE = "RMVersionNode";
    public static final Log LOG = LogFactory.getLog(RMStateStore.class);
    private Dispatcher rmDispatcher;
    AsyncDispatcher dispatcher;
    public static final Text AM_RM_TOKEN_SERVICE = new Text("AM_RM_TOKEN_SERVICE");
    public static final Text AM_CLIENT_TOKEN_MASTER_KEY_NAME = new Text("YARN_CLIENT_TOKEN_MASTER_KEY");

    public RMStateStore() {
        super(RMStateStore.class.getName());
    }

    public void setRMDispatcher(Dispatcher dispatcher) {
        this.rmDispatcher = dispatcher;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        this.dispatcher = new AsyncDispatcher();
        this.dispatcher.init(conf);
        this.dispatcher.register(RMStateStoreEventType.class, new ForwardingEventHandler());
        this.dispatcher.setDrainEventsOnStop();
        this.initInternal(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        this.dispatcher.start();
        this.startInternal();
    }

    protected abstract void initInternal(Configuration var1) throws Exception;

    protected abstract void startInternal() throws Exception;

    @Override
    protected void serviceStop() throws Exception {
        this.closeInternal();
        this.dispatcher.stop();
    }

    protected abstract void closeInternal() throws Exception;

    public void checkVersion() throws Exception {
        RMStateVersion loadedVersion = this.loadVersion();
        LOG.info((Object)("Loaded RM state version info " + loadedVersion));
        if (loadedVersion != null && loadedVersion.equals(this.getCurrentVersion())) {
            return;
        }
        if (loadedVersion == null) {
            loadedVersion = RMStateVersion.newInstance(1, 0);
        }
        if (!loadedVersion.isCompatibleTo(this.getCurrentVersion())) {
            throw new RMStateVersionIncompatibleException("Expecting RM state version " + this.getCurrentVersion() + ", but loading version " + loadedVersion);
        }
        LOG.info((Object)("Storing RM state version info " + this.getCurrentVersion()));
        this.storeVersion();
    }

    protected abstract RMStateVersion loadVersion() throws Exception;

    protected abstract void storeVersion() throws Exception;

    protected abstract RMStateVersion getCurrentVersion();

    public abstract RMState loadState() throws Exception;

    public synchronized void storeNewApplication(RMApp app) {
        ApplicationSubmissionContext context = app.getApplicationSubmissionContext();
        assert (context instanceof ApplicationSubmissionContextPBImpl);
        ApplicationState appState = new ApplicationState(app.getSubmitTime(), app.getStartTime(), context, app.getUser());
        this.dispatcher.getEventHandler().handle(new RMStateStoreAppEvent(appState));
    }

    public synchronized void updateApplicationState(ApplicationState appState) {
        this.dispatcher.getEventHandler().handle(new RMStateUpdateAppEvent(appState));
    }

    protected abstract void storeApplicationStateInternal(ApplicationId var1, ApplicationStateDataPBImpl var2) throws Exception;

    protected abstract void updateApplicationStateInternal(ApplicationId var1, ApplicationStateDataPBImpl var2) throws Exception;

    public synchronized void storeNewApplicationAttempt(RMAppAttempt appAttempt) {
        Credentials credentials = this.getCredentialsFromAppAttempt(appAttempt);
        ApplicationAttemptState attemptState = new ApplicationAttemptState(appAttempt.getAppAttemptId(), appAttempt.getMasterContainer(), credentials, appAttempt.getStartTime());
        this.dispatcher.getEventHandler().handle(new RMStateStoreAppAttemptEvent(attemptState));
    }

    public synchronized void updateApplicationAttemptState(ApplicationAttemptState attemptState) {
        this.dispatcher.getEventHandler().handle(new RMStateUpdateAppAttemptEvent(attemptState));
    }

    protected abstract void storeApplicationAttemptStateInternal(ApplicationAttemptId var1, ApplicationAttemptStateDataPBImpl var2) throws Exception;

    protected abstract void updateApplicationAttemptStateInternal(ApplicationAttemptId var1, ApplicationAttemptStateDataPBImpl var2) throws Exception;

    public synchronized void storeRMDelegationTokenAndSequenceNumber(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber) {
        try {
            this.storeRMDelegationTokenAndSequenceNumberState(rmDTIdentifier, renewDate, latestSequenceNumber);
        }
        catch (Exception e) {
            this.notifyStoreOperationFailed(e);
        }
    }

    protected abstract void storeRMDelegationTokenAndSequenceNumberState(RMDelegationTokenIdentifier var1, Long var2, int var3) throws Exception;

    public synchronized void removeRMDelegationToken(RMDelegationTokenIdentifier rmDTIdentifier, int sequenceNumber) {
        try {
            this.removeRMDelegationTokenState(rmDTIdentifier);
        }
        catch (Exception e) {
            this.notifyStoreOperationFailed(e);
        }
    }

    protected abstract void removeRMDelegationTokenState(RMDelegationTokenIdentifier var1) throws Exception;

    public synchronized void updateRMDelegationTokenAndSequenceNumber(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber) {
        try {
            this.updateRMDelegationTokenAndSequenceNumberInternal(rmDTIdentifier, renewDate, latestSequenceNumber);
        }
        catch (Exception e) {
            this.notifyStoreOperationFailed(e);
        }
    }

    protected abstract void updateRMDelegationTokenAndSequenceNumberInternal(RMDelegationTokenIdentifier var1, Long var2, int var3) throws Exception;

    public synchronized void storeRMDTMasterKey(DelegationKey delegationKey) {
        try {
            this.storeRMDTMasterKeyState(delegationKey);
        }
        catch (Exception e) {
            this.notifyStoreOperationFailed(e);
        }
    }

    protected abstract void storeRMDTMasterKeyState(DelegationKey var1) throws Exception;

    public synchronized void removeRMDTMasterKey(DelegationKey delegationKey) {
        try {
            this.removeRMDTMasterKeyState(delegationKey);
        }
        catch (Exception e) {
            this.notifyStoreOperationFailed(e);
        }
    }

    protected abstract void removeRMDTMasterKeyState(DelegationKey var1) throws Exception;

    public synchronized void removeApplication(RMApp app) {
        ApplicationState appState = new ApplicationState(app.getSubmitTime(), app.getStartTime(), app.getApplicationSubmissionContext(), app.getUser());
        for (RMAppAttempt appAttempt : app.getAppAttempts().values()) {
            Credentials credentials = this.getCredentialsFromAppAttempt(appAttempt);
            ApplicationAttemptState attemptState = new ApplicationAttemptState(appAttempt.getAppAttemptId(), appAttempt.getMasterContainer(), credentials, appAttempt.getStartTime());
            appState.attempts.put(attemptState.getAttemptId(), attemptState);
        }
        this.dispatcher.getEventHandler().handle(new RMStateStoreRemoveAppEvent(appState));
    }

    protected abstract void removeApplicationStateInternal(ApplicationState var1) throws Exception;

    public Credentials getCredentialsFromAppAttempt(RMAppAttempt appAttempt) {
        SecretKey clientTokenMasterKey;
        Credentials credentials = new Credentials();
        Token<AMRMTokenIdentifier> appToken = appAttempt.getAMRMToken();
        if (appToken != null) {
            credentials.addToken(AM_RM_TOKEN_SERVICE, appToken);
        }
        if ((clientTokenMasterKey = appAttempt.getClientTokenMasterKey()) != null) {
            credentials.addSecretKey(AM_CLIENT_TOKEN_MASTER_KEY_NAME, clientTokenMasterKey.getEncoded());
        }
        return credentials;
    }

    protected void handleStoreEvent(RMStateStoreEvent event) {
        block24: {
            if (((RMStateStoreEventType)((Object)event.getType())).equals((Object)RMStateStoreEventType.STORE_APP) || ((RMStateStoreEventType)((Object)event.getType())).equals((Object)RMStateStoreEventType.UPDATE_APP)) {
                ApplicationState appState = null;
                if (((RMStateStoreEventType)((Object)event.getType())).equals((Object)RMStateStoreEventType.STORE_APP)) {
                    appState = ((RMStateStoreAppEvent)event).getAppState();
                } else {
                    assert (((RMStateStoreEventType)((Object)event.getType())).equals((Object)RMStateStoreEventType.UPDATE_APP));
                    appState = ((RMStateUpdateAppEvent)event).getAppState();
                }
                Exception storedException = null;
                ApplicationStateDataPBImpl appStateData = (ApplicationStateDataPBImpl)ApplicationStateDataPBImpl.newApplicationStateData(appState.getSubmitTime(), appState.getStartTime(), appState.getUser(), appState.getApplicationSubmissionContext(), appState.getState(), appState.getDiagnostics(), appState.getFinishTime());
                ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
                LOG.info((Object)("Storing info for app: " + appId));
                try {
                    if (((RMStateStoreEventType)((Object)event.getType())).equals((Object)RMStateStoreEventType.STORE_APP)) {
                        this.storeApplicationStateInternal(appId, appStateData);
                        this.notifyDoneStoringApplication(appId, storedException);
                        break block24;
                    }
                    assert (((RMStateStoreEventType)((Object)event.getType())).equals((Object)RMStateStoreEventType.UPDATE_APP));
                    this.updateApplicationStateInternal(appId, appStateData);
                    this.notifyDoneUpdatingApplication(appId, storedException);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error storing/updating app: " + appId), (Throwable)e);
                    this.notifyStoreOperationFailed(e);
                }
            } else if (((RMStateStoreEventType)((Object)event.getType())).equals((Object)RMStateStoreEventType.STORE_APP_ATTEMPT) || ((RMStateStoreEventType)((Object)event.getType())).equals((Object)RMStateStoreEventType.UPDATE_APP_ATTEMPT)) {
                ApplicationAttemptState attemptState = null;
                if (((RMStateStoreEventType)((Object)event.getType())).equals((Object)RMStateStoreEventType.STORE_APP_ATTEMPT)) {
                    attemptState = ((RMStateStoreAppAttemptEvent)event).getAppAttemptState();
                } else {
                    assert (((RMStateStoreEventType)((Object)event.getType())).equals((Object)RMStateStoreEventType.UPDATE_APP_ATTEMPT));
                    attemptState = ((RMStateUpdateAppAttemptEvent)event).getAppAttemptState();
                }
                Exception storedException = null;
                Credentials credentials = attemptState.getAppAttemptCredentials();
                ByteBuffer appAttemptTokens = null;
                try {
                    if (credentials != null) {
                        DataOutputBuffer dob = new DataOutputBuffer();
                        credentials.writeTokenStorageToStream(dob);
                        appAttemptTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
                    }
                    ApplicationAttemptStateDataPBImpl attemptStateData = (ApplicationAttemptStateDataPBImpl)ApplicationAttemptStateDataPBImpl.newApplicationAttemptStateData(attemptState.getAttemptId(), attemptState.getMasterContainer(), appAttemptTokens, attemptState.getStartTime(), attemptState.getState(), attemptState.getFinalTrackingUrl(), attemptState.getDiagnostics(), attemptState.getFinalApplicationStatus());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Storing info for attempt: " + attemptState.getAttemptId()));
                    }
                    if (((RMStateStoreEventType)((Object)event.getType())).equals((Object)RMStateStoreEventType.STORE_APP_ATTEMPT)) {
                        this.storeApplicationAttemptStateInternal(attemptState.getAttemptId(), attemptStateData);
                        this.notifyDoneStoringApplicationAttempt(attemptState.getAttemptId(), storedException);
                        break block24;
                    }
                    assert (((RMStateStoreEventType)((Object)event.getType())).equals((Object)RMStateStoreEventType.UPDATE_APP_ATTEMPT));
                    this.updateApplicationAttemptStateInternal(attemptState.getAttemptId(), attemptStateData);
                    this.notifyDoneUpdatingApplicationAttempt(attemptState.getAttemptId(), storedException);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error storing/updating appAttempt: " + attemptState.getAttemptId()), (Throwable)e);
                    this.notifyStoreOperationFailed(e);
                }
            } else if (((RMStateStoreEventType)((Object)event.getType())).equals((Object)RMStateStoreEventType.REMOVE_APP)) {
                ApplicationState appState = ((RMStateStoreRemoveAppEvent)event).getAppState();
                ApplicationId appId = appState.getAppId();
                LOG.info((Object)("Removing info for app: " + appId));
                try {
                    this.removeApplicationStateInternal(appState);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error removing app: " + appId), (Throwable)e);
                    this.notifyStoreOperationFailed(e);
                }
            } else {
                LOG.error((Object)("Unknown RMStateStoreEvent type: " + event.getType()));
            }
        }
    }

    protected void notifyStoreOperationFailed(Exception failureCause) {
        RMFatalEventType type = failureCause instanceof StoreFencedException ? RMFatalEventType.STATE_STORE_FENCED : RMFatalEventType.STATE_STORE_OP_FAILED;
        this.rmDispatcher.getEventHandler().handle(new RMFatalEvent(type, failureCause));
    }

    private void notifyDoneStoringApplication(ApplicationId appId, Exception storedException) {
        this.rmDispatcher.getEventHandler().handle(new RMAppNewSavedEvent(appId, storedException));
    }

    private void notifyDoneUpdatingApplication(ApplicationId appId, Exception storedException) {
        this.rmDispatcher.getEventHandler().handle(new RMAppUpdateSavedEvent(appId, storedException));
    }

    private void notifyDoneStoringApplicationAttempt(ApplicationAttemptId attemptId, Exception storedException) {
        this.rmDispatcher.getEventHandler().handle(new RMAppAttemptNewSavedEvent(attemptId, storedException));
    }

    private void notifyDoneUpdatingApplicationAttempt(ApplicationAttemptId attemptId, Exception updatedException) {
        this.rmDispatcher.getEventHandler().handle(new RMAppAttemptUpdateSavedEvent(attemptId, updatedException));
    }

    private final class ForwardingEventHandler
    implements EventHandler<RMStateStoreEvent> {
        private ForwardingEventHandler() {
        }

        @Override
        public void handle(RMStateStoreEvent event) {
            RMStateStore.this.handleStoreEvent(event);
        }
    }

    public static class RMState {
        Map<ApplicationId, ApplicationState> appState = new HashMap<ApplicationId, ApplicationState>();
        RMDTSecretManagerState rmSecretManagerState = new RMDTSecretManagerState();

        public Map<ApplicationId, ApplicationState> getApplicationState() {
            return this.appState;
        }

        public RMDTSecretManagerState getRMDTSecretManagerState() {
            return this.rmSecretManagerState;
        }
    }

    public static class RMDTSecretManagerState {
        Map<RMDelegationTokenIdentifier, Long> delegationTokenState = new HashMap<RMDelegationTokenIdentifier, Long>();
        Set<DelegationKey> masterKeyState = new HashSet<DelegationKey>();
        int dtSequenceNumber = 0;

        public Map<RMDelegationTokenIdentifier, Long> getTokenState() {
            return this.delegationTokenState;
        }

        public Set<DelegationKey> getMasterKeyState() {
            return this.masterKeyState;
        }

        public int getDTSequenceNumber() {
            return this.dtSequenceNumber;
        }
    }

    public static class ApplicationState {
        final ApplicationSubmissionContext context;
        final long submitTime;
        final long startTime;
        final String user;
        Map<ApplicationAttemptId, ApplicationAttemptState> attempts = new HashMap<ApplicationAttemptId, ApplicationAttemptState>();
        RMAppState state;
        String diagnostics;
        long finishTime;

        public ApplicationState(long submitTime, long startTime, ApplicationSubmissionContext context, String user) {
            this(submitTime, startTime, context, user, null, "", 0L);
        }

        public ApplicationState(long submitTime, long startTime, ApplicationSubmissionContext context, String user, RMAppState state, String diagnostics, long finishTime) {
            this.submitTime = submitTime;
            this.startTime = startTime;
            this.context = context;
            this.user = user;
            this.state = state;
            this.diagnostics = diagnostics == null ? "" : diagnostics;
            this.finishTime = finishTime;
        }

        public ApplicationId getAppId() {
            return this.context.getApplicationId();
        }

        public long getSubmitTime() {
            return this.submitTime;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public int getAttemptCount() {
            return this.attempts.size();
        }

        public ApplicationSubmissionContext getApplicationSubmissionContext() {
            return this.context;
        }

        public ApplicationAttemptState getAttempt(ApplicationAttemptId attemptId) {
            return this.attempts.get(attemptId);
        }

        public String getUser() {
            return this.user;
        }

        public RMAppState getState() {
            return this.state;
        }

        public String getDiagnostics() {
            return this.diagnostics;
        }

        public long getFinishTime() {
            return this.finishTime;
        }
    }

    public static class ApplicationAttemptState {
        final ApplicationAttemptId attemptId;
        final Container masterContainer;
        final Credentials appAttemptCredentials;
        long startTime = 0L;
        RMAppAttemptState state;
        String finalTrackingUrl = "N/A";
        String diagnostics;
        FinalApplicationStatus amUnregisteredFinalStatus;

        public ApplicationAttemptState(ApplicationAttemptId attemptId, Container masterContainer, Credentials appAttemptCredentials, long startTime) {
            this(attemptId, masterContainer, appAttemptCredentials, startTime, null, null, "", null);
        }

        public ApplicationAttemptState(ApplicationAttemptId attemptId, Container masterContainer, Credentials appAttemptCredentials, long startTime, RMAppAttemptState state, String finalTrackingUrl, String diagnostics, FinalApplicationStatus amUnregisteredFinalStatus) {
            this.attemptId = attemptId;
            this.masterContainer = masterContainer;
            this.appAttemptCredentials = appAttemptCredentials;
            this.startTime = startTime;
            this.state = state;
            this.finalTrackingUrl = finalTrackingUrl;
            this.diagnostics = diagnostics == null ? "" : diagnostics;
            this.amUnregisteredFinalStatus = amUnregisteredFinalStatus;
        }

        public Container getMasterContainer() {
            return this.masterContainer;
        }

        public ApplicationAttemptId getAttemptId() {
            return this.attemptId;
        }

        public Credentials getAppAttemptCredentials() {
            return this.appAttemptCredentials;
        }

        public RMAppAttemptState getState() {
            return this.state;
        }

        public String getFinalTrackingUrl() {
            return this.finalTrackingUrl;
        }

        public String getDiagnostics() {
            return this.diagnostics;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public FinalApplicationStatus getFinalApplicationStatus() {
            return this.amUnregisteredFinalStatus;
        }
    }
}

