/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class RMStateVersion {
    public static RMStateVersion newInstance(int majorVersion, int minorVersion) {
        RMStateVersion version = Records.newRecord(RMStateVersion.class);
        version.setMajorVersion(majorVersion);
        version.setMinorVersion(minorVersion);
        return version;
    }

    public abstract int getMajorVersion();

    public abstract void setMajorVersion(int var1);

    public abstract int getMinorVersion();

    public abstract void setMinorVersion(int var1);

    public String toString() {
        return this.getMajorVersion() + "." + this.getMinorVersion();
    }

    public boolean isCompatibleTo(RMStateVersion version) {
        return this.getMajorVersion() == version.getMajorVersion();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getMajorVersion();
        result = 31 * result + this.getMinorVersion();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RMStateVersion other = (RMStateVersion)obj;
        return this.getMajorVersion() == other.getMajorVersion() && this.getMinorVersion() == other.getMinorVersion();
    }
}

