/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSSchedulerApp
extends SchedulerApplicationAttempt {
    private static final Log LOG = LogFactory.getLog(FSSchedulerApp.class);
    private AppSchedulable appSchedulable;
    final Map<RMContainer, Long> preemptionMap = new HashMap<RMContainer, Long>();
    final Map<Priority, NodeType> allowedLocalityLevel = new HashMap<Priority, NodeType>();

    public FSSchedulerApp(ApplicationAttemptId applicationAttemptId, String user, FSLeafQueue queue, ActiveUsersManager activeUsersManager, RMContext rmContext) {
        super(applicationAttemptId, user, queue, activeUsersManager, rmContext);
    }

    public void setAppSchedulable(AppSchedulable appSchedulable) {
        this.appSchedulable = appSchedulable;
    }

    public AppSchedulable getAppSchedulable() {
        return this.appSchedulable;
    }

    public synchronized void containerCompleted(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        Container container = rmContainer.getContainer();
        ContainerId containerId = container.getId();
        rmContainer.handle(new RMContainerFinishedEvent(containerId, containerStatus, event));
        LOG.info((Object)("Completed container: " + rmContainer.getContainerId() + " in state: " + (Object)((Object)rmContainer.getState()) + " event:" + (Object)((Object)event)));
        this.liveContainers.remove(rmContainer.getContainerId());
        RMAuditLogger.logSuccess(this.getUser(), "AM Released Container", "SchedulerApp", this.getApplicationId(), containerId);
        Resource containerResource = rmContainer.getContainer().getResource();
        this.queue.getMetrics().releaseResources(this.getUser(), 1, containerResource);
        Resources.subtractFrom(this.currentConsumption, containerResource);
        this.preemptionMap.remove(rmContainer);
    }

    public synchronized void unreserve(FSSchedulerNode node, Priority priority) {
        Map reservedContainers = (Map)this.reservedContainers.get(priority);
        RMContainer reservedContainer = (RMContainer)reservedContainers.remove(node.getNodeID());
        if (reservedContainers.isEmpty()) {
            this.reservedContainers.remove(priority);
        }
        this.resetReReservations(priority);
        Resource resource = reservedContainer.getContainer().getResource();
        Resources.subtractFrom(this.currentReservation, resource);
        LOG.info((Object)("Application " + this.getApplicationId() + " unreserved " + " on node " + node + ", currently has " + reservedContainers.size() + " at priority " + priority + "; currentReservation " + this.currentReservation));
    }

    public synchronized float getLocalityWaitFactor(Priority priority, int clusterNodes) {
        int requiredResources = Math.max(this.getResourceRequests(priority).size() - 1, 0);
        return Math.min((float)requiredResources / (float)clusterNodes, 1.0f);
    }

    public synchronized NodeType getAllowedLocalityLevel(Priority priority, int numNodes, double nodeLocalityThreshold, double rackLocalityThreshold) {
        double threshold;
        if (nodeLocalityThreshold > 1.0) {
            nodeLocalityThreshold = 1.0;
        }
        if (rackLocalityThreshold > 1.0) {
            rackLocalityThreshold = 1.0;
        }
        if (nodeLocalityThreshold < 0.0 || rackLocalityThreshold < 0.0) {
            return NodeType.OFF_SWITCH;
        }
        if (!this.allowedLocalityLevel.containsKey(priority)) {
            this.allowedLocalityLevel.put(priority, NodeType.NODE_LOCAL);
            return NodeType.NODE_LOCAL;
        }
        NodeType allowed = this.allowedLocalityLevel.get(priority);
        if (allowed.equals((Object)NodeType.OFF_SWITCH)) {
            return NodeType.OFF_SWITCH;
        }
        double d = threshold = allowed.equals((Object)NodeType.NODE_LOCAL) ? nodeLocalityThreshold : rackLocalityThreshold;
        if ((double)this.getSchedulingOpportunities(priority) > (double)numNodes * threshold) {
            if (allowed.equals((Object)NodeType.NODE_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.RACK_LOCAL);
                this.resetSchedulingOpportunities(priority);
            } else if (allowed.equals((Object)NodeType.RACK_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.OFF_SWITCH);
                this.resetSchedulingOpportunities(priority);
            }
        }
        return this.allowedLocalityLevel.get(priority);
    }

    public synchronized NodeType getAllowedLocalityLevelByTime(Priority priority, long nodeLocalityDelayMs, long rackLocalityDelayMs, long currentTimeMs) {
        long thresholdTime;
        if (nodeLocalityDelayMs < 0L || rackLocalityDelayMs < 0L) {
            return NodeType.OFF_SWITCH;
        }
        if (!this.allowedLocalityLevel.containsKey(priority)) {
            this.allowedLocalityLevel.put(priority, NodeType.NODE_LOCAL);
            return NodeType.NODE_LOCAL;
        }
        NodeType allowed = this.allowedLocalityLevel.get(priority);
        if (allowed.equals((Object)NodeType.OFF_SWITCH)) {
            return NodeType.OFF_SWITCH;
        }
        long waitTime = currentTimeMs;
        waitTime = this.lastScheduledContainer.containsKey(priority) ? (waitTime -= ((Long)this.lastScheduledContainer.get(priority)).longValue()) : (waitTime -= this.appSchedulable.getStartTime());
        long l = thresholdTime = allowed.equals((Object)NodeType.NODE_LOCAL) ? nodeLocalityDelayMs : rackLocalityDelayMs;
        if (waitTime > thresholdTime) {
            if (allowed.equals((Object)NodeType.NODE_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.RACK_LOCAL);
                this.resetSchedulingOpportunities(priority, currentTimeMs);
            } else if (allowed.equals((Object)NodeType.RACK_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.OFF_SWITCH);
                this.resetSchedulingOpportunities(priority, currentTimeMs);
            }
        }
        return this.allowedLocalityLevel.get(priority);
    }

    public synchronized RMContainer allocate(NodeType type, FSSchedulerNode node, Priority priority, ResourceRequest request, Container container) {
        NodeType allowed = this.allowedLocalityLevel.get(priority);
        if (allowed != null) {
            if (allowed.equals((Object)NodeType.OFF_SWITCH) && (type.equals((Object)NodeType.NODE_LOCAL) || type.equals((Object)NodeType.RACK_LOCAL))) {
                this.resetAllowedLocalityLevel(priority, type);
            } else if (allowed.equals((Object)NodeType.RACK_LOCAL) && type.equals((Object)NodeType.NODE_LOCAL)) {
                this.resetAllowedLocalityLevel(priority, type);
            }
        }
        if (this.getTotalRequiredResources(priority) <= 0) {
            return null;
        }
        RMContainerImpl rmContainer = new RMContainerImpl(container, this.getApplicationAttemptId(), node.getNodeID(), this.appSchedulingInfo.getUser(), this.rmContext);
        this.newlyAllocatedContainers.add(rmContainer);
        this.liveContainers.put(container.getId(), rmContainer);
        this.appSchedulingInfo.allocate(type, node, priority, request, container);
        Resources.addTo(this.currentConsumption, container.getResource());
        rmContainer.handle(new RMContainerEvent(container.getId(), RMContainerEventType.START));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("allocate: applicationAttemptId=" + container.getId().getApplicationAttemptId() + " container=" + container.getId() + " host=" + container.getNodeId().getHost() + " type=" + (Object)((Object)type)));
        }
        RMAuditLogger.logSuccess(this.getUser(), "AM Allocated Container", "SchedulerApp", this.getApplicationId(), container.getId());
        return rmContainer;
    }

    public synchronized void resetAllowedLocalityLevel(Priority priority, NodeType level) {
        NodeType old = this.allowedLocalityLevel.get(priority);
        LOG.info((Object)("Raising locality level from " + (Object)((Object)old) + " to " + (Object)((Object)level) + " at " + " priority " + priority));
        this.allowedLocalityLevel.put(priority, level);
    }

    public void addPreemption(RMContainer container, long time) {
        assert (this.preemptionMap.get(container) == null);
        this.preemptionMap.put(container, time);
    }

    public Long getContainerPreemptionTime(RMContainer container) {
        return this.preemptionMap.get(container);
    }

    public Set<RMContainer> getPreemptionContainers() {
        return this.preemptionMap.keySet();
    }

    @Override
    public FSLeafQueue getQueue() {
        return (FSLeafQueue)super.getQueue();
    }
}

