/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class Schedulable {
    private Resource fairShare = Resources.createResource(0);

    public abstract String getName();

    public abstract Resource getDemand();

    public abstract Resource getResourceUsage();

    public abstract Resource getMinShare();

    public abstract Resource getMaxShare();

    public abstract ResourceWeights getWeights();

    public abstract long getStartTime();

    public abstract Priority getPriority();

    public abstract void updateDemand();

    public abstract Resource assignContainer(FSSchedulerNode var1);

    public void setFairShare(Resource fairShare) {
        this.fairShare = fairShare;
    }

    public Resource getFairShare() {
        return this.fairShare;
    }

    public String toString() {
        return String.format("[%s, demand=%s, running=%s, share=%s, w=%s]", this.getName(), this.getDemand(), this.getResourceUsage(), this.fairShare, this.getWeights());
    }
}

