/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterInfo;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class AboutBlock
extends HtmlBlock {
    final ResourceManager rm;

    @Inject
    AboutBlock(ResourceManager rm, View.ViewContext ctx) {
        super(ctx);
        this.rm = rm;
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        html._(MetricsOverviewTable.class);
        ResourceManager rm = this.getInstance(ResourceManager.class);
        ClusterInfo cinfo = new ClusterInfo(rm);
        this.info("Cluster overview")._("Cluster ID:", cinfo.getClusterId())._("ResourceManager state:", cinfo.getState())._("ResourceManager HA state:", cinfo.getHAState())._("ResourceManager started on:", Times.format(cinfo.getStartedOn()))._("ResourceManager version:", cinfo.getRMBuildVersion() + " on " + cinfo.getRMVersionBuiltOn())._("Hadoop version:", cinfo.getHadoopBuildVersion() + " on " + cinfo.getHadoopVersionBuiltOn());
        html._(InfoBlock.class);
    }
}

