/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class AppBlock
extends HtmlBlock {
    private ApplicationACLsManager aclsManager;
    private QueueACLsManager queueACLsManager;
    private final Configuration conf;

    @Inject
    AppBlock(ResourceManager rm, View.ViewContext ctx, ApplicationACLsManager aclsManager, QueueACLsManager queueACLsManager, Configuration conf) {
        super(ctx);
        this.aclsManager = aclsManager;
        this.queueACLsManager = queueACLsManager;
        this.conf = conf;
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        String aid = this.$("app.id");
        if (aid.isEmpty()) {
            this.puts("Bad request: requires application ID");
            return;
        }
        ApplicationId appID = null;
        try {
            appID = Apps.toAppID(aid);
        }
        catch (Exception e) {
            this.puts("Invalid Application ID: " + aid);
            return;
        }
        RMContext context = this.getInstance(RMContext.class);
        RMApp rmApp = (RMApp)context.getRMApps().get(appID);
        if (rmApp == null) {
            this.puts("Application not found: " + aid);
            return;
        }
        AppInfo app = new AppInfo(rmApp, true, WebAppUtils.getHttpSchemePrefix(this.conf));
        String remoteUser = this.request().getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser(remoteUser);
        }
        if (callerUGI != null && !this.aclsManager.checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, app.getUser(), appID) && !this.queueACLsManager.checkAccess(callerUGI, QueueACL.ADMINISTER_QUEUE, app.getQueue())) {
            this.puts("You (User " + remoteUser + ") are not authorized to view application " + appID);
            return;
        }
        this.setTitle(StringHelper.join("Application ", aid));
        this.info("Application Overview")._("User:", app.getUser())._("Name:", app.getName())._("Application Type:", app.getApplicationType())._("Application Tags:", app.getApplicationTags())._("State:", app.getState())._("FinalStatus:", app.getFinalStatus())._("Started:", Times.format(app.getStartTime()))._("Elapsed:", StringUtils.formatTime(Times.elapsed(app.getStartTime(), app.getFinishTime())))._("Tracking URL:", !app.isTrackingUrlReady() ? "#" : app.getTrackingUrlPretty(), app.getTrackingUI())._("Diagnostics:", app.getNote());
        Collection<RMAppAttempt> attempts = rmApp.getAppAttempts().values();
        String amString = attempts.size() == 1 ? "ApplicationMaster" : "ApplicationMasters";
        HamletSpec.DIV div = ((Hamlet)html._(InfoBlock.class)).div(".info-wrap.ui-widget-content.ui-corner-bottom");
        HamletSpec.TABLE table = ((Hamlet.DIV)div).table("#app");
        ((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TABLE)table).tr()).th(amString)))._()).tr()).th(".ui-state-default", "Attempt Number")).th(".ui-state-default", "Start Time")).th(".ui-state-default", "Node")).th(".ui-state-default", "Logs")))._();
        boolean odd = false;
        for (RMAppAttempt attempt : attempts) {
            AppAttemptInfo attemptInfo = new AppAttemptInfo(attempt, app.getUser());
            odd = !odd;
            ((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((HamletImpl.EImp)((Object)((Hamlet.TD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)table).tr(odd ? ".odd" : ".even")).td(String.valueOf(attemptInfo.getAttemptId()))).td(Times.format(attemptInfo.getStartTime()))).td()).a(".nodelink", this.url("//", attemptInfo.getNodeHttpAddress()), attemptInfo.getNodeHttpAddress())))._()).td()).a(".logslink", this.url(attemptInfo.getLogsLink()), "logs")))._())._();
        }
        ((HamletImpl.EImp)((Object)table))._();
        ((HamletImpl.EImp)((Object)div))._();
    }
}

