/*
 * Decompiled with CFR 0.152.
 */
package testjar;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;

public class ExternalWritable
implements WritableComparable {
    private String message = null;

    public ExternalWritable() {
    }

    public ExternalWritable(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.message = null;
        boolean hasMessage = in.readBoolean();
        if (hasMessage) {
            this.message = in.readUTF();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        boolean hasMessage = this.message != null && this.message.length() > 0;
        out.writeBoolean(hasMessage);
        if (hasMessage) {
            out.writeUTF(this.message);
        }
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof ExternalWritable)) {
            throw new IllegalArgumentException("Input not an ExternalWritable");
        }
        ExternalWritable that = (ExternalWritable)o;
        return this.message.compareTo(that.message);
    }

    public String toString() {
        return this.message;
    }
}

