/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.org.codehaus.jackson.xc;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.JsonGenerator;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.JsonNode;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.map.BeanProperty;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.map.JsonMappingException;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.map.JsonSerializer;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.map.SerializerProvider;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.map.ser.SerializerBase;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.schema.JsonSchema;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.schema.SchemaAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlAdapterJsonSerializer
extends SerializerBase<Object>
implements SchemaAware {
    private final XmlAdapter<Object, Object> xmlAdapter;
    private final BeanProperty _property;

    public XmlAdapterJsonSerializer(XmlAdapter<Object, Object> xmlAdapter, BeanProperty property) {
        super(Object.class);
        this.xmlAdapter = xmlAdapter;
        this._property = property;
    }

    @Override
    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        Object adapted;
        try {
            adapted = this.xmlAdapter.marshal(value);
        }
        catch (Exception e) {
            throw new JsonMappingException("Unable to marshal: " + e.getMessage(), e);
        }
        if (adapted == null) {
            provider.getNullValueSerializer().serialize(null, jgen, provider);
        } else {
            Class<?> c = adapted.getClass();
            provider.findTypedValueSerializer(c, true, this._property).serialize(adapted, jgen, provider);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        JsonSerializer<Object> ser = provider.findValueSerializer(this.findValueClass(), this._property);
        JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
        return schemaNode;
    }

    private Class<?> findValueClass() {
        Type superClass = this.xmlAdapter.getClass().getGenericSuperclass();
        while (superClass instanceof ParameterizedType && XmlAdapter.class != ((ParameterizedType)superClass).getRawType()) {
            superClass = ((Class)((ParameterizedType)superClass).getRawType()).getGenericSuperclass();
        }
        return (Class)((ParameterizedType)superClass).getActualTypeArguments()[0];
    }
}

