/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.org.jboss.netty.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.flink.hadoop.shaded.org.jboss.netty.logging.InternalLogger;
import org.apache.flink.hadoop.shaded.org.jboss.netty.logging.InternalLoggerFactory;
import org.apache.flink.hadoop.shaded.org.jboss.netty.util.MapBackedSet;
import org.apache.flink.hadoop.shaded.org.jboss.netty.util.ThreadRenamingRunnable;
import org.apache.flink.hadoop.shaded.org.jboss.netty.util.Timeout;
import org.apache.flink.hadoop.shaded.org.jboss.netty.util.Timer;
import org.apache.flink.hadoop.shaded.org.jboss.netty.util.TimerTask;
import org.apache.flink.hadoop.shaded.org.jboss.netty.util.internal.ConcurrentIdentityHashMap;
import org.apache.flink.hadoop.shaded.org.jboss.netty.util.internal.DetectionUtil;
import org.apache.flink.hadoop.shaded.org.jboss.netty.util.internal.ReusableIterator;
import org.apache.flink.hadoop.shaded.org.jboss.netty.util.internal.SharedResourceMisuseDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashedWheelTimer
implements Timer {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(HashedWheelTimer.class);
    private static final AtomicInteger id = new AtomicInteger();
    private static final SharedResourceMisuseDetector misuseDetector = new SharedResourceMisuseDetector(HashedWheelTimer.class);
    private final Worker worker = new Worker();
    final Thread workerThread;
    final AtomicInteger workerState = new AtomicInteger();
    private final long roundDuration;
    final long tickDuration;
    final Set<HashedWheelTimeout>[] wheel;
    final ReusableIterator<HashedWheelTimeout>[] iterators;
    final int mask;
    final ReadWriteLock lock = new ReentrantReadWriteLock();
    volatile int wheelCursor;

    public HashedWheelTimer() {
        this(Executors.defaultThreadFactory());
    }

    public HashedWheelTimer(long tickDuration, TimeUnit unit) {
        this(Executors.defaultThreadFactory(), tickDuration, unit);
    }

    public HashedWheelTimer(long tickDuration, TimeUnit unit, int ticksPerWheel) {
        this(Executors.defaultThreadFactory(), tickDuration, unit, ticksPerWheel);
    }

    public HashedWheelTimer(ThreadFactory threadFactory) {
        this(threadFactory, 100L, TimeUnit.MILLISECONDS);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit) {
        this(threadFactory, tickDuration, unit, 512);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel) {
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (tickDuration <= 0L) {
            throw new IllegalArgumentException("tickDuration must be greater than 0: " + tickDuration);
        }
        if (ticksPerWheel <= 0) {
            throw new IllegalArgumentException("ticksPerWheel must be greater than 0: " + ticksPerWheel);
        }
        this.wheel = HashedWheelTimer.createWheel(ticksPerWheel);
        this.iterators = HashedWheelTimer.createIterators(this.wheel);
        this.mask = this.wheel.length - 1;
        this.tickDuration = tickDuration = unit.toMillis(tickDuration);
        if (tickDuration == Long.MAX_VALUE || tickDuration >= Long.MAX_VALUE / (long)this.wheel.length) {
            throw new IllegalArgumentException("tickDuration is too long: " + tickDuration + ' ' + (Object)((Object)unit));
        }
        this.roundDuration = tickDuration * (long)this.wheel.length;
        this.workerThread = threadFactory.newThread(new ThreadRenamingRunnable(this.worker, "Hashed wheel timer #" + id.incrementAndGet()));
        misuseDetector.increase();
    }

    private static Set<HashedWheelTimeout>[] createWheel(int ticksPerWheel) {
        if (ticksPerWheel <= 0) {
            throw new IllegalArgumentException("ticksPerWheel must be greater than 0: " + ticksPerWheel);
        }
        if (ticksPerWheel > 0x40000000) {
            throw new IllegalArgumentException("ticksPerWheel may not be greater than 2^30: " + ticksPerWheel);
        }
        ticksPerWheel = HashedWheelTimer.normalizeTicksPerWheel(ticksPerWheel);
        Set[] wheel = new Set[ticksPerWheel];
        for (int i = 0; i < wheel.length; ++i) {
            wheel[i] = new MapBackedSet(new ConcurrentIdentityHashMap(16, 0.95f, 4));
        }
        return wheel;
    }

    private static ReusableIterator<HashedWheelTimeout>[] createIterators(Set<HashedWheelTimeout>[] wheel) {
        ReusableIterator[] iterators = new ReusableIterator[wheel.length];
        for (int i = 0; i < wheel.length; ++i) {
            iterators[i] = (ReusableIterator)wheel[i].iterator();
        }
        return iterators;
    }

    private static int normalizeTicksPerWheel(int ticksPerWheel) {
        int normalizedTicksPerWheel;
        for (normalizedTicksPerWheel = 1; normalizedTicksPerWheel < ticksPerWheel; normalizedTicksPerWheel <<= 1) {
        }
        return normalizedTicksPerWheel;
    }

    public void start() {
        switch (this.workerState.get()) {
            case 0: {
                if (!this.workerState.compareAndSet(0, 1)) break;
                this.workerThread.start();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                throw new IllegalStateException("cannot be started once stopped");
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    public Set<Timeout> stop() {
        if (Thread.currentThread() == this.workerThread) {
            throw new IllegalStateException(HashedWheelTimer.class.getSimpleName() + ".stop() cannot be called from " + TimerTask.class.getSimpleName());
        }
        if (this.workerState.getAndSet(2) != 1) {
            return Collections.emptySet();
        }
        boolean interrupted = false;
        while (this.workerThread.isAlive()) {
            this.workerThread.interrupt();
            try {
                this.workerThread.join(100L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        misuseDetector.decrease();
        HashSet<HashedWheelTimeout> unprocessedTimeouts = new HashSet<HashedWheelTimeout>();
        for (Set<HashedWheelTimeout> bucket : this.wheel) {
            unprocessedTimeouts.addAll(bucket);
            bucket.clear();
        }
        return Collections.unmodifiableSet(unprocessedTimeouts);
    }

    @Override
    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        long currentTime = System.currentTimeMillis();
        if (task == null) {
            throw new NullPointerException("task");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.start();
        delay = unit.toMillis(delay);
        HashedWheelTimeout timeout = new HashedWheelTimeout(task, currentTime + delay);
        this.scheduleTimeout(timeout, delay);
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleTimeout(HashedWheelTimeout timeout, long delay) {
        if (delay < this.tickDuration) {
            delay = this.tickDuration;
        }
        long lastRoundDelay = delay % this.roundDuration;
        long lastTickDelay = delay % this.tickDuration;
        long relativeIndex = lastRoundDelay / this.tickDuration + (long)(lastTickDelay != 0L ? 1 : 0);
        long remainingRounds = delay / this.roundDuration - (long)(delay % this.roundDuration == 0L ? 1 : 0);
        this.lock.readLock().lock();
        try {
            int stopIndex;
            timeout.stopIndex = stopIndex = (int)((long)this.wheelCursor + relativeIndex & (long)this.mask);
            timeout.remainingRounds = remainingRounds;
            this.wheel[stopIndex].add(timeout);
            Object var14_8 = null;
            this.lock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var14_9 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
    }

    private final class HashedWheelTimeout
    implements Timeout {
        private static final int ST_INIT = 0;
        private static final int ST_CANCELLED = 1;
        private static final int ST_EXPIRED = 2;
        private final TimerTask task;
        final long deadline;
        volatile int stopIndex;
        volatile long remainingRounds;
        private final AtomicInteger state = new AtomicInteger(0);

        HashedWheelTimeout(TimerTask task, long deadline) {
            this.task = task;
            this.deadline = deadline;
        }

        public Timer getTimer() {
            return HashedWheelTimer.this;
        }

        public TimerTask getTask() {
            return this.task;
        }

        public void cancel() {
            if (!this.state.compareAndSet(0, 1)) {
                return;
            }
            HashedWheelTimer.this.wheel[this.stopIndex].remove(this);
        }

        public boolean isCancelled() {
            return this.state.get() == 1;
        }

        public boolean isExpired() {
            return this.state.get() != 0;
        }

        public void expire() {
            block3: {
                if (!this.state.compareAndSet(0, 2)) {
                    return;
                }
                try {
                    this.task.run(this);
                }
                catch (Throwable t) {
                    if (!logger.isWarnEnabled()) break block3;
                    logger.warn("An exception was thrown by " + TimerTask.class.getSimpleName() + '.', t);
                }
            }
        }

        public String toString() {
            long currentTime = System.currentTimeMillis();
            long remaining = this.deadline - currentTime;
            StringBuilder buf = new StringBuilder(192);
            buf.append(this.getClass().getSimpleName());
            buf.append('(');
            buf.append("deadline: ");
            if (remaining > 0L) {
                buf.append(remaining);
                buf.append(" ms later, ");
            } else if (remaining < 0L) {
                buf.append(-remaining);
                buf.append(" ms ago, ");
            } else {
                buf.append("now, ");
            }
            if (this.isCancelled()) {
                buf.append(", cancelled");
            }
            return buf.append(')').toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Worker
    implements Runnable {
        private long startTime;
        private long tick;

        Worker() {
        }

        @Override
        public void run() {
            ArrayList<HashedWheelTimeout> expiredTimeouts = new ArrayList<HashedWheelTimeout>();
            this.startTime = System.currentTimeMillis();
            this.tick = 1L;
            while (HashedWheelTimer.this.workerState.get() == 1) {
                long deadline = this.waitForNextTick();
                if (deadline <= 0L) continue;
                this.fetchExpiredTimeouts(expiredTimeouts, deadline);
                this.notifyExpiredTimeouts(expiredTimeouts);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fetchExpiredTimeouts(List<HashedWheelTimeout> expiredTimeouts, long deadline) {
            HashedWheelTimer.this.lock.writeLock().lock();
            try {
                int newWheelCursor = HashedWheelTimer.this.wheelCursor = HashedWheelTimer.this.wheelCursor + 1 & HashedWheelTimer.this.mask;
                ReusableIterator<HashedWheelTimeout> i = HashedWheelTimer.this.iterators[newWheelCursor];
                this.fetchExpiredTimeouts(expiredTimeouts, i, deadline);
                Object var7_5 = null;
                HashedWheelTimer.this.lock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                HashedWheelTimer.this.lock.writeLock().unlock();
                throw throwable;
            }
        }

        private void fetchExpiredTimeouts(List<HashedWheelTimeout> expiredTimeouts, ReusableIterator<HashedWheelTimeout> i, long deadline) {
            ArrayList<HashedWheelTimeout> slipped = null;
            i.rewind();
            while (i.hasNext()) {
                HashedWheelTimeout timeout = (HashedWheelTimeout)i.next();
                if (timeout.remainingRounds <= 0L) {
                    i.remove();
                    if (timeout.deadline <= deadline) {
                        expiredTimeouts.add(timeout);
                        continue;
                    }
                    if (slipped == null) {
                        slipped = new ArrayList<HashedWheelTimeout>();
                    }
                    slipped.add(timeout);
                    continue;
                }
                --timeout.remainingRounds;
            }
            if (slipped != null) {
                for (HashedWheelTimeout timeout : slipped) {
                    HashedWheelTimer.this.scheduleTimeout(timeout, timeout.deadline - deadline);
                }
            }
        }

        private void notifyExpiredTimeouts(List<HashedWheelTimeout> expiredTimeouts) {
            for (int i = expiredTimeouts.size() - 1; i >= 0; --i) {
                expiredTimeouts.get(i).expire();
            }
            expiredTimeouts.clear();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        private long waitForNextTick() {
            long deadline = this.startTime + HashedWheelTimer.this.tickDuration * this.tick;
            while (true) {
                long currentTime = System.currentTimeMillis();
                long sleepTime = HashedWheelTimer.this.tickDuration * this.tick - (currentTime - this.startTime);
                if (DetectionUtil.isWindows()) {
                    sleepTime = sleepTime / 10L * 10L;
                }
                if (sleepTime <= 0L) {
                    ++this.tick;
                    return deadline;
                }
                try {
                    Thread.sleep(sleepTime);
                    continue;
                }
                catch (InterruptedException e) {
                    if (HashedWheelTimer.this.workerState.get() != 1) return -1L;
                    continue;
                }
                break;
            }
        }
    }
}

