/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.cli;

import org.apache.hadoop.cli.CLITestHelperDFS;
import org.apache.hadoop.cli.util.CLICommand;
import org.apache.hadoop.cli.util.CommandExecutor;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestAclCLI
extends CLITestHelperDFS {
    private MiniDFSCluster cluster = null;
    private FileSystem fs = null;
    private String namenode = null;
    private String username = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conf.setBoolean("dfs.namenode.acls.enabled", true);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.fs = this.cluster.getFileSystem();
        this.namenode = this.conf.get("fs.defaultFS", "file:///");
        this.username = System.getProperty("user.name");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.fs != null) {
            this.fs.close();
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Override
    protected String getTestFile() {
        return "testAclCLI.xml";
    }

    @Override
    protected String expandCommand(String cmd) {
        String expCmd = cmd;
        expCmd = expCmd.replaceAll("NAMENODE", this.namenode);
        expCmd = expCmd.replaceAll("USERNAME", this.username);
        expCmd = expCmd.replaceAll("#LF#", System.getProperty("line.separator"));
        expCmd = super.expandCommand(expCmd);
        return expCmd;
    }

    @Override
    protected CommandExecutor.Result execute(CLICommand cmd) throws Exception {
        return cmd.getExecutor(this.namenode).executeCommand(cmd.getCmd());
    }

    @Override
    @Test
    public void testAll() {
        super.testAll();
    }
}

