/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mortbay.log.Log;

public abstract class FSMainOperationsBaseTest
extends FileSystemTestHelper {
    private static String TEST_DIR_AAA2 = "test/hadoop2/aaa";
    private static String TEST_DIR_AAA = "test/hadoop/aaa";
    private static String TEST_DIR_AXA = "test/hadoop/axa";
    private static String TEST_DIR_AXX = "test/hadoop/axx";
    private static int numBlocks = 2;
    protected FileSystem fSys;
    private static final PathFilter DEFAULT_FILTER = new PathFilter(){

        @Override
        public boolean accept(Path file) {
            return true;
        }
    };
    private static final PathFilter TEST_X_FILTER = new PathFilter(){

        @Override
        public boolean accept(Path file) {
            return file.getName().contains("x") || file.getName().contains("X");
        }
    };
    protected static final byte[] data = FSMainOperationsBaseTest.getFileData(numBlocks, FSMainOperationsBaseTest.getDefaultBlockSize());

    protected abstract FileSystem createFileSystem() throws Exception;

    public FSMainOperationsBaseTest() {
    }

    public FSMainOperationsBaseTest(String testRootDir) {
        super(testRootDir);
    }

    @Before
    public void setUp() throws Exception {
        this.fSys = this.createFileSystem();
        this.fSys.mkdirs(this.getTestRootPath(this.fSys, "test"));
    }

    @After
    public void tearDown() throws Exception {
        this.fSys.delete(new Path(this.getAbsoluteTestRootPath(this.fSys), new Path("test")), true);
    }

    protected Path getDefaultWorkingDirectory() throws IOException {
        return this.getTestRootPath(this.fSys, "/user/" + System.getProperty("user.name")).makeQualified(this.fSys.getUri(), this.fSys.getWorkingDirectory());
    }

    protected boolean renameSupported() {
        return true;
    }

    protected IOException unwrapException(IOException e) {
        return e;
    }

    @Test
    public void testFsStatus() throws Exception {
        FsStatus fsStatus = this.fSys.getStatus(null);
        Assert.assertNotNull((Object)fsStatus);
        Assert.assertTrue((fsStatus.getUsed() >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((fsStatus.getRemaining() >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((fsStatus.getCapacity() >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testWorkingDirectory() throws Exception {
        Path workDir = new Path(this.getAbsoluteTestRootPath(this.fSys), new Path("test"));
        this.fSys.setWorkingDirectory(workDir);
        Assert.assertEquals((Object)workDir, (Object)this.fSys.getWorkingDirectory());
        this.fSys.setWorkingDirectory(new Path("."));
        Assert.assertEquals((Object)workDir, (Object)this.fSys.getWorkingDirectory());
        this.fSys.setWorkingDirectory(new Path(".."));
        Assert.assertEquals((Object)workDir.getParent(), (Object)this.fSys.getWorkingDirectory());
        workDir = new Path(this.getAbsoluteTestRootPath(this.fSys), new Path("test"));
        this.fSys.setWorkingDirectory(workDir);
        Assert.assertEquals((Object)workDir, (Object)this.fSys.getWorkingDirectory());
        Path relativeDir = new Path("existingDir1");
        Path absoluteDir = new Path(workDir, "existingDir1");
        this.fSys.mkdirs(absoluteDir);
        this.fSys.setWorkingDirectory(relativeDir);
        Assert.assertEquals((Object)absoluteDir, (Object)this.fSys.getWorkingDirectory());
        absoluteDir = this.getTestRootPath(this.fSys, "test/existingDir2");
        this.fSys.mkdirs(absoluteDir);
        this.fSys.setWorkingDirectory(absoluteDir);
        Assert.assertEquals((Object)absoluteDir, (Object)this.fSys.getWorkingDirectory());
        Path absolutePath = new Path(absoluteDir, "foo");
        FSMainOperationsBaseTest.createFile(this.fSys, absolutePath);
        this.fSys.open(new Path("foo")).close();
        this.fSys.mkdirs(new Path("newDir"));
        Assert.assertTrue((boolean)FSMainOperationsBaseTest.isDir(this.fSys, new Path(absoluteDir, "newDir")));
    }

    @Test
    public void testWDAbsolute() throws IOException {
        Path absoluteDir = new Path(this.fSys.getUri() + "/test/existingDir");
        this.fSys.mkdirs(absoluteDir);
        this.fSys.setWorkingDirectory(absoluteDir);
        Assert.assertEquals((Object)absoluteDir, (Object)this.fSys.getWorkingDirectory());
    }

    @Test
    public void testMkdirs() throws Exception {
        Path testDir = this.getTestRootPath(this.fSys, "test/hadoop");
        Assert.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, testDir));
        Assert.assertFalse((boolean)FSMainOperationsBaseTest.isFile(this.fSys, testDir));
        this.fSys.mkdirs(testDir);
        Assert.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, testDir));
        Assert.assertFalse((boolean)FSMainOperationsBaseTest.isFile(this.fSys, testDir));
        this.fSys.mkdirs(testDir);
        Assert.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, testDir));
        Assert.assertFalse((boolean)FSMainOperationsBaseTest.isFile(this.fSys, testDir));
        Path parentDir = testDir.getParent();
        Assert.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, parentDir));
        Assert.assertFalse((boolean)FSMainOperationsBaseTest.isFile(this.fSys, parentDir));
        Path grandparentDir = parentDir.getParent();
        Assert.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, grandparentDir));
        Assert.assertFalse((boolean)FSMainOperationsBaseTest.isFile(this.fSys, grandparentDir));
    }

    @Test
    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = this.getTestRootPath(this.fSys, "test/hadoop");
        Assert.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, testDir));
        this.fSys.mkdirs(testDir);
        Assert.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, testDir));
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/file"));
        Path testSubDir = this.getTestRootPath(this.fSys, "test/hadoop/file/subdir");
        try {
            this.fSys.mkdirs(testSubDir);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, testSubDir));
        Path testDeepSubDir = this.getTestRootPath(this.fSys, "test/hadoop/file/deep/sub/dir");
        try {
            this.fSys.mkdirs(testDeepSubDir);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, testDeepSubDir));
    }

    @Test
    public void testGetFileStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            this.fSys.getFileStatus(this.getTestRootPath(this.fSys, "test/hadoop/file"));
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testListStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            this.fSys.listStatus(this.getTestRootPath(this.fSys, "test/hadoop/file"));
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListStatusThrowsExceptionForUnreadableDir() throws Exception {
        Path testRootDir = this.getTestRootPath(this.fSys, "test/hadoop/dir");
        Path obscuredDir = new Path(testRootDir, "foo");
        Path subDir = new Path(obscuredDir, "bar");
        this.fSys.mkdirs(subDir);
        this.fSys.setPermission(obscuredDir, new FsPermission(0));
        try {
            this.fSys.listStatus(obscuredDir);
            Assert.fail((String)"Should throw IOException");
        }
        catch (IOException ioe) {
        }
        finally {
            this.fSys.setPermission(obscuredDir, new FsPermission(493));
        }
    }

    @Test
    public void testListStatus() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, "test/hadoop/a"), this.getTestRootPath(this.fSys, "test/hadoop/b"), this.getTestRootPath(this.fSys, "test/hadoop/c/1")};
        Assert.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, testDirs[0]));
        for (Path path : testDirs) {
            this.fSys.mkdirs(path);
        }
        FileStatus[] paths = this.fSys.listStatus(this.getTestRootPath(this.fSys, "test"));
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)this.getTestRootPath(this.fSys, "test/hadoop"), (Object)paths[0].getPath());
        paths = this.fSys.listStatus(this.getTestRootPath(this.fSys, "test/hadoop"));
        Assert.assertEquals((long)3L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, "test/hadoop/a"), paths));
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, "test/hadoop/b"), paths));
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, "test/hadoop/c"), paths));
        paths = this.fSys.listStatus(this.getTestRootPath(this.fSys, "test/hadoop/a"));
        Assert.assertEquals((long)0L, (long)paths.length);
    }

    @Test
    public void testListStatusFilterWithNoMatches() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA2), this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.listStatus(this.getTestRootPath(this.fSys, "test"), TEST_X_FILTER);
        Assert.assertEquals((long)0L, (long)filteredPaths.length);
    }

    @Test
    public void testListStatusFilterWithSomeMatches() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AAA2)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.listStatus(this.getTestRootPath(this.fSys, "test/hadoop"), TEST_X_FILTER);
        Assert.assertEquals((long)2L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusNonExistentFile() throws Exception {
        FileStatus[] paths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoopfsdf"));
        Assert.assertNull((Object)paths);
        paths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoopfsdf/?"));
        Assert.assertEquals((long)0L, (long)paths.length);
        paths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoopfsdf/xyz*/?"));
        Assert.assertEquals((long)0L, (long)paths.length);
    }

    @Test
    public void testGlobStatusWithNoMatchesInPath() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AAA2)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/?"));
        Assert.assertEquals((long)0L, (long)paths.length);
    }

    @Test
    public void testGlobStatusSomeMatchesInDirectories() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AAA2)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop*"));
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, "test/hadoop"), paths));
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, "test/hadoop2"), paths));
    }

    @Test
    public void testGlobStatusWithMultipleWildCardMatches() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AAA2)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop*/*"));
        Assert.assertEquals((long)4L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AAA), paths));
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXA), paths));
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXX), paths));
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AAA2), paths));
    }

    @Test
    public void testGlobStatusWithMultipleMatchesOfSingleChar() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AAA2)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/ax?"));
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXA), paths));
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXX), paths));
    }

    @Test
    public void testGlobStatusFilterWithEmptyPathResults() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AXX)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/?"), DEFAULT_FILTER);
        Assert.assertEquals((long)0L, (long)filteredPaths.length);
    }

    @Test
    public void testGlobStatusFilterWithSomePathMatchesAndTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AXX)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/*"), DEFAULT_FILTER);
        Assert.assertEquals((long)3L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AAA), filteredPaths));
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithMultipleWildCardMatchesAndTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AXX)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/a??"), DEFAULT_FILTER);
        Assert.assertEquals((long)3L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AAA), filteredPaths));
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithMultiplePathMatchesAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AXX)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/*"), TEST_X_FILTER);
        Assert.assertEquals((long)2L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithNoMatchingPathsAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AXX)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/?"), TEST_X_FILTER);
        Assert.assertEquals((long)0L, (long)filteredPaths.length);
    }

    @Test
    public void testGlobStatusFilterWithMultiplePathWildcardsAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AXX)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/a??"), TEST_X_FILTER);
        Assert.assertEquals((long)2L, (long)filteredPaths.length);
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXA), filteredPaths));
        Assert.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testWriteReadAndDeleteEmptyFile() throws Exception {
        this.writeReadAndDelete(0);
    }

    @Test
    public void testWriteReadAndDeleteHalfABlock() throws Exception {
        this.writeReadAndDelete(FSMainOperationsBaseTest.getDefaultBlockSize() / 2);
    }

    @Test
    public void testWriteReadAndDeleteOneBlock() throws Exception {
        this.writeReadAndDelete(FSMainOperationsBaseTest.getDefaultBlockSize());
    }

    @Test
    public void testWriteReadAndDeleteOneAndAHalfBlocks() throws Exception {
        int blockSize = FSMainOperationsBaseTest.getDefaultBlockSize();
        this.writeReadAndDelete(blockSize + blockSize / 2);
    }

    @Test
    public void testWriteReadAndDeleteTwoBlocks() throws Exception {
        this.writeReadAndDelete(FSMainOperationsBaseTest.getDefaultBlockSize() * 2);
    }

    protected void writeReadAndDelete(int len) throws IOException {
        Path path = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.fSys.mkdirs(path.getParent());
        FSDataOutputStream out = this.fSys.create(path, false, 4096, (short)1, FSMainOperationsBaseTest.getDefaultBlockSize());
        out.write(data, 0, len);
        out.close();
        Assert.assertTrue((String)"Exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, path));
        Assert.assertEquals((String)"Length", (long)len, (long)this.fSys.getFileStatus(path).getLen());
        FSDataInputStream in = this.fSys.open(path);
        byte[] buf = new byte[len];
        in.readFully(0L, buf);
        in.close();
        Assert.assertEquals((long)len, (long)buf.length);
        for (int i = 0; i < buf.length; ++i) {
            Assert.assertEquals((String)("Position " + i), (long)data[i], (long)buf[i]);
        }
        Assert.assertTrue((String)"Deleted", (boolean)this.fSys.delete(path, false));
        Assert.assertFalse((String)"No longer exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, path));
    }

    @Test
    public void testOverwrite() throws IOException {
        Path path = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.fSys.mkdirs(path.getParent());
        this.createFile(path);
        Assert.assertTrue((String)"Exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, path));
        Assert.assertEquals((String)"Length", (long)data.length, (long)this.fSys.getFileStatus(path).getLen());
        try {
            this.createFile(path);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        FSDataOutputStream out = this.fSys.create(path, true, 4096);
        out.write(data, 0, data.length);
        out.close();
        Assert.assertTrue((String)"Exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, path));
        Assert.assertEquals((String)"Length", (long)data.length, (long)this.fSys.getFileStatus(path).getLen());
    }

    @Test
    public void testWriteInNonExistentDirectory() throws IOException {
        Path path = this.getTestRootPath(this.fSys, "test/hadoop/file");
        Assert.assertFalse((String)"Parent doesn't exist", (boolean)FSMainOperationsBaseTest.exists(this.fSys, path.getParent()));
        this.createFile(path);
        Assert.assertTrue((String)"Exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, path));
        Assert.assertEquals((String)"Length", (long)data.length, (long)this.fSys.getFileStatus(path).getLen());
        Assert.assertTrue((String)"Parent exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, path.getParent()));
    }

    @Test
    public void testDeleteNonExistentFile() throws IOException {
        Path path = this.getTestRootPath(this.fSys, "test/hadoop/file");
        Assert.assertFalse((String)"Doesn't exist", (boolean)FSMainOperationsBaseTest.exists(this.fSys, path));
        Assert.assertFalse((String)"No deletion", (boolean)this.fSys.delete(path, true));
    }

    @Test
    public void testDeleteRecursively() throws IOException {
        Path dir = this.getTestRootPath(this.fSys, "test/hadoop");
        Path file = this.getTestRootPath(this.fSys, "test/hadoop/file");
        Path subdir = this.getTestRootPath(this.fSys, "test/hadoop/subdir");
        this.createFile(file);
        this.fSys.mkdirs(subdir);
        Assert.assertTrue((String)"File exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, file));
        Assert.assertTrue((String)"Dir exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, dir));
        Assert.assertTrue((String)"Subdir exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, subdir));
        try {
            this.fSys.delete(dir, false);
            Assert.fail((String)"Should throw IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
        Assert.assertTrue((String)"File still exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, file));
        Assert.assertTrue((String)"Dir still exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, dir));
        Assert.assertTrue((String)"Subdir still exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, subdir));
        Assert.assertTrue((String)"Deleted", (boolean)this.fSys.delete(dir, true));
        Assert.assertFalse((String)"File doesn't exist", (boolean)FSMainOperationsBaseTest.exists(this.fSys, file));
        Assert.assertFalse((String)"Dir doesn't exist", (boolean)FSMainOperationsBaseTest.exists(this.fSys, dir));
        Assert.assertFalse((String)"Subdir doesn't exist", (boolean)FSMainOperationsBaseTest.exists(this.fSys, subdir));
    }

    @Test
    public void testDeleteEmptyDirectory() throws IOException {
        Path dir = this.getTestRootPath(this.fSys, "test/hadoop");
        this.fSys.mkdirs(dir);
        Assert.assertTrue((String)"Dir exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, dir));
        Assert.assertTrue((String)"Deleted", (boolean)this.fSys.delete(dir, false));
        Assert.assertFalse((String)"Dir doesn't exist", (boolean)FSMainOperationsBaseTest.exists(this.fSys, dir));
    }

    @Test
    public void testRenameNonExistentPath() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/nonExistent");
        Path dst = this.getTestRootPath(this.fSys, "test/new/newpath");
        try {
            this.rename(src, dst, false, false, false, Options.Rename.NONE);
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (IOException e) {
            Log.info((String)"XXX", (Object)e);
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
        try {
            this.rename(src, dst, false, false, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Should throw FileNotFoundException");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
    }

    @Test
    public void testRenameFileToNonExistentDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        Path dst = this.getTestRootPath(this.fSys, "test/nonExistent/newfile");
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
        try {
            this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
    }

    @Test
    public void testRenameFileToDestinationWithParentFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        Path dst = this.getTestRootPath(this.fSys, "test/parentFile/newfile");
        this.createFile(dst.getParent());
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameFileToExistingParent() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        Path dst = this.getTestRootPath(this.fSys, "test/new/newfile");
        this.fSys.mkdirs(dst.getParent());
        this.rename(src, dst, true, false, true, Options.Rename.OVERWRITE);
    }

    @Test
    public void testRenameFileToItself() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        try {
            this.rename(src, src, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Renamed file to itself");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            this.rename(src, src, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Renamed file to itself");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameFileAsExistingFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        Path dst = this.getTestRootPath(this.fSys, "test/new/existingFile");
        this.createFile(dst);
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        this.rename(src, dst, true, false, true, Options.Rename.OVERWRITE);
    }

    @Test
    public void testRenameFileAsExistingDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        Path dst = this.getTestRootPath(this.fSys, "test/new/existingDir");
        this.fSys.mkdirs(dst);
        try {
            this.rename(src, dst, false, false, true, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.rename(src, dst, false, false, true, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameDirectoryToItself() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/dir");
        this.fSys.mkdirs(src);
        try {
            this.rename(src, src, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Renamed directory to itself");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            this.rename(src, src, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Renamed directory to itself");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameDirectoryToNonExistentParent() throws Exception {
        block6: {
            IOException ioException;
            Path dst;
            Path src;
            block5: {
                if (!this.renameSupported()) {
                    return;
                }
                src = this.getTestRootPath(this.fSys, "test/hadoop/dir");
                this.fSys.mkdirs(src);
                dst = this.getTestRootPath(this.fSys, "test/nonExistent/newdir");
                try {
                    this.rename(src, dst, false, true, false, Options.Rename.NONE);
                    Assert.fail((String)"Expected exception was not thrown");
                }
                catch (IOException e) {
                    ioException = this.unwrapException(e);
                    if (ioException instanceof FileNotFoundException) break block5;
                    throw ioException;
                }
            }
            try {
                this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
                Assert.fail((String)"Expected exception was not thrown");
            }
            catch (IOException e) {
                ioException = this.unwrapException(e);
                if (ioException instanceof FileNotFoundException) break block6;
                throw ioException;
            }
        }
    }

    @Test
    public void testRenameDirectoryAsNonExistentDirectory() throws Exception {
        this.doTestRenameDirectoryAsNonExistentDirectory(Options.Rename.NONE);
        this.tearDown();
        this.doTestRenameDirectoryAsNonExistentDirectory(Options.Rename.OVERWRITE);
    }

    private void doTestRenameDirectoryAsNonExistentDirectory(Options.Rename ... options) throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/dir");
        this.fSys.mkdirs(src);
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/dir/file1"));
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/dir/subdir/file2"));
        Path dst = this.getTestRootPath(this.fSys, "test/new/newdir");
        this.fSys.mkdirs(dst.getParent());
        this.rename(src, dst, true, false, true, options);
        Assert.assertFalse((String)"Nested file1 exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, this.getTestRootPath(this.fSys, "test/hadoop/dir/file1")));
        Assert.assertFalse((String)"Nested file2 exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, this.getTestRootPath(this.fSys, "test/hadoop/dir/subdir/file2")));
        Assert.assertTrue((String)"Renamed nested file1 exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, this.getTestRootPath(this.fSys, "test/new/newdir/file1")));
        Assert.assertTrue((String)"Renamed nested exists", (boolean)FSMainOperationsBaseTest.exists(this.fSys, this.getTestRootPath(this.fSys, "test/new/newdir/subdir/file2")));
    }

    @Test
    public void testRenameDirectoryAsEmptyDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/dir");
        this.fSys.mkdirs(src);
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/dir/file1"));
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/dir/subdir/file2"));
        Path dst = this.getTestRootPath(this.fSys, "test/new/newdir");
        this.fSys.mkdirs(dst);
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        this.rename(src, dst, true, false, true, Options.Rename.OVERWRITE);
    }

    @Test
    public void testRenameDirectoryAsNonEmptyDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/dir");
        this.fSys.mkdirs(src);
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/dir/file1"));
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/dir/subdir/file2"));
        Path dst = this.getTestRootPath(this.fSys, "test/new/newdir");
        this.fSys.mkdirs(dst);
        this.createFile(this.getTestRootPath(this.fSys, "test/new/newdir/file1"));
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameDirectoryAsFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/dir");
        this.fSys.mkdirs(src);
        Path dst = this.getTestRootPath(this.fSys, "test/new/newfile");
        this.createFile(dst);
        try {
            this.rename(src, dst, false, true, true, Options.Rename.NONE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.rename(src, dst, false, true, true, Options.Rename.OVERWRITE);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testInputStreamClosedTwice() throws IOException {
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        FSDataInputStream in = this.fSys.open(src);
        in.close();
        in.close();
    }

    @Test
    public void testOutputStreamClosedTwice() throws IOException {
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        FSDataOutputStream out = this.fSys.create(src);
        out.writeChar(72);
        out.close();
        out.close();
    }

    @Test
    public void testGetWrappedInputStream() throws IOException {
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        FSDataInputStream in = this.fSys.open(src);
        InputStream is = in.getWrappedStream();
        in.close();
        Assert.assertNotNull((Object)is);
    }

    @Test
    public void testCopyToLocalWithUseRawLocalFileSystemOption() throws Exception {
        Configuration conf = new Configuration();
        RawLocalFileSystem fSys = new RawLocalFileSystem();
        Path fileToFS = new Path(this.getTestRootDir(), "fs.txt");
        Path fileToLFS = new Path(this.getTestRootDir(), "test.txt");
        Path crcFileAtLFS = new Path(this.getTestRootDir(), ".test.txt.crc");
        ((FileSystem)fSys).initialize(new URI("file:///"), conf);
        this.writeFile(fSys, fileToFS);
        if (fSys.exists(crcFileAtLFS)) {
            Assert.assertTrue((String)"CRC files not deleted", (boolean)((FileSystem)fSys).delete(crcFileAtLFS, true));
        }
        fSys.copyToLocalFile(false, fileToFS, fileToLFS, true);
        Assert.assertFalse((String)"CRC files are created", (boolean)fSys.exists(crcFileAtLFS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(FileSystem fs, Path name) throws IOException {
        FSDataOutputStream stm = fs.create(name);
        try {
            stm.writeBytes("42\n");
        }
        finally {
            stm.close();
        }
    }

    protected void createFile(Path path) throws IOException {
        FSMainOperationsBaseTest.createFile(this.fSys, path);
    }

    private void rename(Path src, Path dst, boolean renameShouldSucceed, boolean srcExists, boolean dstExists, Options.Rename ... options) throws IOException {
        this.fSys.rename(src, dst, options);
        if (!renameShouldSucceed) {
            Assert.fail((String)"rename should have thrown exception");
        }
        Assert.assertEquals((String)"Source exists", (Object)srcExists, (Object)FSMainOperationsBaseTest.exists(this.fSys, src));
        Assert.assertEquals((String)"Destination exists", (Object)dstExists, (Object)FSMainOperationsBaseTest.exists(this.fSys, dst));
    }

    private boolean containsTestRootPath(Path path, FileStatus[] filteredPaths) throws IOException {
        Path testRootPath = this.getTestRootPath(this.fSys, path.toString());
        for (int i = 0; i < filteredPaths.length; ++i) {
            if (!testRootPath.equals(filteredPaths[i].getPath())) continue;
            return true;
        }
        return false;
    }
}

