/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCommandFormat {
    private static List<String> args;
    private static List<String> expectedArgs;
    private static Set<String> expectedOpts;

    @Before
    public void setUp() {
        args = new ArrayList<String>();
        expectedOpts = new HashSet<String>();
        expectedArgs = new ArrayList<String>();
    }

    @Test
    public void testNoArgs() {
        TestCommandFormat.checkArgLimits(null, 0, 0, new String[0]);
        TestCommandFormat.checkArgLimits(null, 0, 1, new String[0]);
        TestCommandFormat.checkArgLimits(CommandFormat.NotEnoughArgumentsException.class, 1, 1, new String[0]);
        TestCommandFormat.checkArgLimits(CommandFormat.NotEnoughArgumentsException.class, 1, 2, new String[0]);
    }

    @Test
    public void testOneArg() {
        args = TestCommandFormat.listOf("a");
        expectedArgs = TestCommandFormat.listOf("a");
        TestCommandFormat.checkArgLimits(CommandFormat.TooManyArgumentsException.class, 0, 0, new String[0]);
        TestCommandFormat.checkArgLimits(null, 0, 1, new String[0]);
        TestCommandFormat.checkArgLimits(null, 1, 1, new String[0]);
        TestCommandFormat.checkArgLimits(null, 1, 2, new String[0]);
        TestCommandFormat.checkArgLimits(CommandFormat.NotEnoughArgumentsException.class, 2, 3, new String[0]);
    }

    @Test
    public void testTwoArgs() {
        args = TestCommandFormat.listOf("a", "b");
        expectedArgs = TestCommandFormat.listOf("a", "b");
        TestCommandFormat.checkArgLimits(CommandFormat.TooManyArgumentsException.class, 0, 0, new String[0]);
        TestCommandFormat.checkArgLimits(CommandFormat.TooManyArgumentsException.class, 1, 1, new String[0]);
        TestCommandFormat.checkArgLimits(null, 1, 2, new String[0]);
        TestCommandFormat.checkArgLimits(null, 2, 2, new String[0]);
        TestCommandFormat.checkArgLimits(null, 2, 3, new String[0]);
        TestCommandFormat.checkArgLimits(CommandFormat.NotEnoughArgumentsException.class, 3, 3, new String[0]);
    }

    @Test
    public void testOneOpt() {
        args = TestCommandFormat.listOf("-a");
        expectedOpts = TestCommandFormat.setOf("a");
        TestCommandFormat.checkArgLimits(CommandFormat.UnknownOptionException.class, 0, 0, new String[0]);
        TestCommandFormat.checkArgLimits(null, 0, 0, "a", "b");
        TestCommandFormat.checkArgLimits(CommandFormat.NotEnoughArgumentsException.class, 1, 1, "a", "b");
    }

    @Test
    public void testTwoOpts() {
        args = TestCommandFormat.listOf("-a", "-b");
        expectedOpts = TestCommandFormat.setOf("a", "b");
        TestCommandFormat.checkArgLimits(CommandFormat.UnknownOptionException.class, 0, 0, new String[0]);
        TestCommandFormat.checkArgLimits(null, 0, 0, "a", "b");
        TestCommandFormat.checkArgLimits(null, 0, 1, "a", "b");
        TestCommandFormat.checkArgLimits(CommandFormat.NotEnoughArgumentsException.class, 1, 1, "a", "b");
    }

    @Test
    public void testOptArg() {
        args = TestCommandFormat.listOf("-a", "b");
        expectedOpts = TestCommandFormat.setOf("a");
        expectedArgs = TestCommandFormat.listOf("b");
        TestCommandFormat.checkArgLimits(CommandFormat.UnknownOptionException.class, 0, 0, new String[0]);
        TestCommandFormat.checkArgLimits(CommandFormat.TooManyArgumentsException.class, 0, 0, "a", "b");
        TestCommandFormat.checkArgLimits(null, 0, 1, "a", "b");
        TestCommandFormat.checkArgLimits(null, 1, 1, "a", "b");
        TestCommandFormat.checkArgLimits(null, 1, 2, "a", "b");
        TestCommandFormat.checkArgLimits(CommandFormat.NotEnoughArgumentsException.class, 2, 2, "a", "b");
    }

    @Test
    public void testArgOpt() {
        args = TestCommandFormat.listOf("b", "-a");
        expectedArgs = TestCommandFormat.listOf("b", "-a");
        TestCommandFormat.checkArgLimits(CommandFormat.TooManyArgumentsException.class, 0, 0, "a", "b");
        TestCommandFormat.checkArgLimits(null, 1, 2, "a", "b");
        TestCommandFormat.checkArgLimits(null, 2, 2, "a", "b");
        TestCommandFormat.checkArgLimits(CommandFormat.NotEnoughArgumentsException.class, 3, 4, "a", "b");
    }

    @Test
    public void testOptStopOptArg() {
        args = TestCommandFormat.listOf("-a", "--", "-b", "c");
        expectedOpts = TestCommandFormat.setOf("a");
        expectedArgs = TestCommandFormat.listOf("-b", "c");
        TestCommandFormat.checkArgLimits(CommandFormat.UnknownOptionException.class, 0, 0, new String[0]);
        TestCommandFormat.checkArgLimits(CommandFormat.TooManyArgumentsException.class, 0, 1, "a", "b");
        TestCommandFormat.checkArgLimits(null, 2, 2, "a", "b");
        TestCommandFormat.checkArgLimits(CommandFormat.NotEnoughArgumentsException.class, 3, 4, "a", "b");
    }

    @Test
    public void testOptDashArg() {
        args = TestCommandFormat.listOf("-b", "-", "-c");
        expectedOpts = TestCommandFormat.setOf("b");
        expectedArgs = TestCommandFormat.listOf("-", "-c");
        TestCommandFormat.checkArgLimits(CommandFormat.UnknownOptionException.class, 0, 0, new String[0]);
        TestCommandFormat.checkArgLimits(CommandFormat.TooManyArgumentsException.class, 0, 0, "b", "c");
        TestCommandFormat.checkArgLimits(CommandFormat.TooManyArgumentsException.class, 1, 1, "b", "c");
        TestCommandFormat.checkArgLimits(null, 2, 2, "b", "c");
        TestCommandFormat.checkArgLimits(CommandFormat.NotEnoughArgumentsException.class, 3, 4, "b", "c");
    }

    @Test
    public void testOldArgsWithIndex() {
        String[] arrayArgs = new String[]{"ignore", "-a", "b", "-c"};
        CommandFormat cf = new CommandFormat(0, 9, "a", "c");
        List<String> parsedArgs = cf.parse(arrayArgs, 0);
        Assert.assertEquals(TestCommandFormat.setOf(new String[0]), cf.getOpts());
        Assert.assertEquals(TestCommandFormat.listOf("ignore", "-a", "b", "-c"), parsedArgs);
        cf = new CommandFormat(0, 9, "a", "c");
        parsedArgs = cf.parse(arrayArgs, 1);
        Assert.assertEquals(TestCommandFormat.setOf("a"), cf.getOpts());
        Assert.assertEquals(TestCommandFormat.listOf("b", "-c"), parsedArgs);
        cf = new CommandFormat(0, 9, "a", "c");
        parsedArgs = cf.parse(arrayArgs, 2);
        Assert.assertEquals(TestCommandFormat.setOf(new String[0]), cf.getOpts());
        Assert.assertEquals(TestCommandFormat.listOf("b", "-c"), parsedArgs);
    }

    private static <T> CommandFormat checkArgLimits(Class<? extends IllegalArgumentException> expectedErr, int min, int max, String ... opts) {
        CommandFormat cf = new CommandFormat(min, max, opts);
        ArrayList<String> parsedArgs = new ArrayList<String>(args);
        Class<?> cfError = null;
        try {
            cf.parse(parsedArgs);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            cfError = e.getClass();
        }
        Assert.assertEquals(expectedErr, cfError);
        if (expectedErr == null) {
            Assert.assertEquals(expectedArgs, parsedArgs);
            Assert.assertEquals(expectedOpts, cf.getOpts());
        }
        return cf;
    }

    private static List<String> listOf(String ... objects) {
        return Arrays.asList(objects);
    }

    private static Set<String> setOf(String ... objects) {
        return new HashSet<String>(TestCommandFormat.listOf(objects));
    }
}

