/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFileUtil {
    private static final Log LOG = LogFactory.getLog(TestFileUtil.class);
    private static final String TEST_ROOT_DIR = System.getProperty("test.build.data", "/tmp") + "/fu";
    private static final File TEST_DIR = new File(TEST_ROOT_DIR);
    private static final String FILE = "x";
    private static final String LINK = "y";
    private static final String DIR = "dir";
    private final File del = new File(TEST_DIR, "del");
    private final File tmp = new File(TEST_DIR, "tmp");
    private final File dir1 = new File(this.del, "dir1");
    private final File dir2 = new File(this.del, "dir2");
    private final File partitioned = new File(TEST_DIR, "partitioned");
    private final File xSubDir = new File(this.del, "xSubDir");
    private final File xSubSubDir = new File(this.xSubDir, "xSubSubDir");
    private final File ySubDir = new File(this.del, "ySubDir");
    private static final String file1Name = "file1";
    private final File file2 = new File(this.xSubDir, "file2");
    private final File file22 = new File(this.xSubSubDir, "file22");
    private final File file3 = new File(this.ySubDir, "file3");
    private final File zlink = new File(this.del, "zlink");

    private void setupDirs() throws IOException {
        Assert.assertFalse((boolean)this.del.exists());
        Assert.assertFalse((boolean)this.tmp.exists());
        Assert.assertFalse((boolean)this.partitioned.exists());
        this.del.mkdirs();
        this.tmp.mkdirs();
        this.partitioned.mkdirs();
        new File(this.del, FILE).createNewFile();
        File tmpFile = new File(this.tmp, FILE);
        tmpFile.createNewFile();
        this.dir1.mkdirs();
        this.dir2.mkdirs();
        new File(this.dir1, FILE).createNewFile();
        new File(this.dir2, FILE).createNewFile();
        File link = new File(this.del, LINK);
        FileUtil.symLink(tmpFile.toString(), link.toString());
        File linkDir = new File(this.del, "tmpDir");
        FileUtil.symLink(this.tmp.toString(), linkDir.toString());
        Assert.assertEquals((long)5L, (long)this.del.listFiles().length);
        this.createFile(this.partitioned, "part-r-00000", "foo");
        this.createFile(this.partitioned, "part-r-00001", "bar");
        FileUtil.symLink(this.del.toString(), this.dir1.toString() + "/cycle");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFile(File directory, String name, String contents) throws IOException {
        File newFile = new File(directory, name);
        PrintWriter pw = new PrintWriter(newFile);
        try {
            pw.println(contents);
        }
        finally {
            pw.close();
        }
        return newFile;
    }

    @Test(timeout=30000L)
    public void testListFiles() throws IOException {
        this.setupDirs();
        File[] files = FileUtil.listFiles(this.partitioned);
        Assert.assertEquals((long)2L, (long)files.length);
        File newDir = new File(this.tmp.getPath(), "test");
        newDir.mkdir();
        Assert.assertTrue((String)"Failed to create test dir", (boolean)newDir.exists());
        files = FileUtil.listFiles(newDir);
        Assert.assertEquals((long)0L, (long)files.length);
        newDir.delete();
        Assert.assertFalse((String)"Failed to delete test dir", (boolean)newDir.exists());
        try {
            files = FileUtil.listFiles(newDir);
            Assert.fail((String)("IOException expected on listFiles() for non-existent dir " + newDir.toString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(timeout=30000L)
    public void testListAPI() throws IOException {
        this.setupDirs();
        String[] files = FileUtil.list(this.partitioned);
        Assert.assertEquals((String)"Unexpected number of pre-existing files", (long)2L, (long)files.length);
        File newDir = new File(this.tmp.getPath(), "test");
        newDir.mkdir();
        Assert.assertTrue((String)"Failed to create test dir", (boolean)newDir.exists());
        files = FileUtil.list(newDir);
        Assert.assertEquals((String)"New directory unexpectedly contains files", (long)0L, (long)files.length);
        newDir.delete();
        Assert.assertFalse((String)"Failed to delete test dir", (boolean)newDir.exists());
        try {
            files = FileUtil.list(newDir);
            Assert.fail((String)("IOException expected on list() for non-existent dir " + newDir.toString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Before
    public void before() throws IOException {
        this.cleanupImpl();
    }

    @After
    public void tearDown() throws IOException {
        this.cleanupImpl();
    }

    private void cleanupImpl() throws IOException {
        FileUtil.fullyDelete(this.del, true);
        Assert.assertTrue((!this.del.exists() ? 1 : 0) != 0);
        FileUtil.fullyDelete(this.tmp, true);
        Assert.assertTrue((!this.tmp.exists() ? 1 : 0) != 0);
        FileUtil.fullyDelete(this.partitioned, true);
        Assert.assertTrue((!this.partitioned.exists() ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testFullyDelete() throws IOException {
        this.setupDirs();
        boolean ret = FileUtil.fullyDelete(this.del);
        Assert.assertTrue((boolean)ret);
        Assert.assertFalse((boolean)this.del.exists());
        this.validateTmpDir();
    }

    @Test(timeout=30000L)
    public void testFullyDeleteSymlinks() throws IOException {
        this.setupDirs();
        File link = new File(this.del, LINK);
        Assert.assertEquals((long)5L, (long)this.del.list().length);
        boolean ret = FileUtil.fullyDelete(link);
        Assert.assertTrue((boolean)ret);
        Assert.assertFalse((boolean)link.exists());
        Assert.assertEquals((long)4L, (long)this.del.list().length);
        this.validateTmpDir();
        File linkDir = new File(this.del, "tmpDir");
        ret = FileUtil.fullyDelete(linkDir);
        Assert.assertTrue((boolean)ret);
        Assert.assertFalse((boolean)linkDir.exists());
        Assert.assertEquals((long)3L, (long)this.del.list().length);
        this.validateTmpDir();
    }

    @Test(timeout=30000L)
    public void testFullyDeleteDanglingSymlinks() throws IOException {
        this.setupDirs();
        boolean ret = FileUtil.fullyDelete(this.tmp);
        Assert.assertTrue((boolean)ret);
        Assert.assertFalse((boolean)this.tmp.exists());
        File link = new File(this.del, LINK);
        Assert.assertEquals((long)5L, (long)this.del.list().length);
        ret = FileUtil.fullyDelete(link);
        Assert.assertTrue((boolean)ret);
        Assert.assertEquals((long)4L, (long)this.del.list().length);
        File linkDir = new File(this.del, "tmpDir");
        ret = FileUtil.fullyDelete(linkDir);
        Assert.assertTrue((boolean)ret);
        Assert.assertEquals((long)3L, (long)this.del.list().length);
    }

    @Test(timeout=30000L)
    public void testFullyDeleteContents() throws IOException {
        this.setupDirs();
        boolean ret = FileUtil.fullyDeleteContents(this.del);
        Assert.assertTrue((boolean)ret);
        Assert.assertTrue((boolean)this.del.exists());
        Assert.assertEquals((long)0L, (long)this.del.listFiles().length);
        this.validateTmpDir();
    }

    private void validateTmpDir() {
        Assert.assertTrue((boolean)this.tmp.exists());
        Assert.assertEquals((long)1L, (long)this.tmp.listFiles().length);
        Assert.assertTrue((boolean)new File(this.tmp, FILE).exists());
    }

    private void setupDirsAndNonWritablePermissions() throws IOException {
        Assert.assertFalse((String)"The directory del should not have existed!", (boolean)this.del.exists());
        this.del.mkdirs();
        new MyFile(this.del, file1Name).createNewFile();
        this.xSubDir.mkdirs();
        this.file2.createNewFile();
        this.xSubSubDir.mkdirs();
        this.file22.createNewFile();
        TestFileUtil.revokePermissions(this.file22);
        TestFileUtil.revokePermissions(this.xSubSubDir);
        TestFileUtil.revokePermissions(this.file2);
        TestFileUtil.revokePermissions(this.xSubDir);
        this.ySubDir.mkdirs();
        this.file3.createNewFile();
        Assert.assertFalse((String)"The directory tmp should not have existed!", (boolean)this.tmp.exists());
        this.tmp.mkdirs();
        File tmpFile = new File(this.tmp, FILE);
        tmpFile.createNewFile();
        FileUtil.symLink(tmpFile.toString(), this.zlink.toString());
    }

    private static void grantPermissions(File f) {
        FileUtil.setReadable(f, true);
        FileUtil.setWritable(f, true);
        FileUtil.setExecutable(f, true);
    }

    private static void revokePermissions(File f) {
        FileUtil.setWritable(f, false);
        FileUtil.setExecutable(f, false);
        FileUtil.setReadable(f, false);
    }

    private void validateAndSetWritablePermissions(boolean expectedRevokedPermissionDirsExist, boolean ret) {
        TestFileUtil.grantPermissions(this.xSubDir);
        TestFileUtil.grantPermissions(this.xSubSubDir);
        Assert.assertFalse((String)"The return value should have been false.", (boolean)ret);
        Assert.assertTrue((String)"The file file1 should not have been deleted.", (boolean)new File(this.del, file1Name).exists());
        Assert.assertEquals((String)"The directory xSubDir *should* not have been deleted.", (Object)expectedRevokedPermissionDirsExist, (Object)this.xSubDir.exists());
        Assert.assertEquals((String)"The file file2 *should* not have been deleted.", (Object)expectedRevokedPermissionDirsExist, (Object)this.file2.exists());
        Assert.assertEquals((String)"The directory xSubSubDir *should* not have been deleted.", (Object)expectedRevokedPermissionDirsExist, (Object)this.xSubSubDir.exists());
        Assert.assertEquals((String)"The file file22 *should* not have been deleted.", (Object)expectedRevokedPermissionDirsExist, (Object)this.file22.exists());
        Assert.assertFalse((String)"The directory ySubDir should have been deleted.", (boolean)this.ySubDir.exists());
        Assert.assertFalse((String)"The link zlink should have been deleted.", (boolean)this.zlink.exists());
    }

    @Test(timeout=30000L)
    public void testFailFullyDelete() throws IOException {
        if (Shell.WINDOWS) {
            return;
        }
        LOG.info((Object)"Running test to verify failure of fullyDelete()");
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDelete(new MyFile(this.del));
        this.validateAndSetWritablePermissions(true, ret);
    }

    @Test(timeout=30000L)
    public void testFailFullyDeleteGrantPermissions() throws IOException {
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDelete(new MyFile(this.del), true);
        this.validateAndSetWritablePermissions(false, ret);
    }

    @Test(timeout=30000L)
    public void testFailFullyDeleteContents() throws IOException {
        if (Shell.WINDOWS) {
            return;
        }
        LOG.info((Object)"Running test to verify failure of fullyDeleteContents()");
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDeleteContents(new MyFile(this.del));
        this.validateAndSetWritablePermissions(true, ret);
    }

    @Test(timeout=30000L)
    public void testFailFullyDeleteContentsGrantPermissions() throws IOException {
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDeleteContents(new MyFile(this.del), true);
        this.validateAndSetWritablePermissions(false, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testCopyMergeSingleDirectory() throws IOException {
        this.setupDirs();
        boolean copyMergeResult = this.copyMerge("partitioned", "tmp/merged");
        Assert.assertTrue((String)"Expected successful copyMerge result.", (boolean)copyMergeResult);
        File merged = new File(TEST_DIR, "tmp/merged");
        Assert.assertTrue((String)"File tmp/merged must exist after copyMerge.", (boolean)merged.exists());
        BufferedReader rdr = new BufferedReader(new FileReader(merged));
        try {
            Assert.assertEquals((String)"Line 1 of merged file must contain \"foo\".", (Object)"foo", (Object)rdr.readLine());
            Assert.assertEquals((String)"Line 2 of merged file must contain \"bar\".", (Object)"bar", (Object)rdr.readLine());
            Assert.assertNull((String)"Expected end of file reading merged file.", (Object)rdr.readLine());
        }
        finally {
            rdr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyMerge(String src, String dst) throws IOException {
        boolean result;
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal(conf);
        try {
            Path srcPath = new Path(TEST_ROOT_DIR, src);
            Path dstPath = new Path(TEST_ROOT_DIR, dst);
            boolean deleteSource = false;
            String addString = null;
            result = FileUtil.copyMerge(fs, srcPath, fs, dstPath, deleteSource, conf, addString);
        }
        finally {
            ((FileSystem)fs).close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testGetDU() throws Exception {
        this.setupDirs();
        long du = FileUtil.getDU(TEST_DIR);
        long expected = 2 * (3 + System.getProperty("line.separator").length());
        Assert.assertEquals((long)expected, (long)du);
        File doesNotExist = new File(this.tmp, "QuickBrownFoxJumpsOverTheLazyDog");
        long duDoesNotExist = FileUtil.getDU(doesNotExist);
        Assert.assertEquals((long)0L, (long)duDoesNotExist);
        File notADirectory = new File(this.partitioned, "part-r-00000");
        long duNotADirectoryActual = FileUtil.getDU(notADirectory);
        long duNotADirectoryExpected = 3 + System.getProperty("line.separator").length();
        Assert.assertEquals((long)duNotADirectoryExpected, (long)duNotADirectoryActual);
        try {
            try {
                FileUtil.chmod(notADirectory.getAbsolutePath(), "0000");
            }
            catch (InterruptedException ie) {
                Assert.assertNull((Object)ie);
            }
            Assert.assertFalse((boolean)notADirectory.canRead());
            long du3 = FileUtil.getDU(this.partitioned);
            Assert.assertEquals((long)expected, (long)du3);
            try {
                FileUtil.chmod(this.partitioned.getAbsolutePath(), "0000");
            }
            catch (InterruptedException ie) {
                Assert.assertNull((Object)ie);
            }
            Assert.assertFalse((boolean)this.partitioned.canRead());
            long du4 = FileUtil.getDU(this.partitioned);
            Assert.assertEquals((long)0L, (long)du4);
        }
        finally {
            FileUtil.chmod(this.partitioned.getAbsolutePath(), "0777", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testUnTar() throws IOException {
        this.setupDirs();
        File simpleTar = new File(this.del, FILE);
        FileOutputStream os = new FileOutputStream(simpleTar);
        TarOutputStream tos = new TarOutputStream((OutputStream)os);
        try {
            TarEntry te = new TarEntry("foo");
            byte[] data = "some-content".getBytes("UTF-8");
            te.setSize((long)data.length);
            tos.putNextEntry(te);
            tos.write(data);
            tos.closeEntry();
            tos.flush();
            tos.finish();
        }
        finally {
            tos.close();
        }
        FileUtil.unTar(simpleTar, this.tmp);
        Assert.assertTrue((boolean)new File(this.tmp, "foo").exists());
        Assert.assertEquals((long)12L, (long)new File(this.tmp, "foo").length());
        File regularFile = new File(this.tmp, "QuickBrownFoxJumpsOverTheLazyDog");
        regularFile.createNewFile();
        Assert.assertTrue((boolean)regularFile.exists());
        try {
            FileUtil.unTar(simpleTar, regularFile);
            Assert.assertTrue((String)"An IOException expected.", (boolean)false);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    @Test(timeout=30000L)
    public void testReplaceFile() throws IOException {
        this.setupDirs();
        File srcFile = new File(this.tmp, "src");
        srcFile.createNewFile();
        Assert.assertTrue((boolean)srcFile.exists());
        File targetFile = new File(this.tmp, "target");
        Assert.assertTrue((!targetFile.exists() ? 1 : 0) != 0);
        FileUtil.replaceFile(srcFile, targetFile);
        Assert.assertTrue((!srcFile.exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)targetFile.exists());
        srcFile.createNewFile();
        Assert.assertTrue((boolean)srcFile.exists());
        FileUtil.replaceFile(srcFile, targetFile);
        Assert.assertTrue((!srcFile.exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)targetFile.exists());
        srcFile.createNewFile();
        Assert.assertTrue((boolean)srcFile.exists());
        targetFile.delete();
        targetFile.mkdirs();
        File obstacle = new File(targetFile, "obstacle");
        obstacle.createNewFile();
        Assert.assertTrue((boolean)obstacle.exists());
        Assert.assertTrue((targetFile.exists() && targetFile.isDirectory() ? 1 : 0) != 0);
        try {
            FileUtil.replaceFile(srcFile, targetFile);
            Assert.assertTrue((boolean)false);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Assert.assertTrue((boolean)srcFile.exists());
        Assert.assertTrue((targetFile.exists() && targetFile.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)obstacle.exists());
    }

    @Test(timeout=30000L)
    public void testCreateLocalTempFile() throws IOException {
        this.setupDirs();
        File baseFile = new File(this.tmp, "base");
        File tmp1 = FileUtil.createLocalTempFile(baseFile, "foo", false);
        File tmp2 = FileUtil.createLocalTempFile(baseFile, "foo", true);
        Assert.assertFalse((boolean)tmp1.getAbsolutePath().equals(baseFile.getAbsolutePath()));
        Assert.assertFalse((boolean)tmp2.getAbsolutePath().equals(baseFile.getAbsolutePath()));
        Assert.assertTrue((tmp1.exists() && tmp2.exists() ? 1 : 0) != 0);
        Assert.assertTrue((tmp1.canWrite() && tmp2.canWrite() ? 1 : 0) != 0);
        Assert.assertTrue((tmp1.canRead() && tmp2.canRead() ? 1 : 0) != 0);
        tmp1.delete();
        tmp2.delete();
        Assert.assertTrue((!tmp1.exists() && !tmp2.exists() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testUnZip() throws IOException {
        this.setupDirs();
        File simpleZip = new File(this.del, FILE);
        FileOutputStream os = new FileOutputStream(simpleZip);
        ZipOutputStream tos = new ZipOutputStream(os);
        try {
            ZipEntry ze = new ZipEntry("foo");
            byte[] data = "some-content".getBytes("UTF-8");
            ze.setSize(data.length);
            tos.putNextEntry(ze);
            tos.write(data);
            tos.closeEntry();
            tos.flush();
            tos.finish();
        }
        finally {
            tos.close();
        }
        FileUtil.unZip(simpleZip, this.tmp);
        Assert.assertTrue((boolean)new File(this.tmp, "foo").exists());
        Assert.assertEquals((long)12L, (long)new File(this.tmp, "foo").length());
        File regularFile = new File(this.tmp, "QuickBrownFoxJumpsOverTheLazyDog");
        regularFile.createNewFile();
        Assert.assertTrue((boolean)regularFile.exists());
        try {
            FileUtil.unZip(simpleZip, regularFile);
            Assert.assertTrue((String)"An IOException expected.", (boolean)false);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    @Test(timeout=30000L)
    public void testCopy5() throws IOException {
        this.setupDirs();
        URI uri = this.tmp.toURI();
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.newInstance(uri, conf);
        String content = "some-content";
        File srcFile = this.createFile(this.tmp, "src", "some-content");
        Path srcPath = new Path(srcFile.toURI());
        File dest = new File(this.del, "dest");
        boolean result = FileUtil.copy(fs, srcPath, dest, false, conf);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((boolean)dest.exists());
        Assert.assertEquals((long)("some-content".getBytes().length + System.getProperty("line.separator").getBytes().length), (long)dest.length());
        Assert.assertTrue((boolean)srcFile.exists());
        dest.delete();
        Assert.assertTrue((!dest.exists() ? 1 : 0) != 0);
        result = FileUtil.copy(fs, srcPath, dest, true, conf);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((boolean)dest.exists());
        Assert.assertEquals((long)("some-content".getBytes().length + System.getProperty("line.separator").getBytes().length), (long)dest.length());
        Assert.assertTrue((!srcFile.exists() ? 1 : 0) != 0);
        dest.delete();
        Assert.assertTrue((!dest.exists() ? 1 : 0) != 0);
        srcPath = new Path(this.partitioned.toURI());
        result = FileUtil.copy(fs, srcPath, dest, true, conf);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((dest.exists() && dest.isDirectory() ? 1 : 0) != 0);
        File[] files = dest.listFiles();
        Assert.assertTrue((files != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)files.length);
        for (File f : files) {
            Assert.assertEquals((long)(3 + System.getProperty("line.separator").getBytes().length), (long)f.length());
        }
        Assert.assertTrue((!this.partitioned.exists() ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testStat2Paths1() {
        Assert.assertNull((Object)FileUtil.stat2Paths(null));
        FileStatus[] fileStatuses = new FileStatus[]{};
        Path[] paths = FileUtil.stat2Paths(fileStatuses);
        Assert.assertEquals((long)0L, (long)paths.length);
        Path path1 = new Path("file://foo");
        Path path2 = new Path("file://moo");
        fileStatuses = new FileStatus[]{new FileStatus(3L, false, 0, 0L, 0L, path1), new FileStatus(3L, false, 0, 0L, 0L, path2)};
        paths = FileUtil.stat2Paths(fileStatuses);
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertEquals((Object)paths[0], (Object)path1);
        Assert.assertEquals((Object)paths[1], (Object)path2);
    }

    @Test(timeout=30000L)
    public void testStat2Paths2() {
        Path defaultPath = new Path("file://default");
        Path[] paths = FileUtil.stat2Paths(null, defaultPath);
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)defaultPath, (Object)paths[0]);
        paths = FileUtil.stat2Paths(null, null);
        Assert.assertTrue((paths != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals(null, (Object)paths[0]);
        Path path1 = new Path("file://foo");
        Path path2 = new Path("file://moo");
        FileStatus[] fileStatuses = new FileStatus[]{new FileStatus(3L, false, 0, 0L, 0L, path1), new FileStatus(3L, false, 0, 0L, 0L, path2)};
        paths = FileUtil.stat2Paths(fileStatuses, defaultPath);
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertEquals((Object)paths[0], (Object)path1);
        Assert.assertEquals((Object)paths[1], (Object)path2);
    }

    @Test(timeout=30000L)
    public void testSymlink() throws Exception {
        Assert.assertFalse((boolean)this.del.exists());
        this.del.mkdirs();
        byte[] data = "testSymLink".getBytes();
        File file = new File(this.del, FILE);
        File link = new File(this.del, "_link");
        FileOutputStream os = new FileOutputStream(file);
        os.write(data);
        os.close();
        FileUtil.symLink(file.getAbsolutePath(), link.getAbsolutePath());
        Assert.assertEquals((long)data.length, (long)file.length());
        Assert.assertEquals((long)data.length, (long)link.length());
        FileInputStream in = new FileInputStream(link);
        long len = 0L;
        while (in.read() > 0) {
            ++len;
        }
        in.close();
        Assert.assertEquals((long)data.length, (long)len);
    }

    @Test(timeout=30000L)
    public void testSymlinkRenameTo() throws Exception {
        Assert.assertFalse((boolean)this.del.exists());
        this.del.mkdirs();
        File file = new File(this.del, FILE);
        file.createNewFile();
        File link = new File(this.del, "_link");
        FileUtil.symLink(file.getAbsolutePath(), link.getAbsolutePath());
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)link.exists());
        File link2 = new File(this.del, "_link2");
        Assert.assertTrue((boolean)link.renameTo(link2));
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)link2.exists());
        Assert.assertFalse((boolean)link.exists());
    }

    @Test(timeout=30000L)
    public void testSymlinkDelete() throws Exception {
        Assert.assertFalse((boolean)this.del.exists());
        this.del.mkdirs();
        File file = new File(this.del, FILE);
        file.createNewFile();
        File link = new File(this.del, "_link");
        FileUtil.symLink(file.getAbsolutePath(), link.getAbsolutePath());
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)link.exists());
        Assert.assertTrue((boolean)link.delete());
        Assert.assertFalse((boolean)link.exists());
        Assert.assertTrue((boolean)file.exists());
    }

    @Test(timeout=30000L)
    public void testSymlinkLength() throws Exception {
        Assert.assertFalse((boolean)this.del.exists());
        this.del.mkdirs();
        byte[] data = "testSymLinkData".getBytes();
        File file = new File(this.del, FILE);
        File link = new File(this.del, "_link");
        FileOutputStream os = new FileOutputStream(file);
        os.write(data);
        os.close();
        Assert.assertEquals((long)0L, (long)link.length());
        FileUtil.symLink(file.getAbsolutePath(), link.getAbsolutePath());
        Assert.assertEquals((long)data.length, (long)file.length());
        Assert.assertEquals((long)data.length, (long)link.length());
        file.delete();
        Assert.assertFalse((boolean)file.exists());
        if (Shell.WINDOWS && !Shell.isJava7OrAbove()) {
            Assert.assertEquals((long)data.length, (long)link.length());
        } else {
            Assert.assertEquals((long)0L, (long)link.length());
        }
        link.delete();
        Assert.assertFalse((boolean)link.exists());
    }

    private void doUntarAndVerify(File tarFile, File untarDir) throws IOException {
        if (untarDir.exists() && !FileUtil.fullyDelete(untarDir)) {
            throw new IOException("Could not delete directory '" + untarDir + "'");
        }
        FileUtil.unTar(tarFile, untarDir);
        String parentDir = untarDir.getCanonicalPath() + "/" + "name";
        File testFile = new File(parentDir + "/" + "version");
        Assert.assertTrue((boolean)testFile.exists());
        Assert.assertTrue((testFile.length() == 0L ? 1 : 0) != 0);
        String imageDir = parentDir + "/" + "image";
        testFile = new File(imageDir + "/" + "fsimage");
        Assert.assertTrue((boolean)testFile.exists());
        Assert.assertTrue((testFile.length() == 157L ? 1 : 0) != 0);
        String currentDir = parentDir + "/" + "current";
        testFile = new File(currentDir + "/" + "fsimage");
        Assert.assertTrue((boolean)testFile.exists());
        Assert.assertTrue((testFile.length() == 4331L ? 1 : 0) != 0);
        testFile = new File(currentDir + "/" + "edits");
        Assert.assertTrue((boolean)testFile.exists());
        Assert.assertTrue((testFile.length() == 1033L ? 1 : 0) != 0);
        testFile = new File(currentDir + "/" + "fstime");
        Assert.assertTrue((boolean)testFile.exists());
        Assert.assertTrue((testFile.length() == 8L ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testUntar() throws IOException {
        String tarGzFileName = System.getProperty("test.cache.data", "build/test/cache") + "/test-untar.tgz";
        String tarFileName = System.getProperty("test.cache.data", "build/test/cache") + "/test-untar.tar";
        String dataDir = System.getProperty("test.build.data", "build/test/data");
        File untarDir = new File(dataDir, "untarDir");
        this.doUntarAndVerify(new File(tarGzFileName), untarDir);
        this.doUntarAndVerify(new File(tarFileName), untarDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testCreateJarWithClassPath() throws Exception {
        Assert.assertFalse((boolean)this.tmp.exists());
        Assert.assertTrue((boolean)this.tmp.mkdirs());
        List<File> wildcardMatches = Arrays.asList(new File(this.tmp, "wildcard1.jar"), new File(this.tmp, "wildcard2.jar"), new File(this.tmp, "wildcard3.JAR"), new File(this.tmp, "wildcard4.JAR"));
        for (File wildcardMatch : wildcardMatches) {
            Assert.assertTrue((String)("failure creating file: " + wildcardMatch), (boolean)wildcardMatch.createNewFile());
        }
        Assert.assertTrue((boolean)new File(this.tmp, "text.txt").createNewFile());
        Assert.assertTrue((boolean)new File(this.tmp, "executable.exe").createNewFile());
        Assert.assertTrue((boolean)new File(this.tmp, "README").createNewFile());
        String wildcardPath = this.tmp.getCanonicalPath() + File.separator + "*";
        String nonExistentSubdir = this.tmp.getCanonicalPath() + "/" + "subdir" + "/";
        List<String> classPaths = Arrays.asList("", "cp1.jar", "cp2.jar", wildcardPath, "cp3.jar", nonExistentSubdir);
        String inputClassPath = StringUtils.join((CharSequence)File.pathSeparator, classPaths);
        String classPathJar = FileUtil.createJarWithClassPath(inputClassPath, new Path(this.tmp.getCanonicalPath()), System.getenv());
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(classPathJar);
            Manifest jarManifest = jarFile.getManifest();
            Assert.assertNotNull((Object)jarManifest);
            Attributes mainAttributes = jarManifest.getMainAttributes();
            Assert.assertNotNull((Object)mainAttributes);
            Assert.assertTrue((boolean)mainAttributes.containsKey(Attributes.Name.CLASS_PATH));
            String classPathAttr = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
            Assert.assertNotNull((Object)classPathAttr);
            ArrayList<String> expectedClassPaths = new ArrayList<String>();
            for (String classPath : classPaths) {
                if (classPath.length() == 0) continue;
                if (wildcardPath.equals(classPath)) {
                    for (File wildcardMatch : wildcardMatches) {
                        expectedClassPaths.add(wildcardMatch.toURI().toURL().toExternalForm());
                    }
                    continue;
                }
                File fileCp = null;
                fileCp = !new Path(classPath).isAbsolute() ? new File(this.tmp, classPath) : new File(classPath);
                if (nonExistentSubdir.equals(classPath)) {
                    expectedClassPaths.add(fileCp.toURI().toURL().toExternalForm() + "/");
                    continue;
                }
                expectedClassPaths.add(fileCp.toURI().toURL().toExternalForm());
            }
            List<String> actualClassPaths = Arrays.asList(classPathAttr.split(" "));
            Collections.sort(expectedClassPaths);
            Collections.sort(actualClassPaths);
            Assert.assertEquals(expectedClassPaths, actualClassPaths);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("exception closing jarFile: " + classPathJar), (Throwable)e);
                }
            }
        }
    }

    public static class MyFile
    extends File {
        private static final long serialVersionUID = 1L;

        public MyFile(File f) {
            super(f.getAbsolutePath());
        }

        public MyFile(File parent, String child) {
            super(parent, child);
        }

        @Override
        public boolean delete() {
            LOG.info((Object)("Trying to delete myFile " + this.getAbsolutePath()));
            boolean bool = false;
            bool = this.getName().equals(TestFileUtil.file1Name) ? false : super.delete();
            if (bool) {
                LOG.info((Object)("Deleted " + this.getAbsolutePath() + " successfully"));
            } else {
                LOG.info((Object)("Cannot delete " + this.getAbsolutePath()));
            }
            return bool;
        }

        @Override
        public File[] listFiles() {
            File[] files = super.listFiles();
            if (files == null) {
                return null;
            }
            List<File> filesList = Arrays.asList(files);
            Collections.sort(filesList);
            File[] myFiles = new MyFile[files.length];
            int i = 0;
            for (File f : filesList) {
                myFiles[i++] = new MyFile(f);
            }
            return myFiles;
        }
    }
}

