/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestFilterFileSystem {
    private static final Log LOG = FileSystem.LOG;
    private static final Configuration conf = new Configuration();

    @BeforeClass
    public static void setup() {
        conf.set("fs.flfs.impl", FilterLocalFileSystem.class.getName());
        conf.setBoolean("fs.flfs.impl.disable.cache", true);
        conf.setBoolean("fs.file.impl.disable.cache", true);
    }

    @Test
    public void testFilterFileSystem() throws Exception {
        for (Method m : FileSystem.class.getDeclaredMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || Modifier.isPrivate(m.getModifiers()) || Modifier.isFinal(m.getModifiers())) continue;
            try {
                DontCheck.class.getMethod(m.getName(), m.getParameterTypes());
                LOG.info((Object)("Skipping " + m));
            }
            catch (NoSuchMethodException exc) {
                LOG.info((Object)("Testing " + m));
                try {
                    FilterFileSystem.class.getDeclaredMethod(m.getName(), m.getParameterTypes());
                }
                catch (NoSuchMethodException exc2) {
                    LOG.error((Object)("FilterFileSystem doesn't implement " + m));
                    throw exc2;
                }
            }
        }
    }

    @Test
    public void testFilterEmbedInit() throws Exception {
        FileSystem mockFs = this.createMockFs(false);
        this.checkInit(new FilterFileSystem(mockFs), true);
    }

    @Test
    public void testFilterEmbedNoInit() throws Exception {
        FileSystem mockFs = this.createMockFs(true);
        this.checkInit(new FilterFileSystem(mockFs), false);
    }

    @Test
    public void testLocalEmbedInit() throws Exception {
        FileSystem mockFs = this.createMockFs(false);
        this.checkInit(new LocalFileSystem(mockFs), true);
    }

    @Test
    public void testLocalEmbedNoInit() throws Exception {
        FileSystem mockFs = this.createMockFs(true);
        this.checkInit(new LocalFileSystem(mockFs), false);
    }

    private FileSystem createMockFs(boolean useConf) {
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)mockFs.getUri()).thenReturn((Object)URI.create("mock:/"));
        Mockito.when((Object)mockFs.getConf()).thenReturn((Object)(useConf ? conf : null));
        return mockFs;
    }

    @Test
    public void testGetLocalFsSetsConfs() throws Exception {
        LocalFileSystem lfs = FileSystem.getLocal(conf);
        this.checkFsConf(lfs, conf, 2);
    }

    @Test
    public void testGetFilterLocalFsSetsConfs() throws Exception {
        FilterFileSystem flfs = (FilterFileSystem)FileSystem.get(URI.create("flfs:/"), conf);
        this.checkFsConf(flfs, conf, 3);
    }

    @Test
    public void testInitLocalFsSetsConfs() throws Exception {
        LocalFileSystem lfs = new LocalFileSystem();
        this.checkFsConf(lfs, null, 2);
        lfs.initialize(lfs.getUri(), conf);
        this.checkFsConf(lfs, conf, 2);
    }

    @Test
    public void testInitFilterFsSetsEmbedConf() throws Exception {
        LocalFileSystem lfs = new LocalFileSystem();
        this.checkFsConf(lfs, null, 2);
        FilterFileSystem ffs = new FilterFileSystem(lfs);
        Assert.assertEquals((Object)lfs, (Object)ffs.getRawFileSystem());
        this.checkFsConf(ffs, null, 3);
        ffs.initialize(URI.create("filter:/"), conf);
        this.checkFsConf(ffs, conf, 3);
    }

    @Test
    public void testInitFilterLocalFsSetsEmbedConf() throws Exception {
        FilterLocalFileSystem flfs = new FilterLocalFileSystem();
        Assert.assertEquals(LocalFileSystem.class, flfs.getRawFileSystem().getClass());
        this.checkFsConf(flfs, null, 3);
        flfs.initialize(URI.create("flfs:/"), conf);
        this.checkFsConf(flfs, conf, 3);
    }

    @Test
    public void testVerifyChecksumPassthru() {
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        FilterFileSystem fs = new FilterFileSystem(mockFs);
        ((FileSystem)fs).setVerifyChecksum(false);
        ((FileSystem)Mockito.verify((Object)mockFs)).setVerifyChecksum(Mockito.eq((boolean)false));
        Mockito.reset((Object[])new FileSystem[]{mockFs});
        ((FileSystem)fs).setVerifyChecksum(true);
        ((FileSystem)Mockito.verify((Object)mockFs)).setVerifyChecksum(Mockito.eq((boolean)true));
    }

    @Test
    public void testWriteChecksumPassthru() {
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        FilterFileSystem fs = new FilterFileSystem(mockFs);
        ((FileSystem)fs).setWriteChecksum(false);
        ((FileSystem)Mockito.verify((Object)mockFs)).setWriteChecksum(Mockito.eq((boolean)false));
        Mockito.reset((Object[])new FileSystem[]{mockFs});
        ((FileSystem)fs).setWriteChecksum(true);
        ((FileSystem)Mockito.verify((Object)mockFs)).setWriteChecksum(Mockito.eq((boolean)true));
    }

    private void checkInit(FilterFileSystem fs, boolean expectInit) throws Exception {
        URI uri = URI.create("filter:/");
        fs.initialize(uri, conf);
        FileSystem embedFs = fs.getRawFileSystem();
        if (expectInit) {
            ((FileSystem)Mockito.verify((Object)embedFs, (VerificationMode)Mockito.times((int)1))).initialize((URI)Mockito.eq((Object)uri), (Configuration)Mockito.eq((Object)conf));
        } else {
            ((FileSystem)Mockito.verify((Object)embedFs, (VerificationMode)Mockito.times((int)0))).initialize((URI)Mockito.any(URI.class), (Configuration)Mockito.any(Configuration.class));
        }
    }

    private void checkFsConf(FileSystem fs, Configuration conf, int expectDepth) {
        int depth = 0;
        while (true) {
            Assert.assertFalse((String)("depth " + ++depth + ">" + expectDepth), (depth > expectDepth ? 1 : 0) != 0);
            Assert.assertEquals((Object)conf, (Object)fs.getConf());
            if (!(fs instanceof FilterFileSystem)) break;
            fs = ((FilterFileSystem)fs).getRawFileSystem();
        }
        Assert.assertEquals((long)expectDepth, (long)depth);
    }

    private static class FilterLocalFileSystem
    extends FilterFileSystem {
        FilterLocalFileSystem() {
            super(new LocalFileSystem());
        }
    }

    public static class DontCheck {
        public BlockLocation[] getFileBlockLocations(Path p, long start, long len) {
            return null;
        }

        public FsServerDefaults getServerDefaults() {
            return null;
        }

        public long getLength(Path f) {
            return 0L;
        }

        public FSDataOutputStream append(Path f) {
            return null;
        }

        public FSDataOutputStream append(Path f, int bufferSize) {
            return null;
        }

        public void rename(Path src, Path dst, Options.Rename ... options) {
        }

        public boolean exists(Path f) {
            return false;
        }

        public boolean isDirectory(Path f) {
            return false;
        }

        public boolean isFile(Path f) {
            return false;
        }

        public boolean createNewFile(Path f) {
            return false;
        }

        public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return null;
        }

        public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return null;
        }

        public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return null;
        }

        public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
            return null;
        }

        public boolean mkdirs(Path f) {
            return false;
        }

        public FSDataInputStream open(Path f) {
            return null;
        }

        public FSDataOutputStream create(Path f) {
            return null;
        }

        public FSDataOutputStream create(Path f, boolean overwrite) {
            return null;
        }

        public FSDataOutputStream create(Path f, Progressable progress) {
            return null;
        }

        public FSDataOutputStream create(Path f, short replication) {
            return null;
        }

        public FSDataOutputStream create(Path f, short replication, Progressable progress) {
            return null;
        }

        public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) {
            return null;
        }

        public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) {
            return null;
        }

        public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) {
            return null;
        }

        public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) {
            return null;
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) {
            return null;
        }

        public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return null;
        }

        public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
            return null;
        }

        public String getName() {
            return null;
        }

        public boolean delete(Path f) {
            return false;
        }

        public short getReplication(Path src) {
            return 0;
        }

        public void processDeleteOnExit() {
        }

        public ContentSummary getContentSummary(Path f) {
            return null;
        }

        public FsStatus getStatus() {
            return null;
        }

        public FileStatus[] listStatus(Path f, PathFilter filter) {
            return null;
        }

        public FileStatus[] listStatus(Path[] files) {
            return null;
        }

        public FileStatus[] listStatus(Path[] files, PathFilter filter) {
            return null;
        }

        public FileStatus[] globStatus(Path pathPattern) {
            return null;
        }

        public FileStatus[] globStatus(Path pathPattern, PathFilter filter) {
            return null;
        }

        public Iterator<LocatedFileStatus> listFiles(Path path, boolean isRecursive) {
            return null;
        }

        public Iterator<LocatedFileStatus> listLocatedStatus(Path f) {
            return null;
        }

        public Iterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) {
            return null;
        }

        public void copyFromLocalFile(Path src, Path dst) {
        }

        public void moveFromLocalFile(Path[] srcs, Path dst) {
        }

        public void moveFromLocalFile(Path src, Path dst) {
        }

        public void copyToLocalFile(Path src, Path dst) {
        }

        public void copyToLocalFile(boolean delSrc, Path src, Path dst, boolean useRawLocalFileSystem) {
        }

        public void moveToLocalFile(Path src, Path dst) {
        }

        public long getBlockSize(Path f) {
            return 0L;
        }

        public FSDataOutputStream primitiveCreate(Path f, EnumSet<CreateFlag> createFlag, Options.CreateOpts ... opts) {
            return null;
        }

        public void primitiveMkdir(Path f, FsPermission absolutePermission, boolean createParent) {
        }

        public int getDefaultPort() {
            return 0;
        }

        public String getCanonicalServiceName() {
            return null;
        }

        public Token<?> getDelegationToken(String renewer) throws IOException {
            return null;
        }

        public boolean deleteOnExit(Path f) throws IOException {
            return false;
        }

        public boolean cancelDeleteOnExit(Path f) throws IOException {
            return false;
        }

        public Token<?>[] addDelegationTokens(String renewer, Credentials creds) throws IOException {
            return null;
        }

        public String getScheme() {
            return "dontcheck";
        }

        public Path fixRelativePart(Path p) {
            return null;
        }
    }
}

