/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystemTestWrapper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestSymlinkHdfs;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestSymlinkHdfsFileSystem
extends TestSymlinkHdfs {
    @BeforeClass
    public static void testSetup() throws Exception {
        wrapper = new FileSystemTestWrapper(dfs, "/tmp/TestSymlinkHdfsFileSystem");
    }

    @Override
    @Ignore(value="FileSystem adds missing authority in absolute URIs")
    @Test(timeout=1000L)
    public void testCreateWithPartQualPathFails() throws IOException {
    }

    @Override
    @Ignore(value="FileSystem#create creates parent directories, so dangling links to directories are created")
    @Test(timeout=1000L)
    public void testCreateFileViaDanglingLinkParent() throws IOException {
    }

    @Test(timeout=10000L)
    public void testRecoverLease() throws IOException {
        Path dir = new Path(this.testBaseDir1());
        Path file = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "link");
        wrapper.setWorkingDirectory(dir);
        TestSymlinkHdfsFileSystem.createAndWriteFile(file);
        wrapper.createSymlink(file, link, false);
        boolean closed = dfs.recoverLease(link);
        Assert.assertTrue((String)"Expected recoverLease to return true", (boolean)closed);
    }

    @Test(timeout=10000L)
    public void testIsFileClosed() throws IOException {
        Path dir = new Path(this.testBaseDir1());
        Path file = new Path(this.testBaseDir1(), "file");
        Path link = new Path(this.testBaseDir1(), "link");
        wrapper.setWorkingDirectory(dir);
        TestSymlinkHdfsFileSystem.createAndWriteFile(file);
        wrapper.createSymlink(file, link, false);
        boolean closed = dfs.isFileClosed(link);
        Assert.assertTrue((String)"Expected isFileClosed to return true", (boolean)closed);
    }

    @Test(timeout=10000L)
    public void testConcat() throws Exception {
        Path dir = new Path(this.testBaseDir1());
        Path link = new Path(this.testBaseDir1(), "link");
        Path dir2 = new Path(this.testBaseDir2());
        wrapper.createSymlink(dir2, link, false);
        wrapper.setWorkingDirectory(dir);
        Path target = new Path(link, "target");
        TestSymlinkHdfsFileSystem.createAndWriteFile(target);
        Path[] srcs = new Path[3];
        for (int i = 0; i < srcs.length; ++i) {
            srcs[i] = new Path(link, "src-" + i);
            TestSymlinkHdfsFileSystem.createAndWriteFile(srcs[i]);
        }
        dfs.concat(target, srcs);
    }

    @Test(timeout=10000L)
    public void testSnapshot() throws Exception {
        Path dir = new Path(this.testBaseDir1());
        Path link = new Path(this.testBaseDir1(), "link");
        Path dir2 = new Path(this.testBaseDir2());
        wrapper.createSymlink(dir2, link, false);
        wrapper.setWorkingDirectory(dir);
        dfs.allowSnapshot(link);
        dfs.disallowSnapshot(link);
        dfs.allowSnapshot(link);
        dfs.createSnapshot(link, "mcmillan");
        dfs.renameSnapshot(link, "mcmillan", "seaborg");
        dfs.deleteSnapshot(link, "seaborg");
    }
}

