/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.StringUtils;

public class SliveReducer
extends MapReduceBase
implements Reducer<Text, Text, Text, Text> {
    private static final Log LOG = LogFactory.getLog(SliveReducer.class);
    private ConfigExtractor config;

    private void logAndSetStatus(Reporter r, String msg) {
        r.setStatus(msg);
        LOG.info((Object)msg);
    }

    private ConfigExtractor getConfig() {
        return this.config;
    }

    @Override
    public void reduce(Text key, Iterator<Text> values, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        OperationOutput collector = null;
        int reduceAm = 0;
        int errorAm = 0;
        this.logAndSetStatus(reporter, "Iterating over reduction values for key " + key);
        while (values.hasNext()) {
            Text value = values.next();
            try {
                OperationOutput val = new OperationOutput(key, (Object)value);
                collector = collector == null ? val : OperationOutput.merge(collector, val);
                LOG.info((Object)("Combined " + val + " into/with " + collector));
                ++reduceAm;
            }
            catch (Exception e) {
                ++errorAm;
                this.logAndSetStatus(reporter, "Error iterating over reduction input " + value + " due to : " + StringUtils.stringifyException(e));
                if (!this.getConfig().shouldExitOnFirstError()) continue;
                break;
            }
        }
        this.logAndSetStatus(reporter, "Reduced " + reduceAm + " values with " + errorAm + " errors");
        if (collector != null) {
            this.logAndSetStatus(reporter, "Writing output " + collector.getKey() + " : " + collector.getOutputValue());
            output.collect(collector.getKey(), collector.getOutputValue());
        }
    }

    @Override
    public void configure(JobConf conf) {
        this.config = new ConfigExtractor(conf);
        ConfigExtractor.dumpOptions(this.config);
    }
}

