/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ChRootedFs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestChRootedFs {
    FileContextTestHelper fileContextTestHelper = new FileContextTestHelper();
    FileContext fc;
    FileContext fcTarget;
    Path chrootedTo;

    @Before
    public void setUp() throws Exception {
        this.fcTarget = FileContext.getLocalFSFileContext();
        this.chrootedTo = this.fileContextTestHelper.getAbsoluteTestRootPath(this.fcTarget);
        this.fcTarget.delete(this.chrootedTo, true);
        this.fcTarget.mkdir(this.chrootedTo, FileContext.DEFAULT_PERM, true);
        Configuration conf = new Configuration();
        this.fc = FileContext.getFileContext(new ChRootedFs(this.fcTarget.getDefaultFileSystem(), this.chrootedTo), conf);
    }

    @After
    public void tearDown() throws Exception {
        this.fcTarget.delete(this.chrootedTo, true);
    }

    @Test
    public void testBasicPaths() {
        URI uri = this.fc.getDefaultFileSystem().getUri();
        Assert.assertEquals((Object)this.chrootedTo.toUri(), (Object)uri);
        Assert.assertEquals((Object)this.fc.makeQualified(new Path(System.getProperty("user.home"))), (Object)this.fc.getWorkingDirectory());
        Assert.assertEquals((Object)this.fc.makeQualified(new Path(System.getProperty("user.home"))), (Object)this.fc.getHomeDirectory());
        Assert.assertEquals((Object)new Path("/foo/bar").makeQualified(FsConstants.LOCAL_FS_URI, null), (Object)this.fc.makeQualified(new Path("/foo/bar")));
    }

    @Test
    public void testCreateDelete() throws IOException {
        this.fileContextTestHelper.createFileNonRecursive(this.fc, "/foo");
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(this.fc, new Path("/foo")));
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.chrootedTo, "foo")));
        this.fileContextTestHelper.createFile(this.fc, "/newDir/foo");
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(this.fc, new Path("/newDir/foo")));
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.chrootedTo, "newDir/foo")));
        Assert.assertTrue((boolean)this.fc.delete(new Path("/newDir/foo"), false));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc, new Path("/newDir/foo")));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.chrootedTo, "newDir/foo")));
        this.fileContextTestHelper.createFile(this.fc, "/newDir/newDir2/foo");
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(this.fc, new Path("/newDir/newDir2/foo")));
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.chrootedTo, "newDir/newDir2/foo")));
        Assert.assertTrue((boolean)this.fc.delete(new Path("/newDir/newDir2/foo"), false));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc, new Path("/newDir/newDir2/foo")));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.chrootedTo, "newDir/newDir2/foo")));
    }

    @Test
    public void testMkdirDelete() throws IOException {
        this.fc.mkdir(this.fileContextTestHelper.getTestRootPath(this.fc, "/dirX"), FileContext.DEFAULT_PERM, false);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(this.fc, new Path("/dirX")));
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(this.fcTarget, new Path(this.chrootedTo, "dirX")));
        this.fc.mkdir(this.fileContextTestHelper.getTestRootPath(this.fc, "/dirX/dirY"), FileContext.DEFAULT_PERM, false);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(this.fc, new Path("/dirX/dirY")));
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(this.fcTarget, new Path(this.chrootedTo, "dirX/dirY")));
        Assert.assertTrue((boolean)this.fc.delete(new Path("/dirX/dirY"), false));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc, new Path("/dirX/dirY")));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.chrootedTo, "dirX/dirY")));
        Assert.assertTrue((boolean)this.fc.delete(new Path("/dirX"), false));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc, new Path("/dirX")));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.chrootedTo, "dirX")));
    }

    @Test
    public void testRename() throws IOException {
        this.fileContextTestHelper.createFile(this.fc, "/newDir/foo");
        this.fc.rename(new Path("/newDir/foo"), new Path("/newDir/fooBar"), new Options.Rename[0]);
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc, new Path("/newDir/foo")));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.chrootedTo, "newDir/foo")));
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(this.fc, this.fileContextTestHelper.getTestRootPath(this.fc, "/newDir/fooBar")));
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.chrootedTo, "newDir/fooBar")));
        this.fc.mkdir(new Path("/newDir/dirFoo"), FileContext.DEFAULT_PERM, false);
        this.fc.rename(new Path("/newDir/dirFoo"), new Path("/newDir/dirFooBar"), new Options.Rename[0]);
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fc, new Path("/newDir/dirFoo")));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.chrootedTo, "newDir/dirFoo")));
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(this.fc, this.fileContextTestHelper.getTestRootPath(this.fc, "/newDir/dirFooBar")));
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(this.fcTarget, new Path(this.chrootedTo, "newDir/dirFooBar")));
    }

    @Test
    public void testRenameAcrossFs() throws IOException {
        this.fc.mkdir(new Path("/newDir/dirFoo"), FileContext.DEFAULT_PERM, true);
        this.fc.rename(new Path("/newDir/dirFoo"), new Path("file:///dirFooBar"), new Options.Rename[0]);
        FileContextTestHelper.isDir(this.fc, new Path("/dirFooBar"));
    }

    @Test
    public void testList() throws IOException {
        FileStatus fs = this.fc.getFileStatus(new Path("/"));
        Assert.assertTrue((boolean)fs.isDirectory());
        Assert.assertEquals((Object)fs.getPath(), (Object)this.chrootedTo);
        FileStatus[] dirPaths = this.fc.util().listStatus(new Path("/"));
        Assert.assertEquals((long)0L, (long)dirPaths.length);
        this.fileContextTestHelper.createFileNonRecursive(this.fc, "/foo");
        this.fileContextTestHelper.createFileNonRecursive(this.fc, "/bar");
        this.fc.mkdir(new Path("/dirX"), FileContext.DEFAULT_PERM, false);
        this.fc.mkdir(this.fileContextTestHelper.getTestRootPath(this.fc, "/dirY"), FileContext.DEFAULT_PERM, false);
        this.fc.mkdir(new Path("/dirX/dirXX"), FileContext.DEFAULT_PERM, false);
        dirPaths = this.fc.util().listStatus(new Path("/"));
        Assert.assertEquals((long)4L, (long)dirPaths.length);
        fs = this.fileContextTestHelper.containsPath(this.fcTarget, "foo", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((boolean)fs.isFile());
        fs = this.fileContextTestHelper.containsPath(this.fcTarget, "bar", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((boolean)fs.isFile());
        fs = this.fileContextTestHelper.containsPath(this.fcTarget, "dirX", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((boolean)fs.isDirectory());
        fs = this.fileContextTestHelper.containsPath(this.fcTarget, "dirY", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((boolean)fs.isDirectory());
    }

    @Test
    public void testWorkingDirectory() throws Exception {
        this.fc.mkdir(new Path("/testWd"), FileContext.DEFAULT_PERM, false);
        Path workDir = new Path("/testWd");
        Path fqWd = this.fc.makeQualified(workDir);
        this.fc.setWorkingDirectory(workDir);
        Assert.assertEquals((Object)fqWd, (Object)this.fc.getWorkingDirectory());
        this.fc.setWorkingDirectory(new Path("."));
        Assert.assertEquals((Object)fqWd, (Object)this.fc.getWorkingDirectory());
        this.fc.setWorkingDirectory(new Path(".."));
        Assert.assertEquals((Object)fqWd.getParent(), (Object)this.fc.getWorkingDirectory());
        workDir = new Path("/testWd");
        fqWd = this.fc.makeQualified(workDir);
        this.fc.setWorkingDirectory(workDir);
        Assert.assertEquals((Object)fqWd, (Object)this.fc.getWorkingDirectory());
        Path relativeDir = new Path("existingDir1");
        Path absoluteDir = new Path(workDir, "existingDir1");
        this.fc.mkdir(absoluteDir, FileContext.DEFAULT_PERM, true);
        Path fqAbsoluteDir = this.fc.makeQualified(absoluteDir);
        this.fc.setWorkingDirectory(relativeDir);
        Assert.assertEquals((Object)fqAbsoluteDir, (Object)this.fc.getWorkingDirectory());
        absoluteDir = new Path("/test/existingDir2");
        fqAbsoluteDir = this.fc.makeQualified(absoluteDir);
        this.fc.mkdir(absoluteDir, FileContext.DEFAULT_PERM, true);
        this.fc.setWorkingDirectory(absoluteDir);
        Assert.assertEquals((Object)fqAbsoluteDir, (Object)this.fc.getWorkingDirectory());
        Path absolutePath = new Path(absoluteDir, "foo");
        this.fc.create(absolutePath, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]).close();
        this.fc.open(new Path("foo")).close();
        this.fc.mkdir(new Path("newDir"), FileContext.DEFAULT_PERM, true);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir(this.fc, new Path(absoluteDir, "newDir")));
        absoluteDir = this.fileContextTestHelper.getTestRootPath(this.fc, "nonexistingPath");
        try {
            this.fc.setWorkingDirectory(absoluteDir);
            Assert.fail((String)"cd to non existing dir should have failed");
        }
        catch (Exception e) {
            // empty catch block
        }
        String LOCAL_FS_ROOT_URI = "file:///tmp/test";
        absoluteDir = new Path("file:///tmp/test/existingDir");
        this.fc.mkdir(absoluteDir, FileContext.DEFAULT_PERM, true);
        this.fc.setWorkingDirectory(absoluteDir);
        Assert.assertEquals((Object)absoluteDir, (Object)this.fc.getWorkingDirectory());
    }

    @Test
    public void testResolvePath() throws IOException {
        Assert.assertEquals((Object)this.chrootedTo, (Object)this.fc.getDefaultFileSystem().resolvePath(new Path("/")));
        this.fileContextTestHelper.createFile(this.fc, "/foo");
        Assert.assertEquals((Object)new Path(this.chrootedTo, "foo"), (Object)this.fc.getDefaultFileSystem().resolvePath(new Path("/foo")));
    }

    @Test(expected=FileNotFoundException.class)
    public void testResolvePathNonExisting() throws IOException {
        this.fc.getDefaultFileSystem().resolvePath(new Path("/nonExisting"));
    }

    @Test
    public void testIsValidNameValidInBaseFs() throws Exception {
        AbstractFileSystem baseFs = (AbstractFileSystem)Mockito.spy((Object)this.fc.getDefaultFileSystem());
        ChRootedFs chRootedFs = new ChRootedFs(baseFs, new Path("/chroot"));
        ((AbstractFileSystem)Mockito.doReturn((Object)true).when((Object)baseFs)).isValidName(Mockito.anyString());
        Assert.assertTrue((boolean)chRootedFs.isValidName("/test"));
        ((AbstractFileSystem)Mockito.verify((Object)baseFs)).isValidName("/chroot/test");
    }

    @Test
    public void testIsValidNameInvalidInBaseFs() throws Exception {
        AbstractFileSystem baseFs = (AbstractFileSystem)Mockito.spy((Object)this.fc.getDefaultFileSystem());
        ChRootedFs chRootedFs = new ChRootedFs(baseFs, new Path("/chroot"));
        ((AbstractFileSystem)Mockito.doReturn((Object)false).when((Object)baseFs)).isValidName(Mockito.anyString());
        Assert.assertFalse((boolean)chRootedFs.isValidName("/test"));
        ((AbstractFileSystem)Mockito.verify((Object)baseFs)).isValidName("/chroot/test");
    }
}

