/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.util.Shell;
import org.mortbay.log.Log;

public class ViewFsTestSetup {
    public static String ViewFSTestDir = "/testDir";

    public static FileContext setupForViewFsLocalFs(FileContextTestHelper helper) throws Exception {
        FileContext fsTarget = FileContext.getLocalFSFileContext();
        Path targetOfTests = helper.getTestRootPath(fsTarget);
        fsTarget.delete(targetOfTests, true);
        fsTarget.mkdir(targetOfTests, FileContext.DEFAULT_PERM, true);
        Configuration conf = new Configuration();
        String testDir = helper.getTestRootPath(fsTarget).toUri().getPath();
        ViewFsTestSetup.linkUpFirstComponents(conf, testDir, fsTarget, "test dir");
        ViewFsTestSetup.setUpHomeDir(conf, fsTarget);
        String wdDir = fsTarget.getWorkingDirectory().toUri().getPath();
        ViewFsTestSetup.linkUpFirstComponents(conf, wdDir, fsTarget, "working dir");
        FileContext fc = FileContext.getFileContext(FsConstants.VIEWFS_URI, conf);
        fc.setWorkingDirectory(new Path(wdDir));
        Log.info((String)("Working dir is: " + fc.getWorkingDirectory()));
        return fc;
    }

    public static void tearDownForViewFsLocalFs(FileContextTestHelper helper) throws Exception {
        FileContext fclocal = FileContext.getLocalFSFileContext();
        Path targetOfTests = helper.getTestRootPath(fclocal);
        fclocal.delete(targetOfTests, true);
    }

    static void setUpHomeDir(Configuration conf, FileContext fsTarget) {
        String homeDir = fsTarget.getHomeDirectory().toUri().getPath();
        int indexOf2ndSlash = homeDir.indexOf(47, 1);
        if (indexOf2ndSlash > 0) {
            ViewFsTestSetup.linkUpFirstComponents(conf, homeDir, fsTarget, "home dir");
        } else {
            URI linkTarget = fsTarget.makeQualified(new Path(homeDir)).toUri();
            ConfigUtil.addLink(conf, homeDir, linkTarget);
            Log.info((String)("Added link for home dir " + homeDir + "->" + linkTarget));
        }
        String homeDirRoot = fsTarget.getHomeDirectory().getParent().toUri().getPath();
        ConfigUtil.setHomeDirConf(conf, homeDirRoot);
        Log.info((String)("Home dir base for viewfs" + homeDirRoot));
    }

    static void linkUpFirstComponents(Configuration conf, String path, FileContext fsTarget, String info) {
        int indexOfEnd = path.indexOf(47, 1);
        if (Shell.WINDOWS) {
            indexOfEnd = path.indexOf(47, indexOfEnd + 1);
        }
        String firstComponent = path.substring(0, indexOfEnd);
        URI linkTarget = fsTarget.makeQualified(new Path(firstComponent)).toUri();
        ConfigUtil.addLink(conf, firstComponent, linkTarget);
        Log.info((String)("Added link for " + info + " " + firstComponent + "->" + linkTarget));
    }
}

