/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.test.PathUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDecommission {
    public static final Log LOG = LogFactory.getLog(TestDecommission.class);
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    static final int fileSize = 16384;
    static final int HEARTBEAT_INTERVAL = 1;
    static final int BLOCKREPORT_INTERVAL_MSEC = 1000;
    static final int NAMENODE_REPLICATION_INTERVAL = 1;
    final Random myrand = new Random();
    Path hostsFile;
    Path excludeFile;
    FileSystem localFileSys;
    Configuration conf;
    MiniDFSCluster cluster = null;

    @Before
    public void setup() throws IOException {
        this.conf = new HdfsConfiguration();
        this.localFileSys = FileSystem.getLocal(this.conf);
        Path workingDir = this.localFileSys.getWorkingDirectory();
        Path dir = new Path(workingDir, PathUtils.getTestDirName(this.getClass()) + "/work-dir/decommission");
        this.hostsFile = new Path(dir, "hosts");
        this.excludeFile = new Path(dir, "exclude");
        this.conf.setBoolean("dfs.namenode.replication.considerLoad", false);
        this.conf.set("dfs.hosts", this.hostsFile.toUri().getPath());
        this.conf.set("dfs.hosts.exclude", this.excludeFile.toUri().getPath());
        this.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 2000);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.blockreport.intervalMsec", 1000);
        this.conf.setInt("dfs.namenode.replication.pending.timeout-sec", 4);
        this.conf.setInt("dfs.namenode.replication.interval", 1);
        this.writeConfigFile(this.hostsFile, null);
        this.writeConfigFile(this.excludeFile, null);
    }

    @After
    public void teardown() throws IOException {
        this.cleanupFile(this.localFileSys, this.excludeFile.getParent());
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private void writeConfigFile(Path name, ArrayList<String> nodes) throws IOException {
        if (this.localFileSys.exists(name)) {
            this.localFileSys.delete(name, true);
        }
        FSDataOutputStream stm = this.localFileSys.create(name);
        if (nodes != null) {
            for (String node : nodes) {
                stm.writeBytes(node);
                stm.writeBytes("\n");
            }
        }
        stm.close();
    }

    private void writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 8192L);
        byte[] buffer = new byte[16384];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
        LOG.info((Object)("Created file " + name + " with " + repl + " replicas."));
    }

    private String checkFile(FileSystem fileSys, Path name, int repl, String downnode, int numDatanodes) throws IOException {
        boolean isNodeDown = downnode != null;
        Assert.assertTrue((String)("Not HDFS:" + fileSys.getUri()), (boolean)(fileSys instanceof DistributedFileSystem));
        HdfsDataInputStream dis = (HdfsDataInputStream)((DistributedFileSystem)fileSys).open(name);
        List<LocatedBlock> dinfo = dis.getAllBlocks();
        for (LocatedBlock blk : dinfo) {
            int hasdown = 0;
            DatanodeInfo[] nodes = blk.getLocations();
            for (int j = 0; j < nodes.length; ++j) {
                if (isNodeDown && nodes[j].getXferAddr().equals(downnode)) {
                    ++hasdown;
                    if (!nodes[j].isDecommissioned()) {
                        return "For block " + blk.getBlock() + " replica on " + nodes[j] + " is given as downnode, " + "but is not decommissioned";
                    }
                    if (j != nodes.length - 1) {
                        return "For block " + blk.getBlock() + " decommissioned node " + nodes[j] + " was not last node in list: " + (j + 1) + " of " + nodes.length;
                    }
                    LOG.info((Object)("Block " + blk.getBlock() + " replica on " + nodes[j] + " is decommissioned."));
                    continue;
                }
                if (!nodes[j].isDecommissioned()) continue;
                return "For block " + blk.getBlock() + " replica on " + nodes[j] + " is unexpectedly decommissioned";
            }
            LOG.info((Object)("Block " + blk.getBlock() + " has " + hasdown + " decommissioned replica."));
            if (Math.min(numDatanodes, repl + hasdown) == nodes.length) continue;
            return "Wrong number of replicas for block " + blk.getBlock() + ": " + nodes.length + ", expected " + Math.min(numDatanodes, repl + hasdown);
        }
        return null;
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assert.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        Assert.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    private DatanodeInfo decommissionNode(int nnIndex, ArrayList<DatanodeInfo> decommissionedNodes, DatanodeInfo.AdminStates waitForState) throws IOException {
        DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(nnIndex), this.conf);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        int index = 0;
        boolean found = false;
        while (!found) {
            index = this.myrand.nextInt(info.length);
            if (info[index].isDecommissioned()) continue;
            found = true;
        }
        String nodename = info[index].getXferAddr();
        LOG.info((Object)("Decommissioning node: " + nodename));
        ArrayList<String> nodes = new ArrayList<String>();
        if (decommissionedNodes != null) {
            for (DatanodeInfo dn : decommissionedNodes) {
                nodes.add(dn.getName());
            }
        }
        nodes.add(nodename);
        this.writeConfigFile(this.excludeFile, nodes);
        TestDecommission.refreshNodes(this.cluster.getNamesystem(nnIndex), this.conf);
        DatanodeDescriptor ret = NameNodeAdapter.getDatanode(this.cluster.getNamesystem(nnIndex), info[index]);
        this.waitNodeState(ret, waitForState);
        return ret;
    }

    private void recomissionNode(DatanodeInfo decommissionedNode) throws IOException {
        LOG.info((Object)("Recommissioning node: " + decommissionedNode));
        this.writeConfigFile(this.excludeFile, null);
        TestDecommission.refreshNodes(this.cluster.getNamesystem(), this.conf);
        this.waitNodeState(decommissionedNode, DatanodeInfo.AdminStates.NORMAL);
    }

    private void waitNodeState(DatanodeInfo node, DatanodeInfo.AdminStates state) {
        boolean done;
        boolean bl = done = state == node.getAdminState();
        while (!done) {
            LOG.info((Object)("Waiting for node " + node + " to change state to " + (Object)((Object)state) + " current state: " + (Object)((Object)node.getAdminState())));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            done = state == node.getAdminState();
        }
        LOG.info((Object)("node " + node + " reached the state " + (Object)((Object)state)));
    }

    private static DFSClient getDfsClient(NameNode nn, Configuration conf) throws IOException {
        return new DFSClient(nn.getNameNodeAddress(), conf);
    }

    private static void validateCluster(DFSClient client, int numDNs) throws IOException {
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        Assert.assertEquals((String)"Number of Datanodes ", (long)numDNs, (long)info.length);
    }

    private void startCluster(int numNameNodes, int numDatanodes, Configuration conf) throws IOException {
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(numNameNodes)).numDataNodes(numDatanodes).build();
        this.cluster.waitActive();
        for (int i = 0; i < numNameNodes; ++i) {
            DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(i), conf);
            TestDecommission.validateCluster(client, numDatanodes);
        }
    }

    static void refreshNodes(FSNamesystem ns, Configuration conf) throws IOException {
        ns.getBlockManager().getDatanodeManager().refreshNodes(conf);
    }

    private void verifyStats(NameNode namenode, FSNamesystem fsn, DatanodeInfo node, boolean decommissioning) throws InterruptedException, IOException {
        for (int i = 0; i < 10; ++i) {
            long[] newStats = namenode.getRpcServer().getStats();
            Assert.assertEquals((long)newStats[0], (long)(decommissioning ? node.getDfsUsed() : node.getCapacity()));
            Assert.assertEquals((long)newStats[1], (long)node.getDfsUsed());
            Assert.assertEquals((long)newStats[2], (long)(decommissioning ? 0L : node.getRemaining()));
            Assert.assertEquals((long)fsn.getTotalLoad(), (long)node.getXceiverCount());
            Thread.sleep(1000L);
        }
    }

    @Test(timeout=360000L)
    public void testDecommission() throws IOException {
        this.testDecommission(1, 6);
    }

    @Test(timeout=360000L)
    public void testDecommission2() throws IOException {
        LOG.info((Object)"Starting test testDecommission");
        int numNamenodes = 1;
        int numDatanodes = 4;
        this.conf.setInt("dfs.replication", 3);
        this.startCluster(numNamenodes, numDatanodes, this.conf);
        ArrayList namenodeDecomList = new ArrayList(numNamenodes);
        namenodeDecomList.add(0, new ArrayList(numDatanodes));
        Path file1 = new Path("testDecommission2.dat");
        int replicas = 4;
        ArrayList decommissionedNodes = (ArrayList)namenodeDecomList.get(0);
        DistributedFileSystem fileSys = this.cluster.getFileSystem(0);
        FSNamesystem ns = this.cluster.getNamesystem(0);
        this.writeFile(fileSys, file1, replicas);
        int deadDecomissioned = ns.getNumDecomDeadDataNodes();
        int liveDecomissioned = ns.getNumDecomLiveDataNodes();
        DatanodeInfo decomNode = this.decommissionNode(0, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSIONED);
        decommissionedNodes.add(decomNode);
        Assert.assertEquals((long)deadDecomissioned, (long)ns.getNumDecomDeadDataNodes());
        Assert.assertEquals((long)(liveDecomissioned + 1), (long)ns.getNumDecomLiveDataNodes());
        DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(0), this.conf);
        Assert.assertEquals((String)"All datanodes must be alive", (long)numDatanodes, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
        Assert.assertNull((Object)this.checkFile(fileSys, file1, replicas, decomNode.getXferAddr(), numDatanodes));
        this.cleanupFile(fileSys, file1);
        this.cluster.shutdown();
        this.startCluster(1, 4, this.conf);
        this.cluster.shutdown();
    }

    @Test(timeout=360000L)
    public void testRecommission() throws IOException {
        this.testRecommission(1, 6);
    }

    @Test(timeout=360000L)
    public void testDecommissionFederation() throws IOException {
        this.testDecommission(2, 2);
    }

    private void testDecommission(int numNamenodes, int numDatanodes) throws IOException {
        LOG.info((Object)"Starting test testDecommission");
        this.startCluster(numNamenodes, numDatanodes, this.conf);
        ArrayList namenodeDecomList = new ArrayList(numNamenodes);
        for (int i = 0; i < numNamenodes; ++i) {
            namenodeDecomList.add(i, new ArrayList(numDatanodes));
        }
        Path file1 = new Path("testDecommission.dat");
        for (int iteration = 0; iteration < numDatanodes - 1; ++iteration) {
            int replicas = numDatanodes - iteration - 1;
            for (int i = 0; i < numNamenodes; ++i) {
                ArrayList decommissionedNodes = (ArrayList)namenodeDecomList.get(i);
                DistributedFileSystem fileSys = this.cluster.getFileSystem(i);
                FSNamesystem ns = this.cluster.getNamesystem(i);
                this.writeFile(fileSys, file1, replicas);
                int deadDecomissioned = ns.getNumDecomDeadDataNodes();
                int liveDecomissioned = ns.getNumDecomLiveDataNodes();
                DatanodeInfo decomNode = this.decommissionNode(i, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSIONED);
                decommissionedNodes.add(decomNode);
                Assert.assertEquals((long)deadDecomissioned, (long)ns.getNumDecomDeadDataNodes());
                Assert.assertEquals((long)(liveDecomissioned + 1), (long)ns.getNumDecomLiveDataNodes());
                DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(i), this.conf);
                Assert.assertEquals((String)"All datanodes must be alive", (long)numDatanodes, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
                int tries = 0;
                while (tries++ < 20) {
                    try {
                        Thread.sleep(1000L);
                        if (this.checkFile(fileSys, file1, replicas, decomNode.getXferAddr(), numDatanodes) != null) continue;
                        break;
                    }
                    catch (InterruptedException ie) {
                    }
                }
                Assert.assertTrue((String)("Checked if block was replicated after decommission, tried " + tries + " times."), (tries < 20 ? 1 : 0) != 0);
                this.cleanupFile(fileSys, file1);
            }
        }
        this.cluster.shutdown();
        this.startCluster(numNamenodes, numDatanodes, this.conf);
        this.cluster.shutdown();
    }

    private void testRecommission(int numNamenodes, int numDatanodes) throws IOException {
        LOG.info((Object)"Starting test testRecommission");
        this.startCluster(numNamenodes, numDatanodes, this.conf);
        ArrayList namenodeDecomList = new ArrayList(numNamenodes);
        for (int i = 0; i < numNamenodes; ++i) {
            namenodeDecomList.add(i, new ArrayList(numDatanodes));
        }
        Path file1 = new Path("testDecommission.dat");
        int replicas = numDatanodes - 1;
        for (int i = 0; i < numNamenodes; ++i) {
            ArrayList decommissionedNodes = (ArrayList)namenodeDecomList.get(i);
            DistributedFileSystem fileSys = this.cluster.getFileSystem(i);
            this.writeFile(fileSys, file1, replicas);
            DatanodeInfo decomNode = this.decommissionNode(i, decommissionedNodes, DatanodeInfo.AdminStates.DECOMMISSIONED);
            decommissionedNodes.add(decomNode);
            DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(i), this.conf);
            Assert.assertEquals((String)"All datanodes must be alive", (long)numDatanodes, (long)client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE).length);
            int tries = 0;
            while (tries++ < 20) {
                try {
                    Thread.sleep(1000L);
                    if (this.checkFile(fileSys, file1, replicas, decomNode.getXferAddr(), numDatanodes) != null) continue;
                    break;
                }
                catch (InterruptedException ie) {
                }
            }
            Assert.assertTrue((String)("Checked if block was replicated after decommission, tried " + tries + " times."), (tries < 20 ? 1 : 0) != 0);
            this.recomissionNode(decomNode);
            tries = 0;
            while (tries++ < 20) {
                try {
                    Thread.sleep(1000L);
                    if (this.checkFile(fileSys, file1, replicas, null, numDatanodes) != null) continue;
                    break;
                }
                catch (InterruptedException ie) {
                }
            }
            this.cleanupFile(fileSys, file1);
            Assert.assertTrue((String)("Checked if node was recommissioned " + tries + " times."), (tries < 20 ? 1 : 0) != 0);
            LOG.info((Object)("tried: " + tries + " times before recommissioned"));
        }
        this.cluster.shutdown();
    }

    @Test(timeout=360000L)
    public void testClusterStats() throws Exception {
        this.testClusterStats(1);
    }

    @Test(timeout=360000L)
    public void testClusterStatsFederation() throws Exception {
        this.testClusterStats(3);
    }

    public void testClusterStats(int numNameNodes) throws IOException, InterruptedException {
        LOG.info((Object)"Starting test testClusterStats");
        int numDatanodes = 1;
        this.startCluster(numNameNodes, numDatanodes, this.conf);
        for (int i = 0; i < numNameNodes; ++i) {
            DistributedFileSystem fileSys = this.cluster.getFileSystem(i);
            Path file = new Path("testClusterStats.dat");
            this.writeFile(fileSys, file, 1);
            FSNamesystem fsn = this.cluster.getNamesystem(i);
            NameNode namenode = this.cluster.getNameNode(i);
            DatanodeInfo downnode = this.decommissionNode(i, null, DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS);
            this.verifyStats(namenode, fsn, downnode, true);
            this.writeConfigFile(this.excludeFile, null);
            TestDecommission.refreshNodes(fsn, this.conf);
            DatanodeDescriptor ret = NameNodeAdapter.getDatanode(fsn, downnode);
            this.waitNodeState(ret, DatanodeInfo.AdminStates.NORMAL);
            this.verifyStats(namenode, fsn, ret, false);
        }
    }

    @Test(timeout=360000L)
    public void testHostsFile() throws IOException, InterruptedException {
        this.testHostsFile(1);
    }

    @Test(timeout=360000L)
    public void testHostsFileFederation() throws IOException, InterruptedException {
        this.testHostsFile(3);
    }

    public void testHostsFile(int numNameNodes) throws IOException, InterruptedException {
        int numDatanodes = 1;
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(numNameNodes)).numDataNodes(numDatanodes).setupHostsFile(true).build();
        this.cluster.waitActive();
        ArrayList<String> list = new ArrayList<String>();
        String bogusIp = "127.0.30.1";
        list.add("127.0.30.1");
        this.writeConfigFile(this.hostsFile, list);
        for (int j = 0; j < numNameNodes; ++j) {
            TestDecommission.refreshNodes(this.cluster.getNamesystem(j), this.conf);
            DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(j), this.conf);
            DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            for (int i = 0; i < 5 && info.length != 0; ++i) {
                LOG.info((Object)"Waiting for datanode to be marked dead");
                Thread.sleep(1000L);
                info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            }
            Assert.assertEquals((String)"Number of live nodes should be 0", (long)0L, (long)info.length);
            info = client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD);
            Assert.assertEquals((String)"There should be 2 dead nodes", (long)2L, (long)info.length);
            DatanodeID id = this.cluster.getDataNodes().get(0).getDatanodeId();
            Assert.assertEquals((Object)id.getHostName(), (Object)info[0].getHostName());
            Assert.assertEquals((Object)"127.0.30.1", (Object)info[1].getHostName());
        }
    }

    @Test(timeout=360000L)
    public void testDuplicateHostsEntries() throws IOException, InterruptedException {
        Configuration hdfsConf = new Configuration(this.conf);
        this.cluster = new MiniDFSCluster.Builder(hdfsConf).numDataNodes(1).setupHostsFile(true).build();
        this.cluster.waitActive();
        int dnPort = this.cluster.getDataNodes().get(0).getXferPort();
        Random random = new Random(System.currentTimeMillis());
        int port1 = dnPort;
        while (port1 == dnPort) {
            port1 = random.nextInt(6000) + 1000;
        }
        int port2 = dnPort;
        while (port2 == dnPort || port2 == port1) {
            port2 = random.nextInt(6000) + 1000;
        }
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.add("127.0.0.1:" + port1);
        nodes.add("localhost:" + port1);
        nodes.add("127.0.0.1:" + port1);
        nodes.add("127.0.0.1:" + port2);
        nodes.add("127.0.30.1:" + port1);
        this.writeConfigFile(this.hostsFile, nodes);
        TestDecommission.refreshNodes(this.cluster.getNamesystem(0), hdfsConf);
        DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(0), hdfsConf);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        for (int i = 0; i < 5 && info.length != 0; ++i) {
            LOG.info((Object)"Waiting for datanode to be marked dead");
            Thread.sleep(1000L);
            info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        }
        Assert.assertEquals((String)"Number of live nodes should be 0", (long)0L, (long)info.length);
        DatanodeInfo[] deadDns = client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD);
        HashMap<String, DatanodeInfo> deadByXferAddr = new HashMap<String, DatanodeInfo>();
        for (DatanodeInfo dn : deadDns) {
            LOG.info((Object)("DEAD DatanodeInfo: xferAddr = " + dn.getXferAddr() + ", ipAddr = " + dn.getIpAddr() + ", hostname = " + dn.getHostName()));
            deadByXferAddr.put(dn.getXferAddr(), dn);
        }
        String realDnIpPort = this.cluster.getDataNodes().get(0).getXferAddress().getAddress().getHostAddress() + ":" + this.cluster.getDataNodes().get(0).getXferPort();
        Assert.assertNotNull((String)("failed to find real datanode IP " + realDnIpPort), deadByXferAddr.remove(realDnIpPort));
        Assert.assertNotNull(deadByXferAddr.remove("127.0.30.1:" + port1));
        Iterator iter = deadByXferAddr.entrySet().iterator();
        boolean foundPort1 = false;
        boolean foundPort2 = false;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            DatanodeInfo dn = (DatanodeInfo)entry.getValue();
            if (dn.getXferPort() == port1) {
                foundPort1 = true;
                iter.remove();
                continue;
            }
            if (dn.getXferPort() != port2) continue;
            foundPort2 = true;
            iter.remove();
        }
        Assert.assertTrue((String)("did not find a dead entry with port " + port1), (boolean)foundPort1);
        Assert.assertTrue((String)("did not find a dead entry with port " + port2), (boolean)foundPort2);
        Assert.assertTrue((boolean)deadByXferAddr.isEmpty());
    }

    @Test(timeout=360000L)
    public void testIncludeByRegistrationName() throws IOException, InterruptedException {
        DatanodeInfo[] info;
        DatanodeInfo[] info2;
        Configuration hdfsConf = new Configuration(this.conf);
        String registrationName = "--registration-name--";
        String nonExistentDn = "127.0.0.40";
        hdfsConf.set("dfs.datanode.hostname", "--registration-name--");
        this.cluster = new MiniDFSCluster.Builder(hdfsConf).numDataNodes(1).checkDataNodeHostConfig(true).setupHostsFile(true).build();
        this.cluster.waitActive();
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.add("127.0.0.40");
        this.writeConfigFile(this.hostsFile, nodes);
        TestDecommission.refreshNodes(this.cluster.getNamesystem(0), hdfsConf);
        DFSClient client = TestDecommission.getDfsClient(this.cluster.getNameNode(0), hdfsConf);
        while ((info2 = client.datanodeReport(HdfsConstants.DatanodeReportType.DEAD)).length != 1) {
            LOG.info((Object)"Waiting for datanode to be marked dead");
            Thread.sleep(1000L);
        }
        int dnPort = this.cluster.getDataNodes().get(0).getXferPort();
        nodes = new ArrayList();
        nodes.add("--registration-name--:" + dnPort);
        this.writeConfigFile(this.hostsFile, nodes);
        TestDecommission.refreshNodes(this.cluster.getNamesystem(0), hdfsConf);
        this.cluster.restartDataNode(0);
        while (true) {
            if ((info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE)).length == 1) break;
            LOG.info((Object)"Waiting for datanode to come back");
            Thread.sleep(1000L);
        }
        Assert.assertFalse((boolean)info[0].isDecommissioned());
        Assert.assertFalse((boolean)info[0].isDecommissionInProgress());
        Assert.assertEquals((Object)"--registration-name--", (Object)info[0].getHostName());
    }

    @Test(timeout=120000L)
    public void testDecommissionWithOpenfile() throws IOException, InterruptedException {
        LOG.info((Object)"Starting test testDecommissionWithOpenfile");
        this.startCluster(1, 7, this.conf);
        DistributedFileSystem fileSys = this.cluster.getFileSystem(0);
        FSNamesystem ns = this.cluster.getNamesystem(0);
        String openFile = "/testDecommissionWithOpenfile.dat";
        this.writeFile(fileSys, new Path(openFile), 3);
        FSDataOutputStream fdos = fileSys.append(new Path(openFile));
        LocatedBlocks lbs = NameNodeAdapter.getBlockLocations(this.cluster.getNameNode(0), openFile, 0L, 16384L);
        DatanodeInfo[] dnInfos4LastBlock = lbs.getLastLocatedBlock().getLocations();
        DatanodeInfo[] dnInfos4FirstBlock = lbs.get(0).getLocations();
        ArrayList<String> nodes = new ArrayList<String>();
        ArrayList<DatanodeInfo> dnInfos = new ArrayList<DatanodeInfo>();
        DatanodeInfo[] arr$ = dnInfos4FirstBlock;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            DatanodeInfo datanodeInfo;
            DatanodeInfo found = datanodeInfo = arr$[i$];
            for (DatanodeInfo dif : dnInfos4LastBlock) {
                if (!datanodeInfo.equals(dif)) continue;
                found = null;
            }
            if (found == null) continue;
            nodes.add(found.getXferAddr());
            dnInfos.add(found);
        }
        nodes.add(dnInfos4LastBlock[0].getXferAddr());
        dnInfos.add(dnInfos4LastBlock[0]);
        this.writeConfigFile(this.excludeFile, nodes);
        TestDecommission.refreshNodes(ns, this.conf);
        for (DatanodeInfo dn : dnInfos) {
            this.waitNodeState(dn, DatanodeInfo.AdminStates.DECOMMISSIONED);
        }
        fdos.close();
    }
}

