/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultNameNodePort {
    @Test
    public void testGetAddressFromString() throws Exception {
        Assert.assertEquals((long)NameNode.getAddress("foo").getPort(), (long)8020L);
        Assert.assertEquals((long)NameNode.getAddress("hdfs://foo/").getPort(), (long)8020L);
        Assert.assertEquals((long)NameNode.getAddress("hdfs://foo:555").getPort(), (long)555L);
        Assert.assertEquals((long)NameNode.getAddress("foo:555").getPort(), (long)555L);
    }

    @Test
    public void testGetAddressFromConf() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        FileSystem.setDefaultUri((Configuration)conf, "hdfs://foo/");
        Assert.assertEquals((long)NameNode.getAddress(conf).getPort(), (long)8020L);
        FileSystem.setDefaultUri((Configuration)conf, "hdfs://foo:555/");
        Assert.assertEquals((long)NameNode.getAddress(conf).getPort(), (long)555L);
        FileSystem.setDefaultUri((Configuration)conf, "foo");
        Assert.assertEquals((long)NameNode.getAddress(conf).getPort(), (long)8020L);
    }

    @Test
    public void testGetUri() {
        Assert.assertEquals((Object)NameNode.getUri(new InetSocketAddress("foo", 555)), (Object)URI.create("hdfs://foo:555"));
        Assert.assertEquals((Object)NameNode.getUri(new InetSocketAddress("foo", 8020)), (Object)URI.create("hdfs://foo"));
    }
}

