/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.test.PathUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestFileCorruption {
    static Log LOG = (Log4JLogger)NameNode.stateChangeLog;

    public TestFileCorruption() {
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCorruption() throws Exception {
        MiniDFSCluster cluster = null;
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFileCorruption").setNumFiles(20).build();
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            util.createFiles(fs, "/srcdat");
            File storageDir = cluster.getInstanceStorageDir(2, 0);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
            Assert.assertTrue((String)"data directory does not exist", (boolean)data_dir.exists());
            File[] blocks = data_dir.listFiles();
            Assert.assertTrue((String)"Blocks do not exist in data-dir", (blocks != null && blocks.length > 0 ? 1 : 0) != 0);
            for (int idx = 0; idx < blocks.length; ++idx) {
                if (!blocks[idx].getName().startsWith("blk_")) continue;
                System.out.println("Deliberately removing file " + blocks[idx].getName());
                Assert.assertTrue((String)"Cannot remove file.", (boolean)blocks[idx].delete());
            }
            Assert.assertTrue((String)"Corrupted replicas not handled properly.", (boolean)util.checkFiles(fs, "/srcdat"));
            util.cleanup(fs, "/srcdat");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testLocalFileCorruption() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        Path file = new Path(PathUtils.getTestDirName(this.getClass()), "corruptFile");
        LocalFileSystem fs = FileSystem.getLocal(conf);
        DataOutputStream dos = fs.create(file);
        dos.writeBytes("original bytes");
        dos.close();
        dos = new DataOutputStream(new FileOutputStream(file.toString()));
        dos.writeBytes("corruption");
        dos.close();
        FSDataInputStream dis = ((FileSystem)fs).open(file, 512);
        try {
            System.out.println("A ChecksumException is expected to be logged.");
            dis.readByte();
        }
        catch (ChecksumException ignore) {
            // empty catch block
        }
        ((FileSystem)fs).delete(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrayOutOfBoundsException() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path FILE_PATH = new Path("/tmp.txt");
            long FILE_LEN = 1L;
            DFSTestUtil.createFile(fs, FILE_PATH, 1L, (short)2, 1L);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            File storageDir = cluster.getInstanceStorageDir(0, 0);
            File dataDir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
            ExtendedBlock blk = this.getBlock(bpid, dataDir);
            if (blk == null) {
                storageDir = cluster.getInstanceStorageDir(0, 1);
                dataDir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                blk = this.getBlock(bpid, dataDir);
            }
            Assert.assertFalse((blk == null ? 1 : 0) != 0);
            cluster.startDataNodes(conf, 1, true, null, null);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)3L);
            DataNode dataNode = datanodes.get(2);
            DatanodeRegistration dnR = DataNodeTestUtils.getDNRegistrationForBP(dataNode, blk.getBlockPoolId());
            FSNamesystem ns = cluster.getNamesystem();
            ns.writeLock();
            try {
                cluster.getNamesystem().getBlockManager().findAndMarkBlockAsCorrupt(blk, new DatanodeInfo(dnR), "TEST", "STORAGE_ID");
            }
            finally {
                ns.writeUnlock();
            }
            fs.open(FILE_PATH);
            ((FileSystem)fs).delete(FILE_PATH, false);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private ExtendedBlock getBlock(String bpid, File dataDir) {
        int idx;
        Assert.assertTrue((String)"data directory does not exist", (boolean)dataDir.exists());
        File[] blocks = dataDir.listFiles();
        Assert.assertTrue((String)"Blocks do not exist in dataDir", (blocks != null && blocks.length > 0 ? 1 : 0) != 0);
        String blockFileName = null;
        for (idx = 0; idx < blocks.length && (!(blockFileName = blocks[idx].getName()).startsWith("blk_") || blockFileName.endsWith(".meta")); ++idx) {
        }
        if (blockFileName == null) {
            return null;
        }
        long blockId = Long.parseLong(blockFileName.substring("blk_".length()));
        long blockTimeStamp = 0L;
        for (idx = 0; idx < blocks.length; ++idx) {
            String fileName = blocks[idx].getName();
            if (!fileName.startsWith(blockFileName) || !fileName.endsWith(".meta")) continue;
            int startIndex = blockFileName.length() + 1;
            int endIndex = fileName.length() - ".meta".length();
            blockTimeStamp = Long.parseLong(fileName.substring(startIndex, endIndex));
            break;
        }
        return new ExtendedBlock(bpid, blockId, blocks[idx].length(), blockTimeStamp);
    }
}

