/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.web.HftpFileSystem;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFileStatus {
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    static final int fileSize = 16384;
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static FileSystem fs;
    private static FileContext fc;
    private static HftpFileSystem hftpfs;
    private static DFSClient dfsClient;
    private static Path file1;

    public TestFileStatus() {
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)FileSystem.LOG).getLogger().setLevel(Level.ALL);
    }

    @BeforeClass
    public static void testSetUp() throws Exception {
        conf = new HdfsConfiguration();
        conf.setInt("dfs.ls.limit", 2);
        cluster = new MiniDFSCluster.Builder(conf).build();
        fs = cluster.getFileSystem();
        fc = FileContext.getFileContext(cluster.getURI(0), conf);
        hftpfs = cluster.getHftpFileSystem(0);
        dfsClient = new DFSClient(NameNode.getAddress(conf), conf);
        file1 = new Path("filestatus.dat");
        TestFileStatus.writeFile(fs, file1, 1, 16384, 8192);
    }

    @AfterClass
    public static void testTearDown() throws Exception {
        fs.close();
        cluster.shutdown();
    }

    private static void writeFile(FileSystem fileSys, Path name, int repl, int fileSize, int blockSize) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, HdfsConstants.IO_FILE_BUFFER_SIZE, (short)repl, blockSize);
        byte[] buffer = new byte[fileSize];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    private void checkFile(FileSystem fileSys, Path name, int repl) throws IOException, InterruptedException, TimeoutException {
        DFSTestUtil.waitReplication(fileSys, name, (short)repl);
    }

    @Test
    public void testGetFileInfo() throws IOException {
        Path path = new Path("/");
        Assert.assertTrue((String)"/ should be a directory", (boolean)fs.getFileStatus(path).isDirectory());
        HdfsFileStatus fileInfo = dfsClient.getFileInfo("/noSuchFile");
        Assert.assertEquals((String)"Non-existant file should result in null", null, (Object)fileInfo);
        Path path1 = new Path("/name1");
        Path path2 = new Path("/name1/name2");
        Assert.assertTrue((boolean)fs.mkdirs(path1));
        FSDataOutputStream out = fs.create(path2, false);
        out.close();
        fileInfo = dfsClient.getFileInfo(path1.toString());
        Assert.assertEquals((long)1L, (long)fileInfo.getChildrenNum());
        fileInfo = dfsClient.getFileInfo(path2.toString());
        Assert.assertEquals((long)0L, (long)fileInfo.getChildrenNum());
        try {
            dfsClient.getFileInfo("non-absolute");
            Assert.fail((String)"getFileInfo for a non-absolute path did not throw IOException");
        }
        catch (RemoteException re) {
            Assert.assertTrue((String)"Wrong exception for invalid file name", (boolean)re.toString().contains("Invalid file name"));
        }
    }

    @Test
    public void testGetFileStatusOnFile() throws Exception {
        this.checkFile(fs, file1, 1);
        FileStatus status = fs.getFileStatus(file1);
        Assert.assertFalse((String)(file1 + " should be a file"), (boolean)status.isDirectory());
        Assert.assertEquals((long)8192L, (long)status.getBlockSize());
        Assert.assertEquals((long)1L, (long)status.getReplication());
        Assert.assertEquals((long)16384L, (long)status.getLen());
        Assert.assertEquals((Object)file1.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString(), (Object)status.getPath().toString());
    }

    @Test
    public void testListStatusOnFile() throws IOException {
        FileStatus[] stats = fs.listStatus(file1);
        Assert.assertEquals((long)1L, (long)stats.length);
        FileStatus status = stats[0];
        Assert.assertFalse((String)(file1 + " should be a file"), (boolean)status.isDirectory());
        Assert.assertEquals((long)8192L, (long)status.getBlockSize());
        Assert.assertEquals((long)1L, (long)status.getReplication());
        Assert.assertEquals((long)16384L, (long)status.getLen());
        Assert.assertEquals((Object)file1.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString(), (Object)status.getPath().toString());
        RemoteIterator<FileStatus> itor = fc.listStatus(file1);
        status = itor.next();
        Assert.assertEquals((Object)stats[0], (Object)status);
        Assert.assertFalse((String)(file1 + " should be a file"), (boolean)status.isDirectory());
    }

    @Test
    public void testGetFileStatusOnNonExistantFileDir() throws IOException {
        Path dir = new Path("/test/mkdirs");
        try {
            fs.listStatus(dir);
            Assert.fail((String)"listStatus of non-existent path should fail");
        }
        catch (FileNotFoundException fe) {
            Assert.assertEquals((Object)("File " + dir + " does not exist."), (Object)fe.getMessage());
        }
        try {
            fc.listStatus(dir);
            Assert.fail((String)"listStatus of non-existent path should fail");
        }
        catch (FileNotFoundException fe) {
            Assert.assertEquals((Object)("File " + dir + " does not exist."), (Object)fe.getMessage());
        }
        try {
            fs.getFileStatus(dir);
            Assert.fail((String)"getFileStatus of non-existent path should fail");
        }
        catch (FileNotFoundException fe) {
            Assert.assertTrue((String)"Exception doesn't indicate non-existant path", (boolean)fe.getMessage().startsWith("File does not exist"));
        }
    }

    @Test
    public void testGetFileStatusOnDir() throws Exception {
        Path dir = new Path("/test/mkdirs");
        Assert.assertTrue((String)"mkdir failed", (boolean)fs.mkdirs(dir));
        Assert.assertTrue((String)"mkdir failed", (boolean)fs.exists(dir));
        FileStatus status = fs.getFileStatus(dir);
        Assert.assertTrue((String)(dir + " should be a directory"), (boolean)status.isDirectory());
        Assert.assertTrue((String)(dir + " should be zero size "), (status.getLen() == 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)dir.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString(), (Object)status.getPath().toString());
        FileStatus[] stats = fs.listStatus(dir);
        Assert.assertEquals((String)(dir + " should be empty"), (long)0L, (long)stats.length);
        Assert.assertEquals((String)(dir + " should be zero size "), (long)0L, (long)fs.getContentSummary(dir).getLength());
        Assert.assertEquals((String)(dir + " should be zero size using hftp"), (long)0L, (long)hftpfs.getContentSummary(dir).getLength());
        RemoteIterator<FileStatus> itor = fc.listStatus(dir);
        Assert.assertFalse((String)(dir + " should be empty"), (boolean)itor.hasNext());
        Path file2 = new Path(dir, "filestatus2.dat");
        TestFileStatus.writeFile(fs, file2, 1, 2048, 8192);
        this.checkFile(fs, file2, 1);
        status = fs.getFileStatus(file2);
        Assert.assertEquals((long)8192L, (long)status.getBlockSize());
        Assert.assertEquals((long)1L, (long)status.getReplication());
        file2 = fs.makeQualified(file2);
        Assert.assertEquals((Object)file2.toString(), (Object)status.getPath().toString());
        Path file3 = new Path(dir, "filestatus3.dat");
        TestFileStatus.writeFile(fs, file3, 1, 2048, 8192);
        this.checkFile(fs, file3, 1);
        file3 = fs.makeQualified(file3);
        int expected = 4096;
        Assert.assertEquals((String)(dir + " size should be " + 4096), (long)4096L, (long)fs.getContentSummary(dir).getLength());
        Assert.assertEquals((String)(dir + " size should be " + 4096 + " using hftp"), (long)4096L, (long)hftpfs.getContentSummary(dir).getLength());
        stats = fs.listStatus(dir);
        Assert.assertEquals((String)(dir + " should have two entries"), (long)2L, (long)stats.length);
        Assert.assertEquals((Object)file2.toString(), (Object)stats[0].getPath().toString());
        Assert.assertEquals((Object)file3.toString(), (Object)stats[1].getPath().toString());
        itor = fc.listStatus(dir);
        Assert.assertEquals((Object)file2.toString(), (Object)itor.next().getPath().toString());
        Assert.assertEquals((Object)file3.toString(), (Object)itor.next().getPath().toString());
        Assert.assertFalse((String)"Unexpected addtional file", (boolean)itor.hasNext());
        Path dir3 = fs.makeQualified(new Path(dir, "dir3"));
        fs.mkdirs(dir3);
        dir3 = fs.makeQualified(dir3);
        stats = fs.listStatus(dir);
        Assert.assertEquals((String)(dir + " should have three entries"), (long)3L, (long)stats.length);
        Assert.assertEquals((Object)dir3.toString(), (Object)stats[0].getPath().toString());
        Assert.assertEquals((Object)file2.toString(), (Object)stats[1].getPath().toString());
        Assert.assertEquals((Object)file3.toString(), (Object)stats[2].getPath().toString());
        itor = fc.listStatus(dir);
        Assert.assertEquals((Object)dir3.toString(), (Object)itor.next().getPath().toString());
        Assert.assertEquals((Object)file2.toString(), (Object)itor.next().getPath().toString());
        Assert.assertEquals((Object)file3.toString(), (Object)itor.next().getPath().toString());
        Assert.assertFalse((String)"Unexpected addtional file", (boolean)itor.hasNext());
        Path dir4 = fs.makeQualified(new Path(dir, "dir4"));
        fs.mkdirs(dir4);
        dir4 = fs.makeQualified(dir4);
        Path dir5 = fs.makeQualified(new Path(dir, "dir5"));
        fs.mkdirs(dir5);
        dir5 = fs.makeQualified(dir5);
        stats = fs.listStatus(dir);
        Assert.assertEquals((String)(dir + " should have five entries"), (long)5L, (long)stats.length);
        Assert.assertEquals((Object)dir3.toString(), (Object)stats[0].getPath().toString());
        Assert.assertEquals((Object)dir4.toString(), (Object)stats[1].getPath().toString());
        Assert.assertEquals((Object)dir5.toString(), (Object)stats[2].getPath().toString());
        Assert.assertEquals((Object)file2.toString(), (Object)stats[3].getPath().toString());
        Assert.assertEquals((Object)file3.toString(), (Object)stats[4].getPath().toString());
        itor = fc.listStatus(dir);
        Assert.assertEquals((Object)dir3.toString(), (Object)itor.next().getPath().toString());
        Assert.assertEquals((Object)dir4.toString(), (Object)itor.next().getPath().toString());
        Assert.assertEquals((Object)dir5.toString(), (Object)itor.next().getPath().toString());
        Assert.assertEquals((Object)file2.toString(), (Object)itor.next().getPath().toString());
        Assert.assertEquals((Object)file3.toString(), (Object)itor.next().getPath().toString());
        Assert.assertFalse((boolean)itor.hasNext());
        fs.setPermission(dir, new FsPermission(0));
        try {
            String username = UserGroupInformation.getCurrentUser().getShortUserName() + "1";
            HftpFileSystem hftp2 = cluster.getHftpFileSystemAs(username, conf, 0, "somegroup");
            hftp2.getContentSummary(dir);
            Assert.fail();
        }
        catch (IOException ioe) {
            FileSystem.LOG.info((Object)"GOOD: getting an exception", (Throwable)ioe);
        }
        fs.delete(dir, true);
    }
}

