/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.http.HttpConfig;
import org.junit.Assert;
import org.junit.Test;

public final class TestHttpPolicy {
    @Test(expected=HadoopIllegalArgumentException.class)
    public void testInvalidPolicyValue() {
        Configuration conf = new Configuration();
        conf.set("dfs.http.policy", "invalid");
        DFSUtil.getHttpPolicy(conf);
    }

    @Test
    public void testDeprecatedConfiguration() {
        Configuration conf = new Configuration(false);
        Assert.assertSame((Object)((Object)HttpConfig.Policy.HTTP_ONLY), (Object)((Object)DFSUtil.getHttpPolicy(conf)));
        conf.setBoolean("dfs.https.enable", true);
        Assert.assertSame((Object)((Object)HttpConfig.Policy.HTTP_AND_HTTPS), (Object)((Object)DFSUtil.getHttpPolicy(conf)));
        conf = new Configuration(false);
        conf.setBoolean("hadoop.ssl.enabled", true);
        Assert.assertSame((Object)((Object)HttpConfig.Policy.HTTP_AND_HTTPS), (Object)((Object)DFSUtil.getHttpPolicy(conf)));
        conf = new Configuration(false);
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTP_ONLY.name());
        conf.setBoolean("dfs.https.enable", true);
        Assert.assertSame((Object)((Object)HttpConfig.Policy.HTTP_ONLY), (Object)((Object)DFSUtil.getHttpPolicy(conf)));
    }
}

