/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.client;

import java.util.TreeMap;
import java.util.concurrent.TimeoutException;
import org.apache.flink.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.flink.hadoop.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.hadoop.shaded.com.google.common.util.concurrent.SettableFuture;
import org.apache.hadoop.hdfs.qjournal.client.QuorumCall;
import org.junit.Assert;
import org.junit.Test;

public class TestQuorumCall {
    @Test(timeout=10000L)
    public void testQuorums() throws Exception {
        ImmutableMap futures = ImmutableMap.of("f1", SettableFuture.create(), "f2", SettableFuture.create(), "f3", SettableFuture.create());
        QuorumCall q = QuorumCall.create(futures);
        Assert.assertEquals((long)0L, (long)q.countResponses());
        ((SettableFuture)futures.get("f1")).set("first future");
        q.waitFor(1, 0, 0, 100000, "test");
        q.waitFor(0, 1, 0, 100000, "test");
        Assert.assertEquals((long)1L, (long)q.countResponses());
        ((SettableFuture)futures.get("f2")).setException(new Exception("error"));
        Assert.assertEquals((long)2L, (long)q.countResponses());
        ((SettableFuture)futures.get("f3")).set("second future");
        q.waitFor(3, 0, 100, 100000, "test");
        q.waitFor(0, 2, 100, 100000, "test");
        Assert.assertEquals((long)3L, (long)q.countResponses());
        Assert.assertEquals((Object)"f1=first future,f3=second future", (Object)Joiner.on(",").withKeyValueSeparator("=").join(new TreeMap(q.getResults())));
        try {
            q.waitFor(0, 4, 100, 10, "test");
            Assert.fail((String)"Didn't time out waiting for more responses than came back");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }
}

