/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.IOException;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.flink.hadoop.shaded.com.google.common.base.Strings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TestJspHelper {
    private final Configuration conf = new HdfsConfiguration();
    private String jspWriterOutput = "";

    @Test
    public void testGetUgi() throws IOException {
        this.conf.set("fs.defaultFS", "hdfs://localhost:4321/");
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        String user = "TheDoctor";
        Text userText = new Text(user);
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(userText, userText, null);
        Token<DelegationTokenIdentifier> token = new Token<DelegationTokenIdentifier>(dtId, new DummySecretManager(0L, 0L, 0L, 0L));
        String tokenString = token.encodeToUrlString();
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)user);
        Mockito.when((Object)request.getParameter("nnaddr")).thenReturn((Object)"1.1.1.1:1111");
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration(this.conf);
        this.verifyServiceInToken(context, request, "1.1.1.1:1111");
        Mockito.when((Object)request.getParameter("nnaddr")).thenReturn(null);
        InetSocketAddress addr = new InetSocketAddress("localhost", 2222);
        Mockito.when((Object)context.getAttribute("name.node.address")).thenReturn((Object)addr);
        this.verifyServiceInToken(context, request, addr.getAddress().getHostAddress() + ":2222");
        token.setService(new Text("3.3.3.3:3333"));
        tokenString = token.encodeToUrlString();
        Mockito.when((Object)context.getAttribute("name.node.address")).thenReturn(null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        this.verifyServiceInToken(context, request, "3.3.3.3:3333");
    }

    private void verifyServiceInToken(ServletContext context, HttpServletRequest request, String expected) throws IOException {
        UserGroupInformation ugi = JspHelper.getUGI(context, request, this.conf);
        Token<? extends TokenIdentifier> tokenInUgi = ugi.getTokens().iterator().next();
        junit.framework.Assert.assertEquals((String)expected, (String)tokenInUgi.getService().toString());
    }

    @Test
    public void testDelegationTokenUrlParam() {
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration(this.conf);
        String tokenString = "xyzabc";
        String delegationTokenParam = JspHelper.getDelegationTokenUrlParam(tokenString);
        junit.framework.Assert.assertEquals((String)"&delegation=xyzabc", (String)delegationTokenParam);
        this.conf.set("hadoop.security.authentication", "simple");
        UserGroupInformation.setConfiguration(this.conf);
        delegationTokenParam = JspHelper.getDelegationTokenUrlParam(tokenString);
        junit.framework.Assert.assertEquals((String)"", (String)delegationTokenParam);
    }

    @Test
    public void testGetUgiFromToken() throws IOException {
        this.conf.set("fs.defaultFS", "hdfs://localhost:4321/");
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        String realUser = "TheDoctor";
        String user = "TheNurse";
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration(this.conf);
        Text ownerText = new Text(user);
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(ownerText, ownerText, new Text(realUser));
        Token<DelegationTokenIdentifier> token = new Token<DelegationTokenIdentifier>(dtId, new DummySecretManager(0L, 0L, 0L, 0L));
        String tokenString = token.encodeToUrlString();
        HttpServletRequest request = this.getMockRequest(null, null, null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        UserGroupInformation ugi = JspHelper.getUGI(context, request, this.conf);
        junit.framework.Assert.assertNotNull((Object)ugi.getRealUser());
        junit.framework.Assert.assertEquals((String)ugi.getRealUser().getShortUserName(), (String)realUser);
        junit.framework.Assert.assertEquals((String)ugi.getShortUserName(), (String)user);
        this.checkUgiFromToken(ugi);
        request = this.getMockRequest(realUser, null, null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        ugi = JspHelper.getUGI(context, request, this.conf);
        junit.framework.Assert.assertNotNull((Object)ugi.getRealUser());
        junit.framework.Assert.assertEquals((String)ugi.getRealUser().getShortUserName(), (String)realUser);
        junit.framework.Assert.assertEquals((String)ugi.getShortUserName(), (String)user);
        this.checkUgiFromToken(ugi);
        request = this.getMockRequest("rogue", null, null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        ugi = JspHelper.getUGI(context, request, this.conf);
        junit.framework.Assert.assertNotNull((Object)ugi.getRealUser());
        junit.framework.Assert.assertEquals((String)ugi.getRealUser().getShortUserName(), (String)realUser);
        junit.framework.Assert.assertEquals((String)ugi.getShortUserName(), (String)user);
        this.checkUgiFromToken(ugi);
        request = this.getMockRequest(null, user, null);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        ugi = JspHelper.getUGI(context, request, this.conf);
        junit.framework.Assert.assertNotNull((Object)ugi.getRealUser());
        junit.framework.Assert.assertEquals((String)ugi.getRealUser().getShortUserName(), (String)realUser);
        junit.framework.Assert.assertEquals((String)ugi.getShortUserName(), (String)user);
        this.checkUgiFromToken(ugi);
        request = this.getMockRequest(null, null, "rogue");
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        try {
            JspHelper.getUGI(context, request, this.conf);
            junit.framework.Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            junit.framework.Assert.assertEquals((String)("Usernames not matched: name=rogue != expected=" + user), (String)ioe.getMessage());
        }
        request = this.getMockRequest(null, user, "rogue");
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        try {
            JspHelper.getUGI(context, request, this.conf);
            junit.framework.Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            junit.framework.Assert.assertEquals((String)("Usernames not matched: name=rogue != expected=" + user), (String)ioe.getMessage());
        }
    }

    @Test
    public void testGetNonProxyUgi() throws IOException {
        this.conf.set("fs.defaultFS", "hdfs://localhost:4321/");
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        String realUser = "TheDoctor";
        String user = "TheNurse";
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration(this.conf);
        HttpServletRequest request = this.getMockRequest(null, null, null);
        try {
            JspHelper.getUGI(context, request, this.conf);
            junit.framework.Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            junit.framework.Assert.assertEquals((String)"Security enabled but user not authenticated by filter", (String)ioe.getMessage());
        }
        request = this.getMockRequest(null, realUser, null);
        try {
            JspHelper.getUGI(context, request, this.conf);
            junit.framework.Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            junit.framework.Assert.assertEquals((String)"Security enabled but user not authenticated by filter", (String)ioe.getMessage());
        }
        request = this.getMockRequest(realUser, null, null);
        UserGroupInformation ugi = JspHelper.getUGI(context, request, this.conf);
        junit.framework.Assert.assertNull((Object)ugi.getRealUser());
        junit.framework.Assert.assertEquals((String)ugi.getShortUserName(), (String)realUser);
        this.checkUgiFromAuth(ugi);
        request = this.getMockRequest(realUser, realUser, null);
        ugi = JspHelper.getUGI(context, request, this.conf);
        junit.framework.Assert.assertNull((Object)ugi.getRealUser());
        junit.framework.Assert.assertEquals((String)ugi.getShortUserName(), (String)realUser);
        this.checkUgiFromAuth(ugi);
        request = this.getMockRequest(realUser, user, null);
        try {
            JspHelper.getUGI(context, request, this.conf);
            junit.framework.Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            junit.framework.Assert.assertEquals((String)("Usernames not matched: name=" + user + " != expected=" + realUser), (String)ioe.getMessage());
        }
    }

    @Test
    public void testGetProxyUgi() throws IOException {
        this.conf.set("fs.defaultFS", "hdfs://localhost:4321/");
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        String realUser = "TheDoctor";
        String user = "TheNurse";
        this.conf.set("hadoop.security.authentication", "kerberos");
        this.conf.set("hadoop.proxyuser." + realUser + ".groups", "*");
        this.conf.set("hadoop.proxyuser." + realUser + ".hosts", "*");
        ProxyUsers.refreshSuperUserGroupsConfiguration(this.conf);
        UserGroupInformation.setConfiguration(this.conf);
        HttpServletRequest request = this.getMockRequest(null, null, user);
        try {
            JspHelper.getUGI(context, request, this.conf);
            junit.framework.Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            junit.framework.Assert.assertEquals((String)"Security enabled but user not authenticated by filter", (String)ioe.getMessage());
        }
        request = this.getMockRequest(null, realUser, user);
        try {
            JspHelper.getUGI(context, request, this.conf);
            junit.framework.Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            junit.framework.Assert.assertEquals((String)"Security enabled but user not authenticated by filter", (String)ioe.getMessage());
        }
        request = this.getMockRequest(realUser, null, user);
        UserGroupInformation ugi = JspHelper.getUGI(context, request, this.conf);
        junit.framework.Assert.assertNotNull((Object)ugi.getRealUser());
        junit.framework.Assert.assertEquals((String)ugi.getRealUser().getShortUserName(), (String)realUser);
        junit.framework.Assert.assertEquals((String)ugi.getShortUserName(), (String)user);
        this.checkUgiFromAuth(ugi);
        request = this.getMockRequest(realUser, realUser, user);
        ugi = JspHelper.getUGI(context, request, this.conf);
        junit.framework.Assert.assertNotNull((Object)ugi.getRealUser());
        junit.framework.Assert.assertEquals((String)ugi.getRealUser().getShortUserName(), (String)realUser);
        junit.framework.Assert.assertEquals((String)ugi.getShortUserName(), (String)user);
        this.checkUgiFromAuth(ugi);
        request = this.getMockRequest(realUser, user, user);
        try {
            JspHelper.getUGI(context, request, this.conf);
            junit.framework.Assert.fail((String)"bad request allowed");
        }
        catch (IOException ioe) {
            junit.framework.Assert.assertEquals((String)("Usernames not matched: name=" + user + " != expected=" + realUser), (String)ioe.getMessage());
        }
        try {
            request = this.getMockRequest(user, null, realUser);
            JspHelper.getUGI(context, request, this.conf);
            junit.framework.Assert.fail((String)"bad proxy request allowed");
        }
        catch (AuthorizationException ae) {
            junit.framework.Assert.assertEquals((String)("User: " + user + " is not allowed to impersonate " + realUser), (String)ae.getMessage());
        }
        try {
            request = this.getMockRequest(user, user, realUser);
            JspHelper.getUGI(context, request, this.conf);
            junit.framework.Assert.fail((String)"bad proxy request allowed");
        }
        catch (AuthorizationException ae) {
            junit.framework.Assert.assertEquals((String)("User: " + user + " is not allowed to impersonate " + realUser), (String)ae.getMessage());
        }
    }

    @Test
    public void testPrintGotoFormWritesValidXML() throws IOException, ParserConfigurationException, SAXException {
        JspWriter mockJspWriter = (JspWriter)Mockito.mock(JspWriter.class);
        ArgumentCaptor arg = ArgumentCaptor.forClass(String.class);
        ((JspWriter)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invok) {
                Object[] args = invok.getArguments();
                TestJspHelper.this.jspWriterOutput = TestJspHelper.this.jspWriterOutput + (String)args[0];
                return null;
            }
        }).when((Object)mockJspWriter)).print((String)arg.capture());
        this.jspWriterOutput = "";
        JspHelper.printGotoForm(mockJspWriter, 424242, "a token string", "foobar/file", "0.0.0.0");
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(this.jspWriterOutput));
        parser.parse(is);
    }

    private HttpServletRequest getMockRequest(String remoteUser, String user, String doAs) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getParameter("user.name")).thenReturn((Object)user);
        if (doAs != null) {
            Mockito.when((Object)request.getParameter("doas")).thenReturn((Object)doAs);
        }
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)remoteUser);
        return request;
    }

    private void checkUgiFromAuth(UserGroupInformation ugi) {
        if (ugi.getRealUser() != null) {
            junit.framework.Assert.assertEquals((Object)((Object)UserGroupInformation.AuthenticationMethod.PROXY), (Object)((Object)ugi.getAuthenticationMethod()));
            junit.framework.Assert.assertEquals((Object)((Object)UserGroupInformation.AuthenticationMethod.KERBEROS_SSL), (Object)((Object)ugi.getRealUser().getAuthenticationMethod()));
        } else {
            junit.framework.Assert.assertEquals((Object)((Object)UserGroupInformation.AuthenticationMethod.KERBEROS_SSL), (Object)((Object)ugi.getAuthenticationMethod()));
        }
    }

    private void checkUgiFromToken(UserGroupInformation ugi) {
        if (ugi.getRealUser() != null) {
            junit.framework.Assert.assertEquals((Object)((Object)UserGroupInformation.AuthenticationMethod.PROXY), (Object)((Object)ugi.getAuthenticationMethod()));
            junit.framework.Assert.assertEquals((Object)((Object)UserGroupInformation.AuthenticationMethod.TOKEN), (Object)((Object)ugi.getRealUser().getAuthenticationMethod()));
        } else {
            junit.framework.Assert.assertEquals((Object)((Object)UserGroupInformation.AuthenticationMethod.TOKEN), (Object)((Object)ugi.getAuthenticationMethod()));
        }
    }

    @Test
    public void testSortNodeByFields() throws Exception {
        DatanodeID dnId1 = new DatanodeID("127.0.0.1", "localhost1", "datanode1", 1234, 2345, 3456, 4567);
        DatanodeID dnId2 = new DatanodeID("127.0.0.2", "localhost2", "datanode2", 1235, 2346, 3457, 4568);
        DatanodeDescriptor dnDesc1 = new DatanodeDescriptor(dnId1, "rack1");
        DatanodeDescriptor dnDesc2 = new DatanodeDescriptor(dnId2, "rack2");
        BlockManagerTestUtil.updateStorage(dnDesc1, new DatanodeStorage("dnStorage1"));
        BlockManagerTestUtil.updateStorage(dnDesc2, new DatanodeStorage("dnStorage2"));
        DatanodeStorage dns1 = new DatanodeStorage("dnStorage1");
        DatanodeStorage dns2 = new DatanodeStorage("dnStorage2");
        StorageReport[] report1 = new StorageReport[]{new StorageReport(dns1, false, 1024L, 100L, 924L, 100L)};
        StorageReport[] report2 = new StorageReport[]{new StorageReport(dns2, false, 2500L, 200L, 1848L, 200L)};
        dnDesc1.updateHeartbeat(report1, 5L, 3L, 10, 2);
        dnDesc2.updateHeartbeat(report2, 10L, 2L, 20, 1);
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        live.add(dnDesc1);
        live.add(dnDesc2);
        JspHelper.sortNodeList(live, "unexists", "ASC");
        junit.framework.Assert.assertEquals((Object)dnDesc1, (Object)live.get(0));
        junit.framework.Assert.assertEquals((Object)dnDesc2, (Object)live.get(1));
        JspHelper.sortNodeList(live, "unexists", "DSC");
        junit.framework.Assert.assertEquals((Object)dnDesc2, (Object)live.get(0));
        junit.framework.Assert.assertEquals((Object)dnDesc1, (Object)live.get(1));
        JspHelper.sortNodeList(live, "capacity", "ASC");
        junit.framework.Assert.assertEquals((Object)dnDesc1, (Object)live.get(0));
        junit.framework.Assert.assertEquals((Object)dnDesc2, (Object)live.get(1));
        JspHelper.sortNodeList(live, "capacity", "DSC");
        junit.framework.Assert.assertEquals((Object)dnDesc2, (Object)live.get(0));
        junit.framework.Assert.assertEquals((Object)dnDesc1, (Object)live.get(1));
        JspHelper.sortNodeList(live, "used", "ASC");
        junit.framework.Assert.assertEquals((Object)dnDesc1, (Object)live.get(0));
        junit.framework.Assert.assertEquals((Object)dnDesc2, (Object)live.get(1));
        JspHelper.sortNodeList(live, "used", "DSC");
        junit.framework.Assert.assertEquals((Object)dnDesc2, (Object)live.get(0));
        junit.framework.Assert.assertEquals((Object)dnDesc1, (Object)live.get(1));
        JspHelper.sortNodeList(live, "nondfsused", "ASC");
        junit.framework.Assert.assertEquals((Object)dnDesc1, (Object)live.get(0));
        junit.framework.Assert.assertEquals((Object)dnDesc2, (Object)live.get(1));
        JspHelper.sortNodeList(live, "nondfsused", "DSC");
        junit.framework.Assert.assertEquals((Object)dnDesc2, (Object)live.get(0));
        junit.framework.Assert.assertEquals((Object)dnDesc1, (Object)live.get(1));
        JspHelper.sortNodeList(live, "remaining", "ASC");
        junit.framework.Assert.assertEquals((Object)dnDesc1, (Object)live.get(0));
        junit.framework.Assert.assertEquals((Object)dnDesc2, (Object)live.get(1));
        JspHelper.sortNodeList(live, "remaining", "DSC");
        junit.framework.Assert.assertEquals((Object)dnDesc2, (Object)live.get(0));
        junit.framework.Assert.assertEquals((Object)dnDesc1, (Object)live.get(1));
    }

    @Test
    public void testPrintMethods() throws IOException {
        JspWriter out = (JspWriter)Mockito.mock(JspWriter.class);
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        final StringBuffer buffer = new StringBuffer();
        ArgumentCaptor arg = ArgumentCaptor.forClass(String.class);
        ((JspWriter)Mockito.doAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invok) {
                Object[] args = invok.getArguments();
                buffer.append(args[0]);
                return null;
            }
        }).when((Object)out)).print((String)arg.capture());
        JspHelper.createTitle(out, req, "testfile.txt");
        ((JspWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)1))).print(Mockito.anyString());
        JspHelper.addTableHeader(out);
        ((JspWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)3))).print(Mockito.anyString());
        JspHelper.addTableRow(out, new String[]{" row11", "row12 "});
        ((JspWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)7))).print(Mockito.anyString());
        JspHelper.addTableRow(out, new String[]{" row11", "row12 "}, 3);
        ((JspWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)11))).print(Mockito.anyString());
        JspHelper.addTableRow(out, new String[]{" row21", "row22"});
        ((JspWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)15))).print(Mockito.anyString());
        JspHelper.addTableFooter(out);
        ((JspWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)16))).print(Mockito.anyString());
        Assert.assertFalse((boolean)Strings.isNullOrEmpty(buffer.toString()));
    }

    @Test
    public void testReadWriteReplicaState() {
        try {
            DataOutputBuffer out = new DataOutputBuffer();
            DataInputBuffer in = new DataInputBuffer();
            for (HdfsServerConstants.ReplicaState repState : HdfsServerConstants.ReplicaState.values()) {
                repState.write(out);
                in.reset(out.getData(), out.getLength());
                HdfsServerConstants.ReplicaState result = HdfsServerConstants.ReplicaState.read(in);
                Assert.assertTrue((String)"testReadWrite error !!!", (repState == result ? 1 : 0) != 0);
                out.reset();
                in.reset();
            }
        }
        catch (Exception ex) {
            Assert.fail((String)"testReadWrite ex error ReplicaState");
        }
    }

    @Test
    public void testUpgradeStatusReport() {
        short status = 6;
        int version = 15;
        String EXPECTED_NOTF_PATTERN = "Upgrade for version {0} has been completed.\nUpgrade is not finalized.";
        String EXPECTED_PATTERN = "Upgrade for version {0} is in progress. Status = {1}%";
        UpgradeStatusReport upgradeStatusReport = new UpgradeStatusReport(version, status, true);
        Assert.assertTrue((upgradeStatusReport.getVersion() == version ? 1 : 0) != 0);
        Assert.assertTrue((upgradeStatusReport.getUpgradeStatus() == status ? 1 : 0) != 0);
        Assert.assertTrue((boolean)upgradeStatusReport.isFinalized());
        Assert.assertEquals((Object)MessageFormat.format(EXPECTED_PATTERN, version, status), (Object)upgradeStatusReport.getStatusText(true));
        status = (short)(status + 100);
        upgradeStatusReport = new UpgradeStatusReport(version, status, false);
        Assert.assertFalse((boolean)upgradeStatusReport.isFinalized());
        Assert.assertTrue((boolean)upgradeStatusReport.toString().equals(MessageFormat.format(EXPECTED_NOTF_PATTERN, version)));
        Assert.assertTrue((boolean)upgradeStatusReport.getStatusText(false).equals(MessageFormat.format(EXPECTED_NOTF_PATTERN, version)));
        Assert.assertTrue((boolean)upgradeStatusReport.getStatusText(true).equals(MessageFormat.format(EXPECTED_NOTF_PATTERN, version)));
    }

    @Test
    public void testAuthority() {
        DatanodeID dnWithIp = new DatanodeID("127.0.0.1", "hostName", null, 50020, 50075, 50076, 50010);
        Assert.assertNotNull((Object)JspHelper.Url.authority("http", dnWithIp));
        DatanodeID dnWithNullIp = new DatanodeID(null, "hostName", null, 50020, 50075, 50076, 50010);
        Assert.assertNotNull((Object)JspHelper.Url.authority("http", dnWithNullIp));
        DatanodeID dnWithEmptyIp = new DatanodeID("", "hostName", null, 50020, 50075, 50076, 50010);
        Assert.assertNotNull((Object)JspHelper.Url.authority("http", dnWithEmptyIp));
    }

    public static class DummySecretManager
    extends AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> {
        public DummySecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        }

        @Override
        public DelegationTokenIdentifier createIdentifier() {
            return null;
        }

        @Override
        public byte[] createPassword(DelegationTokenIdentifier dtId) {
            return new byte[1];
        }
    }
}

