/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;

@InterfaceAudience.Private
public class DatanodeUtil {
    public static final String UNLINK_BLOCK_SUFFIX = ".unlinked";
    public static final String DISK_ERROR = "Possible disk error: ";

    static IOException getCauseIfDiskError(IOException ioe) {
        if (ioe.getMessage() != null && ioe.getMessage().startsWith(DISK_ERROR)) {
            return (IOException)ioe.getCause();
        }
        return null;
    }

    public static File createTmpFile(Block b, File f) throws IOException {
        boolean fileCreated;
        if (f.exists()) {
            throw new IOException("Failed to create temporary file for " + b + ".  File " + f + " should not be present, but is.");
        }
        try {
            fileCreated = f.createNewFile();
        }
        catch (IOException ioe) {
            throw new IOException("Possible disk error: Failed to create " + f, ioe);
        }
        if (!fileCreated) {
            throw new IOException("Failed to create temporary file for " + b + ".  File " + f + " should be creatable, but is already present.");
        }
        return f;
    }

    public static String getMetaName(String blockName, long generationStamp) {
        return blockName + "_" + generationStamp + ".meta";
    }

    public static File getUnlinkTmpFile(File f) {
        return new File(f.getParentFile(), f.getName() + UNLINK_BLOCK_SUFFIX);
    }
}

