/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDatanodeStartupOptions {
    private Configuration conf = null;

    private static void checkExpected(boolean expectSuccess, HdfsServerConstants.StartupOption expectedOption, Configuration conf, String ... arg) {
        String[] args = new String[arg.length];
        int i = 0;
        for (String currentArg : arg) {
            args[i++] = currentArg;
        }
        boolean returnValue = DataNode.parseArguments(args, conf);
        HdfsServerConstants.StartupOption option = DataNode.getStartupOption(conf);
        Assert.assertThat((Object)returnValue, (Matcher)Is.is((Object)expectSuccess));
        if (expectSuccess) {
            Assert.assertThat((Object)((Object)option), (Matcher)Is.is((Object)((Object)expectedOption)));
        }
    }

    @Before
    public void initConfiguration() {
        this.conf = new HdfsConfiguration();
    }

    @Test(timeout=60000L)
    public void testStartupSuccess() {
        TestDatanodeStartupOptions.checkExpected(true, HdfsServerConstants.StartupOption.REGULAR, this.conf, new String[0]);
        TestDatanodeStartupOptions.checkExpected(true, HdfsServerConstants.StartupOption.REGULAR, this.conf, "-regular");
        TestDatanodeStartupOptions.checkExpected(true, HdfsServerConstants.StartupOption.REGULAR, this.conf, "-REGULAR");
        TestDatanodeStartupOptions.checkExpected(true, HdfsServerConstants.StartupOption.ROLLBACK, this.conf, "-rollback");
    }

    @Test(timeout=60000L)
    public void testStartupFailure() {
        TestDatanodeStartupOptions.checkExpected(false, HdfsServerConstants.StartupOption.REGULAR, this.conf, "unknownoption");
        TestDatanodeStartupOptions.checkExpected(false, HdfsServerConstants.StartupOption.REGULAR, this.conf, "-regular -rollback");
    }
}

