/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAddBlock {
    private static final short REPLICATION = 3;
    private static final int BLOCKSIZE = 1024;
    private MiniDFSCluster cluster;
    private Configuration conf;

    @Before
    public void setup() throws IOException {
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", 1024L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
    }

    @After
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testAddBlock() throws Exception {
        DistributedFileSystem fs = this.cluster.getFileSystem();
        Path file1 = new Path("/file1");
        Path file2 = new Path("/file2");
        Path file3 = new Path("/file3");
        Path file4 = new Path("/file4");
        DFSTestUtil.createFile(fs, file1, 1023L, (short)3, 0L);
        DFSTestUtil.createFile(fs, file2, 1024L, (short)3, 0L);
        DFSTestUtil.createFile(fs, file3, 2047L, (short)3, 0L);
        DFSTestUtil.createFile(fs, file4, 2048L, (short)3, 0L);
        this.cluster.restartNameNode(true);
        FSDirectory fsdir = this.cluster.getNamesystem().getFSDirectory();
        INodeFile file1Node = fsdir.getINode4Write(file1.toString()).asFile();
        BlockInfo[] file1Blocks = file1Node.getBlocks();
        Assert.assertEquals((long)1L, (long)file1Blocks.length);
        Assert.assertEquals((long)1023L, (long)file1Blocks[0].getNumBytes());
        Assert.assertEquals((Object)((Object)HdfsServerConstants.BlockUCState.COMPLETE), (Object)((Object)file1Blocks[0].getBlockUCState()));
        INodeFile file2Node = fsdir.getINode4Write(file2.toString()).asFile();
        BlockInfo[] file2Blocks = file2Node.getBlocks();
        Assert.assertEquals((long)1L, (long)file2Blocks.length);
        Assert.assertEquals((long)1024L, (long)file2Blocks[0].getNumBytes());
        Assert.assertEquals((Object)((Object)HdfsServerConstants.BlockUCState.COMPLETE), (Object)((Object)file2Blocks[0].getBlockUCState()));
        INodeFile file3Node = fsdir.getINode4Write(file3.toString()).asFile();
        BlockInfo[] file3Blocks = file3Node.getBlocks();
        Assert.assertEquals((long)2L, (long)file3Blocks.length);
        Assert.assertEquals((long)1024L, (long)file3Blocks[0].getNumBytes());
        Assert.assertEquals((Object)((Object)HdfsServerConstants.BlockUCState.COMPLETE), (Object)((Object)file3Blocks[0].getBlockUCState()));
        Assert.assertEquals((long)1023L, (long)file3Blocks[1].getNumBytes());
        Assert.assertEquals((Object)((Object)HdfsServerConstants.BlockUCState.COMPLETE), (Object)((Object)file3Blocks[1].getBlockUCState()));
        INodeFile file4Node = fsdir.getINode4Write(file4.toString()).asFile();
        BlockInfo[] file4Blocks = file4Node.getBlocks();
        Assert.assertEquals((long)2L, (long)file4Blocks.length);
        Assert.assertEquals((long)1024L, (long)file4Blocks[0].getNumBytes());
        Assert.assertEquals((Object)((Object)HdfsServerConstants.BlockUCState.COMPLETE), (Object)((Object)file4Blocks[0].getBlockUCState()));
        Assert.assertEquals((long)1024L, (long)file4Blocks[1].getNumBytes());
        Assert.assertEquals((Object)((Object)HdfsServerConstants.BlockUCState.COMPLETE), (Object)((Object)file4Blocks[1].getBlockUCState()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddBlockUC() throws Exception {
        DistributedFileSystem fs = this.cluster.getFileSystem();
        Path file1 = new Path("/file1");
        DFSTestUtil.createFile(fs, file1, 1023L, (short)3, 0L);
        FSDataOutputStream out = null;
        try {
            out = fs.append(file1);
            String appendContent = "appending-content";
            out.writeBytes(appendContent);
            ((DFSOutputStream)out.getWrappedStream()).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
            this.cluster.restartNameNode(true);
            FSDirectory fsdir = this.cluster.getNamesystem().getFSDirectory();
            INodeFile fileNode = fsdir.getINode4Write(file1.toString()).asFile();
            BlockInfo[] fileBlocks = fileNode.getBlocks();
            Assert.assertEquals((long)2L, (long)fileBlocks.length);
            Assert.assertEquals((long)1024L, (long)fileBlocks[0].getNumBytes());
            Assert.assertEquals((Object)((Object)HdfsServerConstants.BlockUCState.COMPLETE), (Object)((Object)fileBlocks[0].getBlockUCState()));
            Assert.assertEquals((long)(appendContent.length() - 1), (long)fileBlocks[1].getNumBytes());
            Assert.assertEquals((Object)((Object)HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION), (Object)((Object)fileBlocks[1].getBlockUCState()));
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

